/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.support.ActionTransitionCriteria;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class TransitionCriteriaChain
implements TransitionCriteria {
    private List<TransitionCriteria> criteriaChain = new LinkedList<TransitionCriteria>();

    public TransitionCriteriaChain() {
    }

    public TransitionCriteriaChain(TransitionCriteria ... criteria) {
        this.criteriaChain.addAll(Arrays.asList(criteria));
    }

    public TransitionCriteriaChain add(TransitionCriteria criteria) {
        this.criteriaChain.add(criteria);
        return this;
    }

    @Override
    public boolean test(RequestContext context) {
        for (TransitionCriteria criteria : this.criteriaChain) {
            if (criteria.test(context)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("criteriaChain", this.criteriaChain).toString();
    }

    public static TransitionCriteria criteriaChainFor(Action ... actions) {
        if (actions == null || actions.length == 0) {
            return WildcardTransitionCriteria.INSTANCE;
        }
        TransitionCriteriaChain chain = new TransitionCriteriaChain();
        for (Action action : actions) {
            chain.add(new ActionTransitionCriteria(action));
        }
        return chain;
    }
}

