/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AccessTokenAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenAuthenticator.class);
    private final TicketRegistry ticketRegistry;
    private final JwtBuilder accessTokenJwtBuilder;
    private Set<String> requiredScopes = new LinkedHashSet<String>();

    private String extractAccessTokenFrom(TokenCredentials tokenCredentials) {
        return (String)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)OAuth20JwtAccessTokenEncoder.builder().accessTokenJwtBuilder(this.accessTokenJwtBuilder)).build().decode((Object)tokenCredentials.getToken());
    }

    public void validate(Credentials credentials, WebContext webContext, SessionStore sessionStore) {
        TokenCredentials tokenCredentials = (TokenCredentials)credentials;
        String token = this.extractAccessTokenFrom(tokenCredentials);
        LOGGER.trace("Received access token [{}] for authentication", (Object)token);
        OAuth20AccessToken accessToken = (OAuth20AccessToken)this.ticketRegistry.getTicket(token, OAuth20AccessToken.class);
        if (accessToken == null || accessToken.isExpired()) {
            LOGGER.error("Provided access token [{}] is either not found in the ticket registry or has expired", (Object)token);
            return;
        }
        if (!this.requiredScopes.isEmpty() && !accessToken.getScopes().containsAll(this.requiredScopes)) {
            LOGGER.error("Unable to authenticate access token without required scopes [{}]", this.requiredScopes);
            return;
        }
        CommonProfile profile = this.buildUserProfile(tokenCredentials, webContext, accessToken);
        if (profile != null) {
            LOGGER.trace("Final user profile based on access token [{}] is [{}]", (Object)accessToken, (Object)profile);
            tokenCredentials.setUserProfile((UserProfile)profile);
        }
    }

    protected CommonProfile buildUserProfile(TokenCredentials tokenCredentials, WebContext webContext, OAuth20AccessToken accessToken) {
        CommonProfile userProfile = new CommonProfile(true);
        Authentication authentication = accessToken.getAuthentication();
        Principal principal = authentication.getPrincipal();
        userProfile.setId(principal.getId());
        HashMap attributes = new HashMap(principal.getAttributes());
        attributes.putAll(authentication.getAttributes());
        userProfile.addAttributes(attributes);
        userProfile.addAttribute("client_id", (Object)accessToken.getClientId());
        LOGGER.trace("Built user profile based on access token [{}] is [{}]", (Object)accessToken, (Object)userProfile);
        return userProfile;
    }

    @Generated
    public OAuth20AccessTokenAuthenticator(TicketRegistry ticketRegistry, JwtBuilder accessTokenJwtBuilder) {
        this.ticketRegistry = ticketRegistry;
        this.accessTokenJwtBuilder = accessTokenJwtBuilder;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public JwtBuilder getAccessTokenJwtBuilder() {
        return this.accessTokenJwtBuilder;
    }

    @Generated
    public Set<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    @Generated
    public void setRequiredScopes(Set<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
    }
}

