/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.IOParameter;

public class InParameterParser
extends BaseChildElementParser {
    public static final List<ExtensionAttribute> defaultInParameterAttributes = Arrays.asList(new ExtensionAttribute("source"), new ExtensionAttribute("sourceType"), new ExtensionAttribute("sourceExpression"), new ExtensionAttribute("transient"), new ExtensionAttribute("target"), new ExtensionAttribute("targetType"), new ExtensionAttribute("targetExpression"), new ExtensionAttribute("variables"), new ExtensionAttribute("businessKey"));

    @Override
    public String getElementName() {
        return "in";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        String source = xtr.getAttributeValue(null, "source");
        String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
        String target = xtr.getAttributeValue(null, "target");
        if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
            IOParameter parameter = new IOParameter();
            if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                parameter.setSourceExpression(sourceExpression);
            } else {
                parameter.setSource(source);
            }
            parameter.setTarget(target);
            String transientValue = xtr.getAttributeValue(null, "transient");
            if ("true".equalsIgnoreCase(transientValue)) {
                parameter.setTransient(true);
            }
            if (parentElement instanceof CallActivity) {
                ((CallActivity)parentElement).getInParameters().add(parameter);
            } else if (parentElement instanceof CaseServiceTask) {
                ((CaseServiceTask)parentElement).getInParameters().add(parameter);
            } else if (parentElement instanceof Event) {
                ((Event)parentElement).getInParameters().add(parameter);
            }
            BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)parameter, defaultInParameterAttributes);
        } else if (parentElement instanceof CallActivity) {
            String businessKey;
            CallActivity callActivity = (CallActivity)parentElement;
            String variables = xtr.getAttributeValue(null, "variables");
            if ("all".equalsIgnoreCase(variables)) {
                callActivity.setInheritVariables(true);
                String local = xtr.getAttributeValue(null, "local");
                if (StringUtils.isNotEmpty((CharSequence)local) && "true".equalsIgnoreCase(local)) {
                    callActivity.addAttribute(new ExtensionAttribute("allInVariableslocal", "true"));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(businessKey = xtr.getAttributeValue(null, "businessKey")))) {
                callActivity.setBusinessKey(businessKey);
            }
        }
    }
}

