/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Group;
import com.google.api.services.admin.directory.model.Member;
import com.google.common.base.CharMatcher;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class GroupHandler
implements FilterVisitor<StringBuilder, Directory.Groups.List> {
    private static final Log LOG = Log.getLog(GroupHandler.class);
    private static final Escaper STRING_ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();

    public StringBuilder visitAndFilter(Directory.Groups.List list, AndFilter andFilter) {
        throw this.getException();
    }

    public StringBuilder visitContainsFilter(Directory.Groups.List list, ContainsFilter containsFilter) {
        if (!containsFilter.getAttribute().is("__MEMBERS__")) {
            throw this.getException();
        }
        list.setUserKey(containsFilter.getValue());
        return null;
    }

    protected StringBuilder getStringBuilder(Attribute attribute, char operator, Character postfix, String filedName) {
        StringBuilder builder = new StringBuilder();
        builder.append(filedName).append(operator);
        String stringValue = AttributeUtil.getAsStringValue((Attribute)attribute);
        if (StringUtil.isNotBlank((String)stringValue)) {
            stringValue = STRING_ESCAPER.escape(stringValue);
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)stringValue)) {
                builder.append('\'').append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
                builder.append('\'');
            } else {
                builder.append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
            }
        }
        return builder;
    }

    public StringBuilder visitContainsAllValuesFilter(Directory.Groups.List list, ContainsAllValuesFilter containsAllValuesFilter) {
        throw this.getException();
    }

    protected RuntimeException getException() {
        return new UnsupportedOperationException("Only EqualsFilter(['domain','customer','userKey']) and ContainsFilter('members') are supported");
    }

    public StringBuilder visitEqualsFilter(Directory.Groups.List list, EqualsFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = equalsFilter.getName();
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitEqualsIgnoreCaseFilter(Directory.Groups.List list, EqualsIgnoreCaseFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = equalsFilter.getName();
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitExtendedFilter(Directory.Groups.List list, Filter filter) {
        throw this.getException();
    }

    public StringBuilder visitGreaterThanFilter(Directory.Groups.List list, GreaterThanFilter greaterThanFilter) {
        throw this.getException();
    }

    public StringBuilder visitGreaterThanOrEqualFilter(Directory.Groups.List list, GreaterThanOrEqualFilter greaterThanOrEqualFilter) {
        throw this.getException();
    }

    public StringBuilder visitLessThanFilter(Directory.Groups.List list, LessThanFilter lessThanFilter) {
        throw this.getException();
    }

    public StringBuilder visitLessThanOrEqualFilter(Directory.Groups.List list, LessThanOrEqualFilter lessThanOrEqualFilter) {
        throw this.getException();
    }

    public StringBuilder visitNotFilter(Directory.Groups.List list, NotFilter notFilter) {
        throw this.getException();
    }

    public StringBuilder visitOrFilter(Directory.Groups.List list, OrFilter orFilter) {
        throw this.getException();
    }

    public StringBuilder visitStartsWithFilter(Directory.Groups.List list, StartsWithFilter startsWithFilter) {
        throw this.getException();
    }

    public StringBuilder visitEndsWithFilter(Directory.Groups.List list, EndsWithFilter endsWithFilter) {
        throw this.getException();
    }

    public static ObjectClassInfo getGroupClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(ObjectClass.GROUP_NAME);
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"name"));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"description"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"adminCreated", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"aliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"nonEditableAliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"directMembersCount", Long.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"__MEMBERS__").setMultiValued(true).setReturnedByDefault(false).build());
        return builder.build();
    }

    public static ObjectClassInfo getMemberClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsUtil.MEMBER.getObjectClassValue());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)Name.NAME).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"groupKey").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"email").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"role"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"type").setUpdateable(false).setCreateable(false).build());
        return builder.build();
    }

    public static Directory.Groups.Insert createGroup(Directory.Groups groups, AttributesAccessor attributes) {
        Group group = new Group();
        group.setEmail(GoogleAppsUtil.getName(attributes.getName()));
        group.setDescription(attributes.findString("description"));
        group.setName(attributes.findString("name"));
        try {
            return groups.insert(group).setFields("id,email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Groups.Patch updateGroup(Directory.Groups groups, String groupKey, AttributesAccessor attributes) {
        String stringValue;
        Attribute name;
        String stringValue2;
        Attribute description;
        String stringValue3;
        Group group = null;
        Name email = attributes.getName();
        if (email != null && null != (stringValue3 = GoogleAppsUtil.getStringValueWithDefault((Attribute)email, null))) {
            if (StringUtil.isBlank((String)stringValue3)) {
                throw new InvalidAttributeValueException("Invalid attribute '__NAME__'. The group's email address. Can not be blank when updating a group.");
            }
            group = new Group();
            group.setEmail(stringValue3);
        }
        if (null != (description = attributes.find("description")) && null != (stringValue2 = GoogleAppsUtil.getStringValueWithDefault(description, null))) {
            if (null == group) {
                group = new Group();
            }
            group.setDescription(stringValue2);
        }
        if (null != (name = attributes.find("name")) && null != (stringValue = GoogleAppsUtil.getStringValueWithDefault(name, null))) {
            if (null == group) {
                group = new Group();
            }
            group.setName(stringValue);
        }
        if (null == group) {
            return null;
        }
        try {
            return groups.patch(groupKey, group).setFields("id,email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Insert createMember(Directory.Members service, AttributesAccessor attributes) {
        String groupKey = attributes.findString("groupKey");
        if (StringUtil.isBlank((String)groupKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'groupKey'. Identifies the group in the API request. Required when creating a Member.");
        }
        String memberKey = attributes.findString("email");
        if (StringUtil.isBlank((String)memberKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'memberKey'. Identifies the group member in the API request. Required when creating a Member.");
        }
        String role = attributes.findString("role");
        return GroupHandler.createMember(service, groupKey, memberKey, role);
    }

    public static Directory.Members.Insert createMember(Directory.Members service, String groupKey, String memberKey, String role) {
        Member content = new Member();
        content.setEmail(memberKey);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.insert(groupKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Patch updateMembers(Directory.Members service, String groupKey, String memberKey, String role) {
        Member content = new Member();
        content.setEmail(memberKey);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.patch(groupKey, memberKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Delete deleteMembers(Directory.Members service, String groupKey, String memberKey) {
        try {
            return service.delete(groupKey, memberKey);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject fromMember(String groupKey, Member content) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsUtil.MEMBER);
        Uid uid = GroupHandler.generateMemberId(groupKey, content);
        builder.setUid(uid);
        builder.setName(uid.getUidValue());
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupKey", (Object[])new Object[]{content.getId()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"email", (Object[])new Object[]{content.getEmail()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"role", (Object[])new Object[]{content.getRole()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"type", (Object[])new Object[]{content.getType()})});
        return builder.build();
    }

    public static Uid generateMemberId(String groupKey, Member content) {
        String memberName = groupKey + '/' + content.getEmail();
        Uid uid = null != content.getEtag() ? new Uid(memberName, content.getEtag()) : new Uid(memberName);
        return uid;
    }
}

