/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Alias;
import com.google.api.services.admin.directory.model.Group;
import com.google.api.services.admin.directory.model.Groups;
import com.google.api.services.admin.directory.model.Member;
import com.google.api.services.admin.directory.model.Members;
import com.google.api.services.admin.directory.model.OrgUnit;
import com.google.api.services.admin.directory.model.OrgUnits;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.UserMakeAdmin;
import com.google.api.services.admin.directory.model.UserPhoto;
import com.google.api.services.admin.directory.model.Users;
import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.LicensingRequest;
import com.google.api.services.licensing.model.LicenseAssignment;
import com.google.api.services.licensing.model.LicenseAssignmentList;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.OrgunitsHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import net.tirasa.connid.bundles.googleapps.UserHandler;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.RetryableException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="GoogleApps.connector.display", configurationClass=GoogleAppsConfiguration.class)
public class GoogleAppsConnector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Filter>,
TestOp,
UpdateOp {
    private static final Log LOG = Log.getLog(GoogleAppsConnector.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private GoogleAppsConfiguration configuration;
    private Schema schema = null;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        this.configuration = (GoogleAppsConfiguration)configuration;
    }

    public void dispose() {
        this.configuration = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        Object member;
        Uid uid;
        block16: {
            AttributesAccessor accessor;
            block20: {
                Attribute isAdmin;
                Attribute photo;
                Uid uid2;
                block18: {
                    Iterator iterator;
                    Directory.Users.Aliases aliasesService;
                    block19: {
                        block17: {
                            accessor = new AttributesAccessor(createAttributes);
                            if (!ObjectClass.ACCOUNT.equals((Object)objectClass)) break block17;
                            uid2 = this.execute(UserHandler.createUser(this.configuration.getDirectory().users(), accessor, this.configuration.getCustomSchemasJSON()), new RequestResultHandler<Directory.Users.Insert, User, Uid>(){

                                @Override
                                public Uid handleResult(Directory.Users.Insert request, User value) {
                                    LOG.ok("New User is created: {0}", new Object[]{value.getId()});
                                    return new Uid(value.getId(), value.getEtag());
                                }
                            });
                            List aliases = accessor.findList("aliases");
                            if (null == aliases) break block18;
                            aliasesService = this.configuration.getDirectory().users().aliases();
                            iterator = aliases.iterator();
                            break block19;
                        }
                        if (!ObjectClass.GROUP.equals((Object)objectClass)) {
                            if (GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
                                return this.execute(GroupHandler.createMember(this.configuration.getDirectory().members(), accessor), new RequestResultHandler<Directory.Members.Insert, Member, Uid>(){

                                    @Override
                                    public Uid handleResult(Directory.Members.Insert request, Member value) {
                                        LOG.ok("New Member is created:{0}/{1}", new Object[]{request.getGroupKey(), value.getEmail()});
                                        return GroupHandler.generateMemberId(request.getGroupKey(), value);
                                    }
                                });
                            }
                            if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
                                return this.execute(OrgunitsHandler.createOrgunit(this.configuration.getDirectory().orgunits(), accessor), new RequestResultHandler<Directory.Orgunits.Insert, OrgUnit, Uid>(){

                                    @Override
                                    public Uid handleResult(Directory.Orgunits.Insert request, OrgUnit value) {
                                        LOG.ok("New OrgUnit is created:{0}", new Object[]{value.getName()});
                                        return OrgunitsHandler.generateOrgUnitId(value);
                                    }
                                });
                            }
                            if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)objectClass)) {
                                return this.execute(LicenseAssignmentsHandler.createLicenseAssignment(this.configuration.getLicensing().licenseAssignments(), accessor), new RequestResultHandler<Licensing.LicenseAssignments.Insert, LicenseAssignment, Uid>(){

                                    @Override
                                    public Uid handleResult(Licensing.LicenseAssignments.Insert request, LicenseAssignment value) {
                                        LOG.ok("LicenseAssignment is Created:{0}/{1}/{2}", new Object[]{value.getProductId(), value.getSkuId(), value.getUserId()});
                                        return LicenseAssignmentsHandler.generateLicenseAssignmentId(value);
                                    }
                                });
                            }
                            LOG.warn("Create of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(objectClass.getDisplayNameKey(), objectClass.getObjectClassValue(), new Object[0])});
                            throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
                        }
                        break block20;
                    }
                    while (iterator.hasNext()) {
                        Object member2 = iterator.next();
                        if (member2 instanceof String) {
                            String id = this.execute(UserHandler.createUserAlias(aliasesService, uid2.getUidValue(), (String)member2), new RequestResultHandler<Directory.Users.Aliases.Insert, Alias, String>(){

                                @Override
                                public String handleResult(Directory.Users.Aliases.Insert request, Alias value) {
                                    return value == null ? null : value.getId();
                                }
                            });
                            if (null == id) continue;
                            continue;
                        }
                        if (null == member2) continue;
                        RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(member2)), (Uid)uid2);
                        e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'aliases' must be a String list"));
                        throw e;
                    }
                }
                if (null != (photo = accessor.find("__PHOTO__"))) {
                    Object photoObject = AttributeUtil.getSingleValue((Attribute)photo);
                    if (photoObject instanceof byte[]) {
                        String id = this.execute(UserHandler.createUpdateUserPhoto(this.configuration.getDirectory().users().photos(), uid2.getUidValue(), (byte[])photoObject), new RequestResultHandler<Directory.Users.Photos.Update, UserPhoto, String>(){

                            @Override
                            public String handleResult(Directory.Users.Photos.Update request, UserPhoto value) {
                                return value == null ? null : value.getId();
                            }
                        });
                        if (null != id) {
                            // empty if block
                        }
                    } else if (null != photoObject) {
                        RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(photoObject)), (Uid)uid2);
                        e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'photo' must be a single Map value"));
                        throw e;
                    }
                }
                if (null == (isAdmin = accessor.find("isAdmin"))) return uid2;
                try {
                    Boolean isAdminValue = AttributeUtil.getBooleanValue((Attribute)isAdmin);
                    if (null == isAdminValue) return uid2;
                    if (isAdminValue == false) return uid2;
                    UserMakeAdmin content = new UserMakeAdmin();
                    content.setStatus(isAdminValue);
                    this.execute(this.configuration.getDirectory().users().makeAdmin(uid2.getUidValue(), content), new RequestResultHandler<Directory.Users.MakeAdmin, Void, Void>(){

                        @Override
                        public Void handleResult(Directory.Users.MakeAdmin request, Void value) {
                            return null;
                        }
                    });
                    return uid2;
                }
                catch (Exception e) {
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
            uid = this.execute(GroupHandler.createGroup(this.configuration.getDirectory().groups(), accessor), new RequestResultHandler<Directory.Groups.Insert, Group, Uid>(){

                @Override
                public Uid handleResult(Directory.Groups.Insert request, Group value) {
                    LOG.ok("New Group is created:{0}", new Object[]{value.getEmail()});
                    return new Uid(value.getEmail(), value.getEtag());
                }
            });
            List members = accessor.findList("__MEMBERS__");
            if (null == members) return uid;
            Directory.Members membersService = this.configuration.getDirectory().members();
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                member = iterator.next();
                if (member instanceof Map) {
                    String email = (String)((Map)member).get("email");
                    String role = (String)((Map)member).get("role");
                    String id = this.execute(GroupHandler.createMember(membersService, uid.getUidValue(), email, role), new RequestResultHandler<Directory.Members.Insert, Member, String>(){

                        @Override
                        public String handleResult(Directory.Members.Insert request, Member value) {
                            return value == null ? null : value.getId();
                        }
                    });
                    if (null == id) continue;
                    continue;
                }
                if (null == member) {
                    continue;
                }
                break block16;
            }
            return uid;
        }
        RetryableException e = RetryableException.wrap((String)("Invalid attribute value: " + String.valueOf(member)), (Uid)uid);
        e.initCause((Throwable)new InvalidAttributeValueException("Attribute 'members' must be a Map list"));
        throw e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(final ObjectClass objectClass, final Uid uid, OperationOptions options) {
        Directory.Users.Delete request = null;
        try {
            if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
                request = this.configuration.getDirectory().users().delete(uid.getUidValue());
            } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
                request = this.configuration.getDirectory().groups().delete(uid.getUidValue());
            } else if (GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
                String[] ids = uid.getUidValue().split("/");
                if (ids.length != 2) throw new UnknownUidException("Invalid ID format");
                request = this.configuration.getDirectory().members().delete(ids[0], ids[1]);
            } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
                request = this.configuration.getDirectory().orgunits().delete("my_customer", CollectionUtil.newList((Object[])new String[]{uid.getUidValue()}));
            } else if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)objectClass)) {
                request = LicenseAssignmentsHandler.deleteLicenseAssignment(this.configuration.getLicensing().licenseAssignments(), uid.getUidValue());
            }
        }
        catch (IOException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        if (null == request) {
            LOG.warn("Delete of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(objectClass.getDisplayNameKey(), objectClass.getObjectClassValue(), new Object[0])});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
        this.execute((AbstractGoogleJsonClientRequest)request, new RequestResultHandler<AbstractGoogleJsonClientRequest<Void>, Void, Void>(){

            @Override
            public Void handleResult(AbstractGoogleJsonClientRequest<Void> request, Void value) {
                return null;
            }

            @Override
            public Void handleNotFound(IOException e) {
                throw new UnknownUidException(uid, objectClass);
            }
        });
    }

    public Schema schema() {
        if (null == this.schema) {
            SchemaBuilder builder = new SchemaBuilder(GoogleAppsConnector.class);
            ObjectClassInfo user = UserHandler.getUserClassInfo(this.configuration.getCustomSchemasJSON());
            builder.defineObjectClass(user);
            ObjectClassInfo group = GroupHandler.getGroupClassInfo();
            builder.defineObjectClass(group);
            ObjectClassInfo member = GroupHandler.getMemberClassInfo();
            builder.defineObjectClass(member);
            ObjectClassInfo orgUnit = OrgunitsHandler.getOrgunitClassInfo();
            builder.defineObjectClass(orgUnit);
            ObjectClassInfo licenseAssignment = LicenseAssignmentsHandler.getLicenseAssignmentClassInfo();
            builder.defineObjectClass(licenseAssignment);
            builder.defineOperationOption(OperationOptionInfoBuilder.buildAttributesToGet(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildPageSize(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildPagedResultsCookie(), new Class[]{SearchOp.class});
            builder.defineOperationOption(OperationOptionInfoBuilder.buildSortKeys(), new Class[]{SearchOp.class});
            builder.defineOperationOption(new OperationOptionInfo("showDeleted", Boolean.class), new Class[]{SearchOp.class});
            this.schema = builder.build();
        }
        return this.schema;
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return xva$0 -> CollectionUtil.newList((Object[])new Filter[]{xva$0});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQuery(ObjectClass objectClass, Filter query, final ResultsHandler handler, OperationOptions options) {
        Attribute key;
        Set<String> attributesToGet;
        block72: {
            block73: {
                attributesToGet = this.getAttributesToGet(objectClass, options);
                key = this.getKeyFromFilter(objectClass, query);
                if (!ObjectClass.ACCOUNT.equals((Object)objectClass)) break block72;
                if (null != key && null != key.getValue() && !key.getValue().isEmpty() && null != key.getValue().get(0)) break block73;
                try {
                    boolean paged;
                    Directory.Users.List request;
                    block74: {
                        request = this.configuration.getDirectory().users().list();
                        if (null != query) {
                            StringBuilder queryBuilder = (StringBuilder)query.accept((FilterVisitor)new UserHandler(), (Object)request);
                            if (null != queryBuilder) {
                                String queryString = queryBuilder.toString();
                                LOG.ok("Executing Query: {0}", new Object[]{queryString});
                                request.setQuery(queryString);
                            }
                            if (null == request.getDomain() && null == request.getCustomer()) {
                                request.setCustomer("my_customer");
                            }
                        } else {
                            request.setCustomer("my_customer");
                        }
                        paged = false;
                        if (options.getPageSize() != null && 0 < options.getPageSize()) {
                            if (options.getPageSize() < 1 || options.getPageSize() > 500) throw new IllegalArgumentException("Invalid pageSize value. Default is 100. Max allowed is 500 (integer, 1-500)");
                            request.setMaxResults(options.getPageSize());
                            paged = true;
                        }
                        request.setPageToken(options.getPagedResultsCookie());
                        request.setProjection(this.configuration.getProjection());
                        String fields = this.getFields(options, "id", "etag", "primaryEmail");
                        if (null != fields) {
                            request.setFields("nextPageToken,users(" + fields + ")");
                        }
                        if (options.getOptions().get("showDeleted") instanceof Boolean) {
                            request.setShowDeleted(options.getOptions().get("showDeleted").toString());
                        }
                        if (null == options.getSortKeys()) break block74;
                        for (SortKey sortKey : options.getSortKeys()) {
                            block78: {
                                String orderBy;
                                block76: {
                                    block77: {
                                        block75: {
                                            if (!sortKey.getField().equalsIgnoreCase("email") && !sortKey.getField().equalsIgnoreCase("primaryEmail") && !sortKey.getField().equalsIgnoreCase("aliases") && !sortKey.getField().equalsIgnoreCase("alias")) break block75;
                                            orderBy = "email";
                                            break block76;
                                        }
                                        if (!sortKey.getField().equalsIgnoreCase("givenName")) break block77;
                                        orderBy = "givenName";
                                        break block76;
                                    }
                                    if (sortKey.getField().equalsIgnoreCase("familyName")) {
                                        orderBy = "familyName";
                                    }
                                    break block78;
                                }
                                request.setOrderBy(orderBy);
                                if (sortKey.isAscendingOrder()) {
                                    request.setSortOrder("ASCENDING");
                                    break;
                                }
                                request.setSortOrder("DESCENDING");
                                break;
                            }
                            LOG.ok("Unsupported SortKey:{0}", new Object[]{sortKey});
                        }
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = this.execute(request, new RequestResultHandler<Directory.Users.List, Users, String>(){

                            @Override
                            public String handleResult(Directory.Users.List request, Users value) {
                                if (null != value.getUsers()) {
                                    for (User user : value.getUsers()) {
                                        handler.handle(GoogleAppsConnector.this.fromUser(user, attributesToGet, GoogleAppsConnector.this.configuration.getDirectory().groups()));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested and next token is:{0}", new Object[]{nextPageToken});
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
            try {
                Directory.Users.Get request = this.configuration.getDirectory().users().get((String)key.getValue().get(0));
                request.setFields(this.getFields(options, "id", "etag", "primaryEmail"));
                request.setProjection(this.configuration.getProjection());
                this.execute(request, new RequestResultHandler<Directory.Users.Get, User, Boolean>(){

                    @Override
                    public Boolean handleResult(Directory.Users.Get request, User user) {
                        return handler.handle(GoogleAppsConnector.this.fromUser(user, attributesToGet, GoogleAppsConnector.this.configuration.getDirectory().groups()));
                    }

                    @Override
                    public Boolean handleNotFound(IOException e) {
                        return true;
                    }
                });
                return;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e, "Failed to initialize Users#Get", new Object[0]);
                throw ConnectorException.wrap((Throwable)e);
            }
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (null == key) {
                try {
                    Directory.Groups.List request = this.configuration.getDirectory().groups().list();
                    if (null != query) {
                        StringBuilder queryBuilder = (StringBuilder)query.accept((FilterVisitor)new GroupHandler(), (Object)request);
                        if (null != queryBuilder) {
                            String queryString = queryBuilder.toString();
                            LOG.ok("Executing Query: {0}", new Object[]{queryString});
                            request.setQuery(queryString);
                        }
                        if (null == request.getDomain() && null == request.getCustomer()) {
                            request.setCustomer("my_customer");
                        }
                    } else {
                        request.setCustomer("my_customer");
                    }
                    boolean paged = false;
                    if (options.getPageSize() != null && 0 < options.getPageSize()) {
                        request.setMaxResults(options.getPageSize());
                        paged = true;
                    }
                    request.setPageToken(options.getPagedResultsCookie());
                    String fields = this.getFields(options, "id", "etag", "email");
                    if (null != fields) {
                        request.setFields("nextPageToken,groups(" + fields + ")");
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = this.execute(request, new RequestResultHandler<Directory.Groups.List, Groups, String>(){

                            @Override
                            public String handleResult(Directory.Groups.List request, Groups value) {
                                if (null != value.getGroups()) {
                                    for (Group group : value.getGroups()) {
                                        handler.handle(GoogleAppsConnector.this.fromGroup(group, attributesToGet, GoogleAppsConnector.this.configuration.getDirectory().members()));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Directory.Groups.Get request = this.configuration.getDirectory().groups().get((String)key.getValue().get(0));
                    request.setFields(this.getFields(options, "id", "etag", "email"));
                    this.execute(request, new RequestResultHandler<Directory.Groups.Get, Group, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Groups.Get request, Group value) {
                            return handler.handle(GoogleAppsConnector.this.fromGroup(value, attributesToGet, GoogleAppsConnector.this.configuration.getDirectory().members()));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
            if (null == key) {
                try {
                    String groupKey = null;
                    if (!(query instanceof EqualsFilter) || !((EqualsFilter)query).getAttribute().is("groupKey")) {
                        throw new UnsupportedOperationException("Only EqualsFilter('groupKey') is supported");
                    }
                    groupKey = AttributeUtil.getStringValue((Attribute)((AttributeFilter)query).getAttribute());
                    if (StringUtil.isBlank((String)groupKey)) {
                        throw new InvalidAttributeValueException("The 'groupKey' can not be blank.");
                    }
                    Directory.Members.List request = this.configuration.getDirectory().members().list(groupKey);
                    boolean paged = false;
                    if (options.getPageSize() != null && 0 < options.getPageSize()) {
                        request.setMaxResults(options.getPageSize());
                        paged = true;
                    }
                    request.setPageToken(options.getPagedResultsCookie());
                    String nextPageToken = null;
                    do {
                        nextPageToken = this.execute(request, new RequestResultHandler<Directory.Members.List, Members, String>(){

                            @Override
                            public String handleResult(Directory.Members.List request, Members value) {
                                if (null != value.getMembers()) {
                                    for (Member group : value.getMembers()) {
                                        handler.handle(GroupHandler.fromMember(request.getGroupKey(), group));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        request.setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    String[] ids = ((Uid)key).getUidValue().split("/");
                    if (ids.length != 2) {
                        throw new InvalidAttributeValueException("Unrecognised UID format");
                    }
                    Directory.Members.Get request = this.configuration.getDirectory().members().get(ids[0], ids[1]);
                    this.execute(request, new RequestResultHandler<Directory.Members.Get, Member, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Members.Get request, Member value) {
                            return handler.handle(GroupHandler.fromMember(request.getGroupKey(), value));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
            if (null == key) {
                try {
                    Directory.Orgunits.List request = this.configuration.getDirectory().orgunits().list("my_customer");
                    if (null != query) {
                        if (!(query instanceof StartsWithFilter) || !AttributeUtil.namesEqual((String)"orgUnitPath", (String)((StartsWithFilter)query).getName())) throw new UnsupportedOperationException("Only StartsWithFilter('orgUnitPath') is supported");
                        request.setOrgUnitPath(((StartsWithFilter)query).getValue());
                    } else {
                        request.setOrgUnitPath("/");
                    }
                    String scope = options.getScope();
                    if ("object".equalsIgnoreCase(scope) || "onelevel".equalsIgnoreCase(scope)) {
                        request.setType("children");
                    } else {
                        request.setType("all");
                    }
                    String fields = this.getFields(options, "orgUnitPath", "etag", "name");
                    if (null != fields) {
                        request.setFields("organizationUnits(" + fields + ")");
                    }
                    this.execute(request, new RequestResultHandler<Directory.Orgunits.List, OrgUnits, Void>(){

                        @Override
                        public Void handleResult(Directory.Orgunits.List request, OrgUnits value) {
                            if (null != value.getOrganizationUnits()) {
                                for (OrgUnit group : value.getOrganizationUnits()) {
                                    handler.handle(OrgunitsHandler.fromOrgunit(group, attributesToGet));
                                }
                            }
                            return null;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize OrgUnits#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Directory.Orgunits.Get request = this.configuration.getDirectory().orgunits().get("my_customer", Arrays.asList((String)key.getValue().get(0)));
                    request.setFields(this.getFields(options, "orgUnitPath", "etag", "name"));
                    this.execute(request, new RequestResultHandler<Directory.Orgunits.Get, OrgUnit, Boolean>(){

                        @Override
                        public Boolean handleResult(Directory.Orgunits.Get request, OrgUnit value) {
                            return handler.handle(OrgunitsHandler.fromOrgunit(value, attributesToGet));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize OrgUnits#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)objectClass)) {
            if (null == key) {
                try {
                    Licensing.LicenseAssignments.ListForProduct r;
                    String productId = "";
                    String skuId = "";
                    boolean paged = false;
                    Licensing.LicenseAssignments.ListForProduct request = null;
                    if (StringUtil.isBlank((String)productId)) {
                        throw new ConnectorException("productId is required");
                    }
                    if (StringUtil.isBlank((String)skuId)) {
                        r = this.configuration.getLicensing().licenseAssignments().listForProduct(productId, "my_customer");
                        if (options.getPageSize() != null && 0 < options.getPageSize()) {
                            r.setMaxResults(Long.valueOf(options.getPageSize().intValue()));
                            paged = true;
                        }
                        r.setPageToken(options.getPagedResultsCookie());
                        request = r;
                    } else {
                        r = this.configuration.getLicensing().licenseAssignments().listForProductAndSku(productId, skuId, "my_customer");
                        if (options.getPageSize() != null && 0 < options.getPageSize()) {
                            r.setMaxResults(Long.valueOf(options.getPageSize().intValue()));
                            paged = true;
                        }
                        r.setPageToken(options.getPagedResultsCookie());
                        request = r;
                    }
                    String nextPageToken = null;
                    do {
                        nextPageToken = this.execute((AbstractGoogleJsonClientRequest)request, new RequestResultHandler<LicensingRequest<LicenseAssignmentList>, LicenseAssignmentList, String>(){

                            @Override
                            public String handleResult(LicensingRequest<LicenseAssignmentList> request, LicenseAssignmentList value) {
                                if (null != value.getItems()) {
                                    for (LicenseAssignment resource : value.getItems()) {
                                        handler.handle(LicenseAssignmentsHandler.fromLicenseAssignment(resource));
                                    }
                                }
                                return value.getNextPageToken();
                            }
                        });
                        if (request instanceof Licensing.LicenseAssignments.ListForProduct) {
                            request.setPageToken(nextPageToken);
                            continue;
                        }
                        ((Licensing.LicenseAssignments.ListForProductAndSku)request).setPageToken(nextPageToken);
                    } while (!paged && StringUtil.isNotBlank((String)nextPageToken));
                    if (!paged || !StringUtil.isNotBlank((String)nextPageToken)) return;
                    LOG.info("Paged Search was requested", new Object[0]);
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(nextPageToken, 0));
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#List", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            } else {
                try {
                    Matcher name = LicenseAssignmentsHandler.LICENSE_NAME_PATTERN.matcher(((Uid)key).getUidValue());
                    if (!name.matches()) {
                        return;
                    }
                    String productId = name.group(0);
                    String skuId = name.group(1);
                    String userId = name.group(2);
                    Licensing.LicenseAssignments.Get request = this.configuration.getLicensing().licenseAssignments().get(productId, skuId, userId);
                    this.execute(request, new RequestResultHandler<Licensing.LicenseAssignments.Get, LicenseAssignment, Boolean>(){

                        @Override
                        public Boolean handleResult(Licensing.LicenseAssignments.Get request, LicenseAssignment value) {
                            return handler.handle(LicenseAssignmentsHandler.fromLicenseAssignment(value));
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e, "Failed to initialize Groups#Get", new Object[0]);
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(objectClass.getDisplayNameKey(), objectClass.getObjectClassValue(), new Object[0])});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    protected Attribute getKeyFromFilter(ObjectClass objectClass, Filter filter) {
        Attribute key = null;
        if (filter instanceof EqualsFilter) {
            Attribute filterAttr = ((EqualsFilter)filter).getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass) && (filterAttr instanceof Name || filterAttr.getName().equalsIgnoreCase("aliases"))) {
                key = filterAttr;
            } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass) && filterAttr.getName().equalsIgnoreCase("orgUnitPath")) {
                key = filterAttr;
            } else if (ObjectClass.GROUP.equals((Object)objectClass) && filterAttr.is("email")) {
                key = filterAttr;
            }
        } else if (filter instanceof AndFilter && GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
            Attribute groupKey = null;
            Attribute memberKey = null;
            StringBuilder memberId = new StringBuilder();
            Collection filters = ((AndFilter)filter).getFilters();
            for (Filter f : filters) {
                if (f instanceof EqualsFilter) {
                    Attribute filterAttr = ((EqualsFilter)f).getAttribute();
                    if (filterAttr.getName().equalsIgnoreCase("groupKey")) {
                        groupKey = filterAttr;
                        continue;
                    }
                    if (filterAttr.getName().equalsIgnoreCase("email") || filterAttr.getName().equalsIgnoreCase("alias") || filterAttr instanceof Uid) {
                        memberKey = filterAttr;
                        continue;
                    }
                    throw new UnsupportedOperationException("Only AndFilter('groupKey','memberKey') is supported");
                }
                throw new UnsupportedOperationException("Only AndFilter('groupKey','memberKey') is supported");
            }
            if (memberKey != null && groupKey != null) {
                memberId.append(groupKey.getValue().get(0));
                memberId.append("/");
                memberId.append(memberKey.getValue().get(0));
                key = new Uid(memberId.toString());
            }
        }
        return key;
    }

    protected Set<String> getAttributesToGet(ObjectClass objectClass, OperationOptions options) {
        SortedSet attributesToGet = null;
        if (null != options.getAttributesToGet()) {
            attributesToGet = CollectionUtil.newCaseInsensitiveSet();
            if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
                attributesToGet.add("orgUnitPath");
            } else {
                attributesToGet.add("id");
            }
            attributesToGet.add("etag");
            for (String attribute : options.getAttributesToGet()) {
                int i = attribute.indexOf(47);
                if (i == 0) {
                    attribute = attribute.substring(1);
                    i = attribute.indexOf(47);
                }
                int j = attribute.indexOf(40);
                if (i < 0 && j < 0) {
                    attributesToGet.add(attribute);
                    continue;
                }
                if (i == 0 || j == 0) {
                    throw new IllegalArgumentException("Invalid attribute name to get:/" + attribute);
                }
                int l = attribute.length();
                if (i > 0) {
                    l = Math.min(l, i);
                }
                if (j > 0) {
                    l = Math.min(l, j);
                }
                attributesToGet.add(attribute.substring(0, l));
            }
        }
        return attributesToGet;
    }

    protected String googleName(ObjectClass objectClass, String attributeName) {
        if (AttributeUtil.namesEqual((String)Name.NAME, (String)attributeName)) {
            if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
                return "primaryEmail";
            }
            if (ObjectClass.GROUP.equals((Object)objectClass)) {
                return "email";
            }
            return "name";
        }
        if (AttributeUtil.namesEqual((String)"description", (String)attributeName)) {
            return "description";
        }
        if (AttributeUtil.namesEqual((String)"familyName", (String)attributeName)) {
            return "name/familyName";
        }
        if (AttributeUtil.namesEqual((String)"givenName", (String)attributeName)) {
            return "name/givenName";
        }
        if (AttributeUtil.namesEqual((String)"fullName", (String)attributeName)) {
            return "name/fullName";
        }
        return attributeName;
    }

    protected Set<String> getAttributesToGet(OperationOptions options) {
        SortedSet attributesToGet = null;
        if (null != options.getAttributesToGet()) {
            attributesToGet = CollectionUtil.newCaseInsensitiveSet();
            for (String attribute : options.getAttributesToGet()) {
                StringBuilder builder = new StringBuilder();
                block5: for (int i = 0; i < attribute.length(); ++i) {
                    char c = attribute.charAt(i);
                    switch (c) {
                        case '/': {
                            if (i == 0) continue block5;
                            if (i != 1) break block5;
                            throw new IllegalArgumentException("Invalid attribute name to get:" + attribute);
                        }
                        case '(': {
                            if (i != 0) break block5;
                            throw new IllegalArgumentException("Invalid attribute name to get:" + attribute);
                        }
                        default: {
                            builder.append(c);
                        }
                    }
                }
                attributesToGet.add(builder.toString());
            }
        }
        return attributesToGet;
    }

    protected String getFields(OperationOptions options, String ... nameAttribute) {
        if (null != options.getAttributesToGet()) {
            SortedSet attributes = CollectionUtil.newCaseInsensitiveSet();
            attributes.addAll(Arrays.asList(nameAttribute));
            boolean notBlankCustomSchemas = StringUtil.isNotBlank((String)this.configuration.getCustomSchemasJSON());
            ArrayList customSchemaNames = notBlankCustomSchemas ? this.customSchemaNames(this.configuration.getCustomSchemasJSON()) : new ArrayList();
            for (String attribute : options.getAttributesToGet()) {
                if (AttributeUtil.namesEqual((String)"description", (String)attribute)) {
                    attributes.add("description");
                } else if (!AttributeUtil.isSpecialName((String)attribute)) {
                    if (AttributeUtil.namesEqual((String)"familyName", (String)attribute)) {
                        attributes.add("name/familyName");
                    } else if (AttributeUtil.namesEqual((String)"givenName", (String)attribute)) {
                        attributes.add("name/givenName");
                    } else if (AttributeUtil.namesEqual((String)"fullName", (String)attribute)) {
                        attributes.add("name/fullName");
                    } else if (!customSchemaNames.contains(attribute)) {
                        attributes.add(attribute);
                    }
                }
                if (!"full".equals(this.configuration.getProjection()) || !notBlankCustomSchemas) continue;
                attributes.add("customSchemas");
            }
            return StringUtil.join((Collection)attributes, (char)',');
        }
        return null;
    }

    public void test() {
        LOG.ok("Test works well", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        AttributesAccessor attributesAccessor = new AttributesAccessor(replaceAttributes);
        Uid uidAfterUpdate = uid;
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            String[] service;
            Attribute groups;
            Directory.Users.Patch patch = UserHandler.updateUser(this.configuration.getDirectory().users(), uid.getUidValue(), attributesAccessor, this.configuration.getCustomSchemasJSON());
            if (null != patch) {
                uidAfterUpdate = this.execute(patch, new RequestResultHandler<Directory.Users.Patch, User, Uid>(){

                    @Override
                    public Uid handleResult(Directory.Users.Patch request, User value) {
                        LOG.ok("User is Updated:{0}", new Object[]{value.getId()});
                        return new Uid(value.getId(), value.getEtag());
                    }
                });
            }
            if (null != (groups = attributesAccessor.find(PredefinedAttributes.GROUPS_NAME)) && null != groups.getValue()) {
                service = this.configuration.getDirectory().members();
                if (groups.getValue().isEmpty()) {
                    for (String groupKey : this.listGroups(this.configuration.getDirectory().groups(), uidAfterUpdate.getUidValue())) {
                        this.execute(GroupHandler.deleteMembers((Directory.Members)service, groupKey, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                            @Override
                            public Object handleResult(Directory.Members.Delete request, Void value) {
                                return null;
                            }

                            @Override
                            public Object handleNotFound(IOException e) {
                                return null;
                            }
                        });
                    }
                } else {
                    Set<String> activeGroups = this.listGroups(this.configuration.getDirectory().groups(), uidAfterUpdate.getUidValue());
                    ArrayList<Directory.Members.Insert> addGroups = new ArrayList<Directory.Members.Insert>();
                    SortedSet keepGroups = CollectionUtil.newCaseInsensitiveSet();
                    for (Object e : groups.getValue()) {
                        if (e instanceof String) {
                            if (activeGroups.contains((String)e)) {
                                keepGroups.add((String)e);
                                continue;
                            }
                            String email = attributesAccessor.getName().getNameValue();
                            addGroups.add(GroupHandler.createMember((Directory.Members)service, (String)e, email, null));
                            continue;
                        }
                        if (null == e) continue;
                        throw new InvalidAttributeValueException("Attribute '__GROUPS__' must be a String list");
                    }
                    for (Directory.Members.Insert insert : addGroups) {
                        this.execute(insert, new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                            @Override
                            public Object handleResult(Directory.Members.Insert request, Member value) {
                                return null;
                            }

                            @Override
                            public Object handleDuplicate(IOException e) {
                                return null;
                            }
                        });
                    }
                    if (activeGroups.removeAll(keepGroups)) {
                        for (String string : activeGroups) {
                            this.execute(GroupHandler.deleteMembers((Directory.Members)service, string, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                                @Override
                                public Object handleResult(Directory.Members.Delete request, Void value) {
                                    return null;
                                }

                                @Override
                                public Object handleNotFound(IOException e) {
                                    return null;
                                }
                            });
                        }
                    }
                }
            }
            if (!this.configuration.getRemoveLicenseOnDisable()) return uidAfterUpdate;
            if (!attributesAccessor.hasAttribute(OperationalAttributes.ENABLE_NAME)) return uidAfterUpdate;
            if (attributesAccessor.findBoolean(OperationalAttributes.ENABLE_NAME) != false) return uidAfterUpdate;
            if (!StringUtil.isNotBlank((String)attributesAccessor.findString("primaryEmail"))) return uidAfterUpdate;
            service = this.configuration.getSkuIds();
            int activeGroups = service.length;
            int addGroups = 0;
            while (addGroups < activeGroups) {
                String skuId = service[addGroups];
                try {
                    Licensing.LicenseAssignments.Get request = this.configuration.getLicensing().licenseAssignments().get(this.configuration.getProductId(), skuId, attributesAccessor.findString("primaryEmail"));
                    this.execute(request, new RequestResultHandler<Licensing.LicenseAssignments.Get, LicenseAssignment, Boolean>(){

                        @Override
                        public Boolean handleResult(Licensing.LicenseAssignments.Get request, LicenseAssignment value) {
                            try {
                                GoogleAppsConnector.this.delete(GoogleAppsUtil.LICENSE_ASSIGNMENT, new Uid(GoogleAppsUtil.generateLicenseId(value.getProductId(), value.getSkuId(), value.getUserId())), null);
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e, "Failed to delete license for user {0}", new Object[]{value.getUserId()});
                                throw ConnectorException.wrap((Throwable)e);
                            }
                            return true;
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error((Throwable)e, "Unable to find license for {0}-{1}-{2}", new Object[]{this.configuration.getProductId(), skuId, attributesAccessor.findString("primaryEmail")});
                }
                ++addGroups;
            }
            return uidAfterUpdate;
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            Attribute members;
            Directory.Groups.Patch patch = GroupHandler.updateGroup(this.configuration.getDirectory().groups(), uid.getUidValue(), attributesAccessor);
            if (null != patch) {
                uidAfterUpdate = this.execute(patch, new RequestResultHandler<Directory.Groups.Patch, Group, Uid>(){

                    @Override
                    public Uid handleResult(Directory.Groups.Patch request, Group value) {
                        LOG.ok("Group is Updated:{0}", new Object[]{value.getEmail()});
                        return new Uid(value.getEmail(), value.getEtag());
                    }
                });
            }
            if (null == (members = attributesAccessor.find("__MEMBERS__"))) return uidAfterUpdate;
            if (null == members.getValue()) return uidAfterUpdate;
            Directory.Members service = this.configuration.getDirectory().members();
            if (members.getValue().isEmpty()) {
                Iterator<Map<String, String>> activeGroups = this.listMembers(service, uidAfterUpdate.getUidValue(), null).iterator();
                while (activeGroups.hasNext()) {
                    Map<String, String> member = activeGroups.next();
                    this.execute(GroupHandler.deleteMembers(service, uidAfterUpdate.getUidValue(), member.get("email")), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                        @Override
                        public Object handleResult(Directory.Members.Delete request, Void value) {
                            return null;
                        }

                        @Override
                        public Object handleNotFound(IOException e) {
                            return null;
                        }
                    });
                }
                return uidAfterUpdate;
            }
            List<Map<String, String>> activeMembership = this.listMembers(service, uidAfterUpdate.getUidValue(), null);
            ArrayList<Directory.Members.Insert> addMembership = new ArrayList<Directory.Members.Insert>();
            ArrayList<Directory.Members.Patch> patchMembership = new ArrayList<Directory.Members.Patch>();
            for (Object e : members.getValue()) {
                if (e instanceof Map) {
                    String email = (String)((Map)e).get("email");
                    if (null == email) continue;
                    String role = (String)((Map)e).get("role");
                    if (null == role) {
                        role = "MEMBER";
                    }
                    boolean notMember = true;
                    for (Map<String, String> a : activeMembership) {
                        if (!email.equalsIgnoreCase(a.get("email"))) continue;
                        a.put("keep", null);
                        if (!role.equalsIgnoreCase(a.get("role"))) {
                            patchMembership.add(GroupHandler.updateMembers(service, uidAfterUpdate.getUidValue(), email, role));
                        }
                        notMember = false;
                        break;
                    }
                    if (!notMember) continue;
                    addMembership.add(GroupHandler.createMember(service, uidAfterUpdate.getUidValue(), email, role));
                    continue;
                }
                if (null == e) continue;
                throw new InvalidAttributeValueException("Attribute 'members' must be a Map list");
            }
            for (Directory.Members.Insert insert : addMembership) {
                this.execute(insert, new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                    @Override
                    public Object handleResult(Directory.Members.Insert request, Member value) {
                        return null;
                    }

                    @Override
                    public Object handleDuplicate(IOException e) {
                        return null;
                    }
                });
            }
            for (Directory.Members.Patch patch2 : patchMembership) {
                this.execute(patch2, new RequestResultHandler<Directory.Members.Patch, Member, Object>(){

                    @Override
                    public Object handleResult(Directory.Members.Patch request, Member value) {
                        return null;
                    }
                });
            }
            Iterator<Object> iterator = activeMembership.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (map.containsKey("keep")) continue;
                this.execute(GroupHandler.deleteMembers(service, uidAfterUpdate.getUidValue(), (String)map.get("email")), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                    @Override
                    public Object handleResult(Directory.Members.Delete request, Void value) {
                        return null;
                    }

                    @Override
                    public Object handleNotFound(IOException e) {
                        return null;
                    }
                });
            }
            return uidAfterUpdate;
        }
        if (GoogleAppsUtil.MEMBER.equals((Object)objectClass)) {
            String role = attributesAccessor.findString("role");
            if (!StringUtil.isNotBlank((String)role)) return uidAfterUpdate;
            String[] ids = uid.getUidValue().split("/");
            if (ids.length != 2) throw new UnknownUidException("Invalid ID format");
            Directory.Members.Patch patch = GroupHandler.updateMembers(this.configuration.getDirectory().members(), ids[0], ids[1], role).setFields("email,etag");
            return this.execute(patch, new RequestResultHandler<Directory.Members.Patch, Member, Uid>(){

                @Override
                public Uid handleResult(Directory.Members.Patch request, Member value) {
                    LOG.ok("Member is updated:{0}/{1}", new Object[]{request.getGroupKey(), value.getEmail()});
                    return GroupHandler.generateMemberId(request.getGroupKey(), value);
                }
            });
        }
        if (GoogleAppsUtil.ORG_UNIT.equals((Object)objectClass)) {
            Directory.Orgunits.Patch patch = OrgunitsHandler.updateOrgunit(this.configuration.getDirectory().orgunits(), uid.getUidValue(), attributesAccessor);
            if (null == patch) return uidAfterUpdate;
            return this.execute(patch, new RequestResultHandler<Directory.Orgunits.Patch, OrgUnit, Uid>(){

                @Override
                public Uid handleResult(Directory.Orgunits.Patch request, OrgUnit value) {
                    LOG.ok("OrgUnit is updated:{0}", new Object[]{value.getName()});
                    return OrgunitsHandler.generateOrgUnitId(value);
                }
            });
        }
        if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)objectClass)) {
            Licensing.LicenseAssignments.Patch patch = LicenseAssignmentsHandler.updateLicenseAssignment(this.configuration.getLicensing().licenseAssignments(), uid.getUidValue(), attributesAccessor);
            if (null == patch) return uidAfterUpdate;
            return this.execute(patch, new RequestResultHandler<Licensing.LicenseAssignments.Patch, LicenseAssignment, Uid>(){

                @Override
                public Uid handleResult(Licensing.LicenseAssignments.Patch request, LicenseAssignment value) {
                    LOG.ok("LicenseAssignment is Updated:{0}/{1}/{2}", new Object[]{value.getProductId(), value.getSkuId(), value.getUserId()});
                    return LicenseAssignmentsHandler.generateLicenseAssignmentId(value);
                }
            });
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(objectClass.getDisplayNameKey(), objectClass.getObjectClassValue(), new Object[0])});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    protected ConnectorObject fromUser(User user, Set<String> attributesToGet, Directory.Groups service) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        if (null != user.getEtag()) {
            builder.setUid(new Uid(user.getId(), user.getEtag()));
        } else {
            builder.setUid(user.getId());
        }
        builder.setName(user.getPrimaryEmail());
        if (user.getSuspended() != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)OperationalAttributes.ENABLE_NAME, (Object[])new Object[]{user.getSuspended() == false})});
        }
        if (null == attributesToGet || attributesToGet.contains("id")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"id", (Object[])new Object[]{user.getId()})});
        }
        if (null == attributesToGet || attributesToGet.contains("primaryEmail")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"primaryEmail", (Object[])new Object[]{user.getPrimaryEmail()})});
        }
        if (null == attributesToGet || attributesToGet.contains("givenName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"givenName", (Object[])new Object[]{null != user.getName() ? user.getName().getGivenName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("familyName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"familyName", (Object[])new Object[]{null != user.getName() ? user.getName().getFamilyName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("fullName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"fullName", (Object[])new Object[]{null != user.getName() ? user.getName().getFullName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("isAdmin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isAdmin", (Object[])new Object[]{user.getIsAdmin()})});
        }
        if (null == attributesToGet || attributesToGet.contains("isDelegatedAdmin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isDelegatedAdmin", (Object[])new Object[]{user.getIsDelegatedAdmin()})});
        }
        if ((null == attributesToGet || attributesToGet.contains("lastLoginTime")) && user.getLastLoginTime() != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"lastLoginTime", (Object[])new Object[]{user.getLastLoginTime().toString()})});
        }
        if ((null == attributesToGet || attributesToGet.contains("creationTime")) && user.getCreationTime() != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"creationTime", (Object[])new Object[]{user.getCreationTime().toString()})});
        }
        if (null == attributesToGet || attributesToGet.contains("agreedToTerms")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"agreedToTerms", (Object[])new Object[]{user.getAgreedToTerms()})});
        }
        if (null == attributesToGet || attributesToGet.contains("suspensionReason")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"suspensionReason", (Object[])new Object[]{user.getSuspensionReason()})});
        }
        if (null == attributesToGet || attributesToGet.contains("changePasswordAtNextLogin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"changePasswordAtNextLogin", (Object[])new Object[]{user.getChangePasswordAtNextLogin()})});
        }
        if (null == attributesToGet || attributesToGet.contains("ipWhitelisted")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"ipWhitelisted", (Object[])new Object[]{user.getIpWhitelisted()})});
        }
        if (null == attributesToGet || attributesToGet.contains("ims")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"ims", (Collection)((Collection)user.getIms()))});
        }
        if (null == attributesToGet || attributesToGet.contains("emails")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"emails", (Collection)((Collection)user.getEmails()))});
        }
        if (null == attributesToGet || attributesToGet.contains("externalIds")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"externalIds", (Collection)((Collection)user.getExternalIds()))});
        }
        if (null == attributesToGet || attributesToGet.contains("relations")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"relations", (Collection)((Collection)user.getRelations()))});
        }
        if (null == attributesToGet || attributesToGet.contains("addresses")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"addresses", (Collection)((Collection)user.getAddresses()))});
        }
        if (null == attributesToGet || attributesToGet.contains("organizations")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"organizations", (Collection)((Collection)user.getOrganizations()))});
        }
        if (null == attributesToGet || attributesToGet.contains("phones")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"phones", (Collection)((Collection)user.getPhones()))});
        }
        if (null == attributesToGet || attributesToGet.contains("aliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"aliases", (Collection)user.getAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("nonEditableAliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"nonEditableAliases", (Collection)user.getNonEditableAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("customerId")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"customerId", (Object[])new Object[]{user.getCustomerId()})});
        }
        if (null == attributesToGet || attributesToGet.contains("orgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"orgUnitPath", (Object[])new Object[]{user.getOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("isMailboxSetup")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isMailboxSetup", (Object[])new Object[]{user.getIsMailboxSetup()})});
        }
        if (null == attributesToGet || attributesToGet.contains("includeInGlobalAddressList")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"includeInGlobalAddressList", (Object[])new Object[]{user.getIncludeInGlobalAddressList()})});
        }
        if (null == attributesToGet || attributesToGet.contains("thumbnailPhotoUrl")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"thumbnailPhotoUrl", (Object[])new Object[]{user.getThumbnailPhotoUrl()})});
        }
        if (null == attributesToGet || attributesToGet.contains("deletionTime")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"deletionTime", (Object[])new Object[]{null != user.getDeletionTime() ? user.getDeletionTime().toString() : null})});
        }
        if (null == attributesToGet || "full".equals(this.configuration.getProjection()) && StringUtil.isNotBlank((String)this.configuration.getCustomSchemasJSON())) {
            List<GoogleAppsCustomSchema> customSchemas = GoogleAppsUtil.extractCustomSchemas(this.configuration.getCustomSchemasJSON());
            for (GoogleAppsCustomSchema customSchema : customSchemas) {
                if (customSchema.getType().equals("object")) {
                    String basicName = customSchema.getName();
                    for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                        String innerSchemaName = basicName + "." + innerSchema.getName();
                        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)innerSchemaName, (Object[])new Object[]{null != user.getCustomSchemas() ? this.getValueFromKey(innerSchemaName, user.getCustomSchemas()) : null})});
                    }
                    continue;
                }
                LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
            }
        }
        if (null != attributesToGet && attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, this.listGroups(service, user.getId()))});
        }
        return builder.build();
    }

    protected ConnectorObject fromGroup(Group group, Set<String> attributesToGet, Directory.Members service) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        if (null != group.getEtag()) {
            builder.setUid(new Uid(group.getEmail(), group.getEtag()));
        } else {
            builder.setUid(group.getEmail());
        }
        builder.setName(group.getEmail());
        if (null == attributesToGet || attributesToGet.contains("name")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"name", (Object[])new Object[]{group.getName()})});
        }
        if (null == attributesToGet || attributesToGet.contains("email")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"email", (Object[])new Object[]{group.getEmail()})});
        }
        if (null == attributesToGet || attributesToGet.contains("description")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"description", (Object[])new Object[]{group.getDescription()})});
        }
        if (null == attributesToGet || attributesToGet.contains("adminCreated")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"adminCreated", (Object[])new Object[]{group.getAdminCreated()})});
        }
        if (null == attributesToGet || attributesToGet.contains("aliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"aliases", (Collection)group.getAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("nonEditableAliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"nonEditableAliases", (Collection)group.getNonEditableAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("directMembersCount")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"directMembersCount", (Object[])new Object[]{group.getDirectMembersCount()})});
        }
        if (null != attributesToGet && attributesToGet.contains("__MEMBERS__")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"__MEMBERS__", this.listMembers(service, group.getId(), null))});
        }
        return builder.build();
    }

    protected List<Map<String, String>> listMembers(Directory.Members service, String groupKey, String roles) {
        final ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            String nextPageToken;
            Directory.Members.List request = service.list(groupKey);
            request.setRoles(StringUtil.isBlank((String)roles) ? "OWNER,MANAGER,MEMBER" : roles);
            while (StringUtil.isNotBlank((String)(nextPageToken = this.execute(request, new RequestResultHandler<Directory.Members.List, Members, String>(){

                @Override
                public String handleResult(Directory.Members.List request, Members value) {
                    if (null != value.getMembers()) {
                        for (Member member : value.getMembers()) {
                            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(2);
                            m.put("email", member.getEmail());
                            m.put("role", member.getRole());
                            result.add(m);
                        }
                    }
                    return value.getNextPageToken();
                }
            })))) {
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        return result;
    }

    protected Set<String> listGroups(Directory.Groups service, String userKey) {
        final SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        try {
            String nextPageToken;
            Directory.Groups.List request = service.list();
            request.setUserKey(userKey);
            request.setFields("groups/email");
            request.setDomain(this.configuration.getDomain());
            while (StringUtil.isNotBlank((String)(nextPageToken = this.execute(request, new RequestResultHandler<Directory.Groups.List, Groups, String>(){

                @Override
                public String handleResult(Directory.Groups.List request, Groups value) {
                    if (null != value.getGroups()) {
                        for (Group group : value.getGroups()) {
                            result.add(group.getEmail());
                        }
                    }
                    return value.getNextPageToken();
                }
            })))) {
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        return result;
    }

    protected <G extends AbstractGoogleJsonClientRequest<T>, T, R> R execute(G request, RequestResultHandler<G, T, R> handler) {
        return this.execute((AbstractGoogleJsonClientRequest)Assertions.nullChecked(request, (String)"Google Json ClientRequest"), (RequestResultHandler)Assertions.nullChecked(handler, (String)"handler"), -1);
    }

    protected <G extends AbstractGoogleJsonClientRequest<T>, T, R> R execute(G request, RequestResultHandler<G, T, R> handler, int retry) {
        try {
            if (retry >= 0) {
                long sleep = (long)(1000.0 * Math.pow(2.0, retry) + (double)GoogleAppsConnector.nextLong(1000L));
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    throw ConnectorException.wrap((Throwable)e);
                }
            }
            return handler.handleResult(request, request.execute());
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError details = e.getDetails();
            if (null != details && null != details.getErrors()) {
                GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)details.getErrors().get(0);
                LOG.error("Unable to execute request {0} - {1} - {2}", new Object[]{e.getStatusCode(), e.getStatusMessage(), errorInfo.getReason()});
                switch (e.getStatusCode()) {
                    case 403: {
                        if (!"userRateLimitExceeded".equalsIgnoreCase(errorInfo.getReason()) && !"rateLimitExceeded".equalsIgnoreCase(errorInfo.getReason())) break;
                        return handler.handleError(e);
                    }
                    case 404: {
                        if (!"notFound".equalsIgnoreCase(errorInfo.getReason())) break;
                        return handler.handleNotFound((IOException)((Object)e));
                    }
                    case 409: {
                        if (!"duplicate".equalsIgnoreCase(errorInfo.getReason())) break;
                        handler.handleDuplicate((IOException)((Object)e));
                        break;
                    }
                    case 400: {
                        if (!"invalid".equalsIgnoreCase(errorInfo.getReason())) break;
                        break;
                    }
                    case 503: {
                        if (!"backendError".equalsIgnoreCase(errorInfo.getReason())) break;
                        throw RetryableException.wrap((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (e.getStatusCode() == 403) {
                LOG.error("Forbidden request", new Object[0]);
                handler.handleError(e);
            } else if (e.getStatusCode() == 404) {
                LOG.error("Endpoint not found for request", new Object[0]);
                return handler.handleNotFound((IOException)((Object)e));
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (IOException e) {
            if (retry < 5) {
                return this.execute(request, handler, retry + 1);
            }
            return handler.handleError(e);
        }
    }

    protected RuntimeException get(GoogleJsonError.ErrorInfo errorInfo) {
        return null;
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = RANDOM.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    private Object getValueFromKey(String customSchema, Map<String, Map<String, Object>> customSchemas) {
        String[] names = customSchema.split("\\.");
        return names.length > 1 ? (customSchemas.get(names[0]) != null ? customSchemas.get(names[0]).get(names[1]) : null) : null;
    }

    private List<String> customSchemaNames(String customSchemasJSON) {
        List<GoogleAppsCustomSchema> customSchemas = GoogleAppsUtil.extractCustomSchemas(customSchemasJSON);
        ArrayList<String> customSchemaNames = new ArrayList<String>();
        for (GoogleAppsCustomSchema customSchema : customSchemas) {
            if (customSchema.getType().equals("object")) {
                String basicName = customSchema.getName();
                for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                    customSchemaNames.add(basicName + "." + innerSchema.getName());
                }
                continue;
            }
            LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
        }
        return customSchemaNames;
    }
}

