/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WARestClient {
    protected static final Logger LOG = LoggerFactory.getLogger(WARestClient.class);
    protected final String anonymousUser;
    protected final String anonymousKey;
    protected final boolean useGZIPCompression;
    protected final String serviceDiscoveryAddress;
    protected final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    private SyncopeClient client;

    public WARestClient(String anonymousUser, String anonymousKey, boolean useGZIPCompression, String serviceDiscoveryAddress) {
        this.anonymousUser = anonymousUser;
        this.anonymousKey = anonymousKey;
        this.useGZIPCompression = useGZIPCompression;
        this.serviceDiscoveryAddress = serviceDiscoveryAddress;
    }

    protected Optional<NetworkService> getCore() {
        try {
            ApplicationContext ctx = ApplicationContextProvider.getApplicationContext();
            if (ctx == null) {
                return Optional.empty();
            }
            Collection serviceOpsList = ctx.getBeansOfType(ServiceOps.class).values();
            if (serviceOpsList.isEmpty()) {
                return Optional.empty();
            }
            ServiceOps serviceOps = (ServiceOps)serviceOpsList.iterator().next();
            if (serviceOps.list(NetworkService.Type.WA).stream().anyMatch(s -> s.getAddress().equals(this.serviceDiscoveryAddress))) {
                return Optional.of(serviceOps.get(NetworkService.Type.CORE));
            }
            return Optional.empty();
        }
        catch (KeymasterException e) {
            LOG.trace(e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SyncopeClient getSyncopeClient() {
        WARestClient wARestClient = this;
        synchronized (wARestClient) {
            if (this.client == null) {
                this.getCore().ifPresent(core -> {
                    try {
                        this.client = new SyncopeClientFactoryBean().setAddress(core.getAddress()).setUseCompression(this.useGZIPCompression).create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey));
                    }
                    catch (Exception e) {
                        LOG.error("Could not init SyncopeClient", (Throwable)e);
                    }
                });
            }
            return this.client;
        }
    }

    public <T> T getService(Class<T> serviceClass) {
        Object service;
        if (!this.isReady()) {
            throw new IllegalStateException("Syncope core is not yet ready");
        }
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.getSyncopeClient().getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        return (T)service;
    }

    public boolean isReady() {
        try {
            return this.getCore().isPresent();
        }
        catch (Exception e) {
            LOG.trace("While checking Core's availability: {}", (Object)e.getMessage());
            return false;
        }
    }
}

