/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap;

import org.apache.syncope.wa.bootstrap.AttrRepoPropertySourceMapper;
import org.apache.syncope.wa.bootstrap.AuthModulePropertySourceMapper;
import org.apache.syncope.wa.bootstrap.WAPropertySourceLocator;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.configuration.support.CasConfigurationJasyptCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@PropertySources(value={@PropertySource(value={"classpath:wa.properties"}), @PropertySource(value={"file:${syncope.conf.dir}/wa.properties"}, ignoreResourceNotFound=true)})
public class WABootstrapConfiguration {

    @Configuration(proxyBeanMethods=false)
    public static class PropertySourceConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"waConfigurationCipher"})
        public CipherExecutor<String, String> waConfigurationCipher(Environment environment) {
            return new CasConfigurationJasyptCipherExecutor(environment);
        }

        @ConditionalOnMissingBean
        @Bean
        public AuthModulePropertySourceMapper authModulePropertySourceMapper(WARestClient waRestClient) {
            return new AuthModulePropertySourceMapper(waRestClient);
        }

        @ConditionalOnMissingBean
        @Bean
        public AttrRepoPropertySourceMapper attrRepoPropertySourceMapper(WARestClient waRestClient) {
            return new AttrRepoPropertySourceMapper(waRestClient);
        }

        @Bean
        public PropertySourceLocator configPropertySourceLocator(@Qualifier(value="waConfigurationCipher") CipherExecutor<String, String> waConfigurationCipher, WARestClient waRestClient, AuthModulePropertySourceMapper authModulePropertySourceMapper, AttrRepoPropertySourceMapper attrRepoPropertySourceMapper) {
            return new WAPropertySourceLocator(waRestClient, authModulePropertySourceMapper, attrRepoPropertySourceMapper, waConfigurationCipher);
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class WAClientConfiguration {
        @Value(value="${wa.anonymousUser}")
        private String anonymousUser;
        @Value(value="${wa.anonymousKey}")
        private String anonymousKey;
        @Value(value="${wa.useGZIPCompression:true}")
        private boolean useGZIPCompression;
        @Value(value="${service.discovery.address}")
        private String serviceDiscoveryAddress;

        @Bean
        public WARestClient waRestClient() {
            return new WARestClient(this.anonymousUser, this.anonymousKey, this.useGZIPCompression, this.serviceDiscoveryAddress);
        }
    }
}

