/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.exceptions.YubicoSignatureException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Signature {
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String calculate(String data, byte[] key) throws YubicoSignatureException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
            Mac mac = Mac.getInstance(HMAC_SHA1);
            mac.init(signingKey);
            byte[] raw = mac.doFinal(data.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])raw));
        }
        catch (NoSuchAlgorithmException e) {
            throw new YubicoSignatureException("No such algorithm (HMAC_SHA1?)", e);
        }
        catch (InvalidKeyException e) {
            throw new YubicoSignatureException("Invalid key in signature.", e);
        }
        catch (IllegalStateException e) {
            throw new YubicoSignatureException("Illegal state in signature", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new YubicoSignatureException("Unsupported encoding (utf8?)", e);
        }
    }
}

