/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.AnySelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.search.AnyObjectCompleteCondition;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Relationships
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 855618618337931784L;
    @SpringBean
    protected RelationshipTypeRestClient relationshipTypeRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;
    protected final AnyTO anyTO;
    protected final Specification specification;
    protected final PageReference pageRef;

    public Relationships(AnyWrapper<?> modelObject, PageReference pageRef) {
        this.add(new Component[]{new Label("title", (IModel)new ResourceModel("any.relationships"))});
        if (modelObject instanceof UserWrapper && ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() != null && !ListUtils.isEqualList((Collection)((UserTO)((UserWrapper)UserWrapper.class.cast(modelObject)).getInnerObject()).getRelationships(), (Collection)((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO().getRelationships())) {
            this.add(new Component[]{new LabelInfo("changed", "")});
        } else {
            this.add(new Component[]{new Label("changed", (Serializable)((Object)""))});
        }
        this.anyTO = modelObject.getInnerObject();
        this.specification = new Specification();
        this.pageRef = pageRef;
        this.add(new Component[]{this.getViewFragment().setRenderBodyOnly(true)});
    }

    public Component getHeader(String id, Component parent, IWizard wizard) {
        return super.getHeader(id, parent, wizard).setVisible(false);
    }

    protected Fragment getViewFragment() {
        final HashMap<String, List<RelationshipTO>> relationships = new HashMap<String, List<RelationshipTO>>();
        this.addRelationship(relationships, (RelationshipTO[])this.getCurrentRelationships().toArray(RelationshipTO[]::new));
        Fragment viewFragment = new Fragment("relationships", "viewFragment", (MarkupContainer)this);
        viewFragment.setOutputMarkupId(true);
        viewFragment.add(new Component[]{new Accordion("relationships", relationships.keySet().stream().map(relationship -> new AbstractTab((IModel)new ResourceModel("relationship", relationship), (String)relationship){
            private static final long serialVersionUID = 1037272333056449378L;
            final /* synthetic */ String val$relationship;
            {
                this.val$relationship = string;
                super(title);
            }

            public Panel getPanel(String panelId) {
                return new ListViewPanel.Builder<RelationshipTO>(RelationshipTO.class, Relationships.this.pageRef).setItems((List)relationships.get(this.val$relationship)).includes("otherEndType", "otherEndKey", "otherEndName").addAction(new ActionLink<RelationshipTO>(){
                    private static final long serialVersionUID = -6847033126124401556L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RelationshipTO modelObject) {
                        Relationships.this.removeRelationships(relationships, modelObject);
                        Relationships.this.send((IEventSink)Relationships.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
                    }
                }, ActionLink.ActionType.DELETE, AnyEntitlement.UPDATE.getFor(Relationships.this.anyTO.getType()), true).build(panelId);
            }
        }).collect(Collectors.toList())){
            private static final long serialVersionUID = 1037272333056449379L;

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                if (relationships.isEmpty()) {
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\")", this.getString("relationships.empty.list"))));
                }
            }
        }});
        ActionsPanel<RelationshipTO> panel = new ActionsPanel<RelationshipTO>("actions", null);
        viewFragment.add(new Component[]{panel});
        panel.add(new ActionLink<RelationshipTO>(){
            private static final long serialVersionUID = 3257738274365467945L;

            @Override
            public void onClick(AjaxRequestTarget target, RelationshipTO ignore) {
                Fragment addFragment = new Fragment("relationships", "addFragment", (MarkupContainer)Relationships.this);
                Relationships.this.addOrReplace(new Component[]{addFragment});
                addFragment.add(new Component[]{Relationships.this.specification.setRenderBodyOnly(true)});
                target.add(new Component[]{Relationships.this});
            }
        }, ActionLink.ActionType.CREATE, AnyEntitlement.UPDATE.getFor(this.anyTO.getType())).hideLabel();
        return viewFragment;
    }

    protected List<RelationshipTO> getCurrentRelationships() {
        return this.anyTO instanceof GroupableRelatableTO ? ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getRelationships() : List.of();
    }

    protected void addRelationship(Map<String, List<RelationshipTO>> relationships, RelationshipTO ... rels) {
        for (RelationshipTO relationship : rels) {
            List<Object> listrels;
            if (relationships.containsKey(relationship.getType())) {
                listrels = relationships.get(relationship.getType());
            } else {
                listrels = new ArrayList();
                relationships.put(relationship.getType(), listrels);
            }
            listrels.add(relationship);
        }
    }

    protected void addNewRelationships(RelationshipTO ... rels) {
        this.getCurrentRelationships().addAll(List.of(rels));
    }

    protected void removeRelationships(Map<String, List<RelationshipTO>> relationships, RelationshipTO ... rels) {
        List<RelationshipTO> currentRels = this.getCurrentRelationships();
        for (RelationshipTO relationship : rels) {
            currentRels.remove(relationship);
            if (!relationships.containsKey(relationship.getType())) continue;
            List<RelationshipTO> rellist = relationships.get(relationship.getType());
            rellist.remove(relationship);
            if (!rellist.isEmpty()) continue;
            relationships.remove(relationship.getType());
        }
    }

    public boolean evaluate() {
        return !this.relationshipTypeRestClient.list().isEmpty();
    }

    public class Specification
    extends Panel {
        private static final long serialVersionUID = 6199050589175839467L;
        protected final RelationshipTO rel;
        protected final AjaxDropDownChoicePanel<String> type;
        protected final AjaxDropDownChoicePanel<AnyTypeTO> otherType;
        protected final WebMarkupContainer container;
        protected final Fragment emptyFragment;
        protected final Fragment fragment;
        protected AnyObjectSearchPanel anyObjectSearchPanel;
        protected WizardMgtPanel<AnyWrapper<AnyObjectTO>> anyObjectDirectoryPanel;

        public Specification() {
            super("specification");
            this.rel = new RelationshipTO();
            List availableRels = Relationships.this.relationshipTypeRestClient.list().stream().map(RelationshipTypeTO::getKey).collect(Collectors.toList());
            this.type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)this.rel, "type"));
            this.type.setChoices(availableRels);
            this.add(new Component[]{this.type.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).setRenderBodyOnly(true)});
            final List availableTypes = Relationships.this.anyTypeRestClient.listAnyTypes().stream().filter(anyType -> anyType.getKind() != AnyTypeKind.GROUP && anyType.getKind() != AnyTypeKind.USER).collect(Collectors.toList());
            this.otherType = new AjaxDropDownChoicePanel("otherType", "otherType", (IModel)new PropertyModel<AnyTypeTO>((Object)this.rel, "otherType"){
                private static final long serialVersionUID = -5861057041758169508L;

                public AnyTypeTO getObject() {
                    for (AnyTypeTO obj : availableTypes) {
                        if (!obj.getKey().equals(Specification.this.rel.getOtherEndType())) continue;
                        return obj;
                    }
                    return null;
                }

                public void setObject(AnyTypeTO object) {
                    Specification.this.rel.setOtherEndType((String)Optional.ofNullable(object).map(AnyTypeTO::getKey).orElse(null));
                }
            }, false);
            this.otherType.setChoices(availableTypes);
            this.otherType.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<AnyTypeTO>(){
                private static final long serialVersionUID = -734743540442190178L;

                public Object getDisplayValue(AnyTypeTO object) {
                    return object.getKey();
                }

                public String getIdValue(AnyTypeTO object, int index) {
                    return object.getKey();
                }

                public AnyTypeTO getObject(String id, IModel<? extends List<? extends AnyTypeTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(anyTypeTO -> id.equals(anyTypeTO.getKey())).findAny().orElse(null);
                }
            });
            this.otherType.setEnabled(false);
            this.add(new Component[]{this.otherType.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
            this.container = new WebMarkupContainer("searchPanelContainer");
            this.add(new Component[]{this.container.setOutputMarkupId(true)});
            this.emptyFragment = new Fragment("searchPanel", "emptyFragment", (MarkupContainer)this);
            this.container.add(new Component[]{this.emptyFragment.setRenderBodyOnly(true)});
            this.fragment = new Fragment("searchPanel", "searchFragment", (MarkupContainer)this);
            this.type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    Specification.this.container.addOrReplace(new Component[]{Specification.this.emptyFragment.setRenderBodyOnly(true)});
                    Specification.this.otherType.setModelObject(null);
                    Specification.this.otherType.setEnabled(Specification.this.type.getModelObject() != null && !((String)((Object)Specification.this.type.getModelObject())).isEmpty());
                    target.add(new Component[]{Specification.this.otherType});
                    target.add(new Component[]{Specification.this.container});
                }
            }});
            this.otherType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    AnyTypeTO anyType = (AnyTypeTO)Specification.this.otherType.getModelObject();
                    if (anyType == null) {
                        Specification.this.container.addOrReplace(new Component[]{Specification.this.emptyFragment.setRenderBodyOnly(true)});
                    } else {
                        Specification.this.setupFragment(anyType);
                        Specification.this.container.addOrReplace(new Component[]{Specification.this.fragment.setRenderBodyOnly(true)});
                    }
                    target.add(new Component[]{Specification.this.container});
                }
            }});
        }

        protected void setupFragment(AnyTypeTO anyType) {
            this.anyObjectSearchPanel = (AnyObjectSearchPanel)((Object)new AnyObjectSearchPanel.Builder(anyType.getKey(), (IModel<List<SearchClause>>)new ListModel(new ArrayList()), Relationships.this.pageRef).enableSearch((IEventSink)this).build("searchPanel"));
            this.fragment.addOrReplace(new Component[]{this.anyObjectSearchPanel.setRenderBodyOnly(true)});
            this.anyObjectDirectoryPanel = new AnyObjectSelectionDirectoryPanel.Builder(Relationships.this.anyTypeClassRestClient.list(anyType.getClasses()), Relationships.this.anyObjectRestClient, anyType.getKey(), Relationships.this.pageRef).setFiql(((AnyObjectCompleteCondition)SyncopeClient.getAnyObjectSearchConditionBuilder((String)anyType.getKey()).is("key").notNullValue()).query()).setWizardInModal(true).build("searchResultPanel");
            this.fragment.addOrReplace(new Component[]{this.anyObjectDirectoryPanel.setRenderBodyOnly(true)});
        }

        public void onEvent(IEvent<?> event) {
            if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
                AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
                String fiql = SearchUtils.buildFIQL((List)this.anyObjectSearchPanel.getModel().getObject(), SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyObjectSearchPanel.getBackObjectType()));
                ((AnyDirectoryPanel)((Object)AnyDirectoryPanel.class.cast(this.anyObjectDirectoryPanel))).search(fiql, target);
            } else if (event.getPayload() instanceof AnySelectionDirectoryPanel.ItemSelection) {
                AjaxRequestTarget target = ((AnySelectionDirectoryPanel.ItemSelection)AnySelectionDirectoryPanel.ItemSelection.class.cast(event.getPayload())).getTarget();
                Object right = ((AnySelectionDirectoryPanel.ItemSelection)AnySelectionDirectoryPanel.ItemSelection.class.cast(event.getPayload())).getSelection();
                this.rel.setOtherEndKey(right.getKey());
                Relationships.this.addNewRelationships(this.rel);
                Relationships.this.addOrReplace(new Component[]{Relationships.this.getViewFragment().setRenderBodyOnly(true)});
                target.add(new Component[]{Relationships.this});
            } else {
                super.onEvent(event);
            }
        }
    }
}

