/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.ajax.form;

import java.time.Duration;
import org.apache.syncope.client.ui.commons.HttpResourceStream;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxDownloadBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 6833760760338614245L;
    protected static final Logger LOG = LoggerFactory.getLogger(AjaxDownloadBehavior.class);
    protected ResponseHolder responseHolder;

    public void setResponse(ResponseHolder response) {
        this.responseHolder = response;
    }

    public void initiate(AjaxRequestTarget target) {
        CharSequence url = this.getCallbackUrl();
        target.appendJavaScript((CharSequence)("window.location.href='" + url + "'"));
    }

    protected HttpResourceStream getResourceStream() {
        HttpResourceStream stream = null;
        if (this.responseHolder != null) {
            stream = new HttpResourceStream(this.responseHolder);
            this.responseHolder = null;
        }
        return stream;
    }

    public void onRequest() {
        try {
            HttpResourceStream resourceStream = this.getResourceStream();
            if (resourceStream != null) {
                this.getComponent().getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, resourceStream.getFilename()).setCacheDuration(Duration.ZERO));
            }
        }
        catch (Exception e) {
            LOG.error("Error downloading file", (Throwable)e);
        }
    }
}

