/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.SchedTaskWizardBuilder;
import org.apache.syncope.client.console.tasks.TaskDirectoryPanel;
import org.apache.syncope.client.console.tasks.TaskStartAtTogglePanel;
import org.apache.syncope.client.console.tasks.TemplatesTogglePanel;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class SchedTaskDirectoryPanel<T extends SchedTaskTO>
extends TaskDirectoryPanel<T>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    @SpringBean
    protected RealmRestClient realmRestClient;
    @SpringBean
    protected TaskRestClient taskRestClient;
    protected final TaskType taskType;
    protected final T schedTaskTO;
    protected final TaskStartAtTogglePanel startAt;
    protected final TemplatesTogglePanel templates;

    protected SchedTaskDirectoryPanel(String id, final TaskRestClient restClient, BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, final TaskType taskType, T newTaskTO, PageReference pageRef, boolean wizardInModal) {
        super(id, restClient, baseModal, multiLevelPanelRef, pageRef, wizardInModal);
        this.taskType = taskType;
        this.schedTaskTO = newTaskTO;
        this.modal.size(Modal.Size.Large);
        this.addNewItemPanelBuilder(new SchedTaskWizardBuilder<T>(taskType, this.schedTaskTO, this.realmRestClient, this.taskRestClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"TASK_CREATE");
        this.setFooterVisibility(false);
        this.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.of(10L, ChronoUnit.SECONDS)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                SchedTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
            }
        }});
        this.startAt = new TaskStartAtTogglePanel(this.container, pageRef);
        this.addInnerObject(new Component[]{this.startAt});
        this.templates = new TemplatesTogglePanel(this.getActualId(), (MarkupContainer)this, pageRef){
            private static final long serialVersionUID = -8765794727538618705L;

            @Override
            protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
                targetObject.getTemplates().put(type, anyTO);
                restClient.update(taskType, (SchedTaskTO)SchedTaskTO.class.cast(targetObject));
                return targetObject;
            }
        };
        this.addInnerObject(new Component[]{this.templates});
    }

    protected List<IColumn<T, String>> getHeadingFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        return columns;
    }

    protected List<IColumn<T, String>> getTrailingFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this), null, "lastExec"));
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this), null, "nextExec"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<T, String>)new BooleanPropertyColumn((IModel<String>)new StringResourceModel("active", (Component)this), "active", "active"));
        columns.add((IColumn<T, String>)new AbstractColumn<T, String>((IModel)new Model((Serializable)((Object)"")), "running"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
                Object panel;
                try {
                    JobTO jobTO = ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).getJob(((SchedTaskTO)rowModel.getObject()).getKey());
                    panel = new JobActionPanel(componentId, jobTO, false, (Component)SchedTaskDirectoryPanel.this);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.ENABLE, (String)String.format("%s,%s", "TASK_EXECUTE", "TASK_UPDATE"));
                }
                catch (Exception e) {
                    LOG.error("Could not get job for task {}", (Object)((SchedTaskTO)rowModel.getObject()).getKey(), (Object)e);
                    panel = new Label(componentId, (IModel)Model.of());
                }
                cellItem.add(new Component[]{panel});
            }

            public String getCssClass() {
                return "running-col";
            }
        });
        return columns;
    }

    protected List<IColumn<T, String>> getFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.addAll(this.getHeadingFieldColumns());
        columns.add((IColumn<T, String>)new PropertyColumn<T, String>((IModel)new StringResourceModel("jobDelegate", (Component)this), "jobDelegate", "jobDelegate"){
            private static final long serialVersionUID = -3223917055078733093L;

            public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
                IModel model = this.getDataModel(rowModel);
                if (model != null && model.getObject() instanceof String) {
                    String value = (String)String.class.cast(model.getObject());
                    if (value.length() > 20) {
                        item.add(new Component[]{new Label(componentId, (IModel)new Model((Serializable)((Object)("..." + value.substring(value.length() - 17)))))});
                    } else {
                        item.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
                    }
                } else {
                    super.populateItem(item, componentId, rowModel);
                }
            }
        });
        columns.addAll(this.getTrailingFieldColumns());
        return columns;
    }

    @Override
    protected final List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.addAll(this.getFieldColumns());
        return columns;
    }

    @Override
    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel<T> panel = super.getActions(model);
        final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskDirectoryPanel.this.viewTaskExecs(taskTO, target);
            }
        }, ActionLink.ActionType.VIEW_EXECUTIONS, "TASK_READ");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.send((IEventSink)SchedTaskDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).readTask(SchedTaskDirectoryPanel.this.taskType, ((SchedTaskTO)model.getObject()).getKey()), target).setTitleModel((IModel)new StringResourceModel("inner.task.edit", (Component)SchedTaskDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)((Object)ActionLink.ActionType.EDIT), (Object)((SchedTaskTO)model.getObject()))))));
            }
        }, ActionLink.ActionType.EDIT, "TASK_UPDATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskTO clone = (SchedTaskTO)SerializationUtils.clone((Serializable)((SchedTaskTO)model.getObject()));
                clone.setKey(null);
                SchedTaskDirectoryPanel.this.send((IEventSink)SchedTaskDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target).setTitleModel((IModel)new StringResourceModel("inner.task.clone", (Component)SchedTaskDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)((Object)ActionLink.ActionType.CLONE), (Object)((SchedTaskTO)model.getObject()))))));
            }
        }, ActionLink.ActionType.CLONE, "TASK_CREATE");
        this.addFurtherActions(panel, model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskDirectoryPanel.this.startAt.setExecutionDetail(((SchedTaskTO)model.getObject()).getKey(), ((SchedTaskTO)model.getObject()).getName(), target);
                SchedTaskDirectoryPanel.this.startAt.toggle(target, true);
            }
        }, ActionLink.ActionType.EXECUTE, "TASK_EXECUTE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                try {
                    ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).delete(SchedTaskDirectoryPanel.this.taskType, taskTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SchedTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
                    SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting propagation task {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)SchedTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        return panel;
    }

    protected void addFurtherActions(ActionsPanel<T> panel, IModel<T> model) {
    }

    @Override
    protected String paginatorRowsKey() {
        return "schedtasks.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        batches.add(ActionLink.ActionType.EXECUTE);
        batches.add(ActionLink.ActionType.DRYRUN);
        return batches;
    }

    @Override
    protected SchedTasksProvider<T> dataProvider() {
        return new SchedTasksProvider(this.taskType, this.rows);
    }

    protected class SchedTasksProvider<T extends SchedTaskTO>
    extends TaskDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;

        public SchedTasksProvider(TaskType taskType, int paginatorRows) {
            super(paginatorRows, taskType);
            this.setSort("name", SortOrder.ASCENDING);
        }

        public long size() {
            return ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).count(this.taskType);
        }

        public Iterator<T> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).list(this.taskType, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }
    }
}

