/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.rest.LoggerConf;
import org.apache.syncope.client.console.rest.LoggerConfOp;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;

public class LoggerConfRestClient
implements RestClient,
LoggerConfOp {
    private static final long serialVersionUID = 16051907544728L;
    protected static final Logger LOG = LoggerFactory.getLogger(LoggerConfRestClient.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private final List<NetworkService> instances;
    private final List<String> domains;

    public LoggerConfRestClient(List<NetworkService> instances, List<Domain> domains) {
        this.instances = instances;
        this.domains = Stream.concat(Stream.of("Master"), domains.stream().map(Domain::getKey)).collect(Collectors.toList());
    }

    protected String getActuatorEndpoint(NetworkService instance) {
        String address = instance.getAddress();
        if (address.contains("/rest")) {
            address = address.replace("/rest", "");
        }
        return address + "actuator/loggers";
    }

    protected WebClient webClient(NetworkService instance) {
        return WebClient.create((String)this.getActuatorEndpoint(instance), (String)SyncopeWebApplication.get().getAnonymousUser(), (String)SyncopeWebApplication.get().getAnonymousKey(), null).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public List<LoggerConf> list() {
        ArrayList<LoggerConf> loggerConfs = new ArrayList<LoggerConf>();
        try {
            Response response = this.webClient(this.instances.get(0)).get();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                JsonNode node = MAPPER.readTree((InputStream)response.getEntity());
                if (node.has("loggers")) {
                    Iterator itor = node.get("loggers").fields();
                    while (itor.hasNext()) {
                        Map.Entry entry = (Map.Entry)itor.next();
                        LoggerConf loggerConf = new LoggerConf();
                        loggerConf.setKey((String)entry.getKey());
                        if (((JsonNode)entry.getValue()).has("effectiveLevel")) {
                            loggerConf.setLevel(LogLevel.valueOf((String)((JsonNode)entry.getValue()).get("effectiveLevel").asText()));
                        } else {
                            loggerConf.setLevel(LogLevel.OFF);
                        }
                        if (loggerConf.getKey().startsWith("syncope.audit") || !this.domains.stream().noneMatch(domain -> loggerConf.getKey().startsWith((String)domain))) continue;
                        loggerConfs.add(loggerConf);
                    }
                }
            } else {
                LOG.error("Unexpected response for loggers from {}: {}", (Object)this.getActuatorEndpoint(this.instances.get(0)), (Object)response.getStatus());
            }
        }
        catch (Exception e) {
            LOG.error("Could not fetch loggers from {}", (Object)this.getActuatorEndpoint(this.instances.get(0)), (Object)e);
        }
        loggerConfs.sort(Comparator.comparing(LoggerConf::getKey));
        return loggerConfs;
    }

    @Override
    public void setLevel(String key, LogLevel level) {
        this.instances.forEach(i -> this.webClient((NetworkService)i).path((Object)key).post((Object)("{\"configuredLevel\": \"" + level.name() + "\"}")));
    }
}

