/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.console.commons.PropertyList;
import org.apache.syncope.client.console.panels.AbstractSchemaDetailsPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.Constants;
import org.apache.syncope.client.ui.commons.MIMETypesLoader;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;

public class PlainSchemaDetails
extends AbstractSchemaDetailsPanel {
    private static final long serialVersionUID = 5378100729213456451L;
    @SpringBean
    protected MIMETypesLoader mimeTypesLoader;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    protected final MultiFieldPanel<String> enumerationValues;
    protected final MultiFieldPanel<String> enumerationKeys;
    protected final AjaxDropDownChoicePanel<String> validator;
    protected final AjaxDropDownChoicePanel<AttrSchemaType> type;

    public PlainSchemaDetails(String id, final PlainSchemaTO schemaTO) {
        super(id, (SchemaTO)schemaTO);
        this.type = new AjaxDropDownChoicePanel("type", this.getString("type"), (IModel)new PropertyModel((Object)schemaTO, "type"));
        boolean isCreate = schemaTO == null || schemaTO.getKey() == null || schemaTO.getKey().isEmpty();
        this.type.setChoices(List.of(AttrSchemaType.values()));
        this.type.setEnabled(isCreate);
        this.type.addRequiredLabel();
        this.add(new Component[]{this.type});
        final AjaxTextFieldPanel conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel)new PropertyModel((Object)schemaTO, "conversionPattern"));
        this.add(new Component[]{conversionPattern});
        final WebMarkupContainer conversionParams = new WebMarkupContainer("conversionParams");
        conversionParams.setOutputMarkupPlaceholderTag(true);
        conversionParams.add(new Component[]{conversionPattern});
        this.add(new Component[]{conversionParams});
        final WebMarkupContainer typeParams = new WebMarkupContainer("typeParams");
        typeParams.setOutputMarkupPlaceholderTag(true);
        final AjaxTextFieldPanel enumerationValuesPanel = new AjaxTextFieldPanel("panel", "enumerationValues", (IModel)new Model(null));
        this.enumerationValues = new MultiFieldPanel.Builder<String>((IModel)new PropertyModel<List<String>>((Object)schemaTO, "enumerationValues"){
            private static final long serialVersionUID = -4953564762272833993L;

            public PropertyList<PlainSchemaTO> getObject() {
                return new PropertyList<PlainSchemaTO>(){

                    @Override
                    public String getValues() {
                        return schemaTO.getEnumerationValues();
                    }

                    @Override
                    public void setValues(List<String> list) {
                        schemaTO.setEnumerationValues(1.getEnumValuesAsString(list));
                    }
                };
            }

            public void setObject(List<String> object) {
                schemaTO.setEnumerationValues(PropertyList.getEnumValuesAsString(object));
            }
        }){
            private static final long serialVersionUID = -8752965211744734798L;

            @Override
            protected String newModelObject() {
                return "";
            }
        }.build("enumerationValues", "enumerationValues", (FieldPanel<String>)enumerationValuesPanel);
        this.enumerationKeys = new MultiFieldPanel.Builder<String>((IModel)new PropertyModel<List<String>>((Object)schemaTO, "enumerationKeys"){
            private static final long serialVersionUID = -4953564762272833993L;

            public PropertyList<PlainSchemaTO> getObject() {
                return new PropertyList<PlainSchemaTO>(){

                    @Override
                    public String getValues() {
                        return schemaTO.getEnumerationKeys();
                    }

                    @Override
                    public void setValues(List<String> list) {
                        schemaTO.setEnumerationKeys(PropertyList.getEnumValuesAsString(list));
                    }
                };
            }

            public void setObject(List<String> object) {
                schemaTO.setEnumerationKeys(PropertyList.getEnumValuesAsString(object));
            }
        }){
            private static final long serialVersionUID = -8752965211744734798L;

            @Override
            protected String newModelObject() {
                return "";
            }
        }.build("enumerationKeys", "enumerationKeys", (FieldPanel<String>)new AjaxTextFieldPanel("panel", "enumerationKeys", (IModel)new Model(null)));
        final WebMarkupContainer enumParams = new WebMarkupContainer("enumParams");
        enumParams.setOutputMarkupPlaceholderTag(true);
        enumParams.add(new Component[]{this.enumerationValues});
        enumParams.add(new Component[]{this.enumerationKeys});
        typeParams.add(new Component[]{enumParams});
        final AjaxTextFieldPanel secretKey = new AjaxTextFieldPanel("secretKey", this.getString("secretKey"), (IModel)new PropertyModel((Object)schemaTO, "secretKey"));
        final AjaxDropDownChoicePanel cipherAlgorithm = new AjaxDropDownChoicePanel("cipherAlgorithm", this.getString("cipherAlgorithm"), (IModel)new PropertyModel((Object)schemaTO, "cipherAlgorithm"));
        cipherAlgorithm.setChoices(List.of(CipherAlgorithm.values()));
        AjaxCheckBoxPanel transparentEncryption = new AjaxCheckBoxPanel("transparentEncryption", "transparentEncryption", (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 5636572627689425575L;

            public Boolean getObject() {
                return "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(schemaTO.getConversionPattern());
            }

            public void setObject(Boolean object) {
                schemaTO.setConversionPattern(BooleanUtils.isTrue((Boolean)object) ? "ENCRYPTED_DECODE_CONVERSION_PATTERN" : null);
            }
        }, true);
        final WebMarkupContainer encryptedParams = new WebMarkupContainer("encryptedParams");
        encryptedParams.setOutputMarkupPlaceholderTag(true);
        encryptedParams.add(new Component[]{secretKey});
        encryptedParams.add(new Component[]{cipherAlgorithm});
        encryptedParams.add(new Component[]{transparentEncryption});
        typeParams.add(new Component[]{encryptedParams});
        final AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", this.getString("mimeType"), (IModel)new PropertyModel((Object)schemaTO, "mimeType"));
        final WebMarkupContainer binaryParams = new WebMarkupContainer("binaryParams");
        binaryParams.setOutputMarkupPlaceholderTag(true);
        binaryParams.add(new Component[]{mimeType});
        typeParams.add(new Component[]{binaryParams});
        this.add(new Component[]{typeParams});
        this.showHide(schemaTO, this.type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, this.enumerationValues, this.enumerationKeys, encryptedParams, secretKey, (AjaxDropDownChoicePanel<CipherAlgorithm>)cipherAlgorithm, binaryParams, mimeType);
        this.type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PlainSchemaDetails.this.showHide(schemaTO, PlainSchemaDetails.this.type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, PlainSchemaDetails.this.enumerationValues, PlainSchemaDetails.this.enumerationKeys, encryptedParams, secretKey, (AjaxDropDownChoicePanel<CipherAlgorithm>)cipherAlgorithm, binaryParams, mimeType);
                target.add(new Component[]{conversionParams});
                target.add(new Component[]{typeParams});
                target.add(new Component[]{PlainSchemaDetails.this.validator});
            }
        }});
        LoadableDetachableModel<List<String>> validators = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return PlainSchemaDetails.this.implementationRestClient.list("VALIDATOR").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
        this.validator = new AjaxDropDownChoicePanel("validator", this.getString("validator"), (IModel)new PropertyModel((Object)schemaTO, "validator"));
        this.validator.setOutputMarkupId(true);
        ((DropDownChoice)this.validator.getField()).setNullValid(true);
        this.validator.setChoices((List)validators.getObject());
        this.add(new Component[]{this.validator});
        AutoCompleteTextField<String> mandatoryCondition = new AutoCompleteTextField<String>("mandatoryCondition", (IModel)new PropertyModel((Object)schemaTO, "mandatoryCondition")){
            private static final long serialVersionUID = -2428903969518079100L;

            protected Iterator<String> getChoices(String input) {
                List<String> choices = new ArrayList();
                if (Strings.isEmpty((String)input)) {
                    choices = List.of();
                } else if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        mandatoryCondition.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.add(new Component[]{mandatoryCondition});
        this.add(new Component[]{Constants.getJEXLPopover((Component)this, (TooltipConfig.Placement)TooltipConfig.Placement.right)});
        this.add(new Component[]{new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel)new PropertyModel((Object)schemaTO, "multivalue"))});
        this.add(new Component[]{new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel)new PropertyModel((Object)schemaTO, "readonly"))});
        this.add(new Component[]{new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel)new PropertyModel((Object)schemaTO, "uniqueConstraint")).setEnabled(isCreate)});
    }

    private void showHide(PlainSchemaTO schema, AjaxDropDownChoicePanel<AttrSchemaType> type, WebMarkupContainer conversionParams, AjaxTextFieldPanel conversionPattern, WebMarkupContainer enumParams, AjaxTextFieldPanel enumerationValuesPanel, MultiFieldPanel<String> enumerationValues, MultiFieldPanel<String> enumerationKeys, WebMarkupContainer encryptedParams, AjaxTextFieldPanel secretKey, AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm, WebMarkupContainer binaryParams, AjaxTextFieldPanel mimeType) {
        int typeOrdinal = -1;
        try {
            typeOrdinal = Integer.parseInt(type.getField().getValue());
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid value found: {}", (Object)type.getField().getValue(), (Object)e);
        }
        if (AttrSchemaType.Long.ordinal() == typeOrdinal || AttrSchemaType.Double.ordinal() == typeOrdinal || AttrSchemaType.Date.ordinal() == typeOrdinal) {
            conversionParams.setVisible(true);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Enum.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(true);
            if (!enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.addRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(schema.getEnumerationValues()));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(schema.getEnumerationKeys()));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Encrypted.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(true);
            if (!secretKey.isRequired()) {
                secretKey.addRequiredLabel();
            }
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.addRequiredLabel();
            }
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        } else if (AttrSchemaType.Binary.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(true);
            mimeType.setChoices(this.mimeTypesLoader.getMimeTypes());
            schema.setValidator("BinaryValidator");
        } else {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject(null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(PropertyList.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(PropertyList.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject(null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject(null);
            binaryParams.setVisible(false);
            mimeType.setModelObject(null);
            mimeType.setChoices(null);
        }
        if (type.isEnabled() && AttrSchemaType.Binary.ordinal() != typeOrdinal) {
            schema.setValidator(null);
        }
    }
}

