/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.DynRealmModalPanel;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.DynRealmWrapper;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class DynRealmDirectoryPanel
extends DirectoryPanel<DynRealmTO, DynRealmWrapper, DynRealmDataProvider, DynRealmRestClient> {
    private static final long serialVersionUID = -5491515010207202168L;

    protected DynRealmDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"DYNREALM_CREATE");
        this.setReadOnly(!SyncopeConsoleSession.get().owns("DYNREALM_UPDATE", new String[0]));
        this.disableCheckBoxes();
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        AjaxLink<Void> newDynRealmlLink = new AjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                DynRealmDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.new"));
                DynRealmDirectoryPanel.this.modal.setContent((ModalPanel)new DynRealmModalPanel(new DynRealmWrapper(new DynRealmTO()), true, DynRealmDirectoryPanel.this.modal, DynRealmDirectoryPanel.this.pageRef));
                DynRealmDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{DynRealmDirectoryPanel.this.modal});
            }
        };
        ((WebMarkupContainer)this.get("container:content")).addOrReplace(new Component[]{newDynRealmlLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)newDynRealmlLink, (Action)RENDER, (String)"DYNREALM_CREATE");
        this.initResultTable();
    }

    @Override
    protected DynRealmDataProvider dataProvider() {
        return new DynRealmDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "dynRealm.paginator.rows";
    }

    @Override
    protected List<IColumn<DynRealmTO, String>> getColumns() {
        ArrayList<IColumn<DynRealmTO, String>> columns = new ArrayList<IColumn<DynRealmTO, String>>();
        columns.add((IColumn<DynRealmTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        return columns;
    }

    @Override
    public ActionsPanel<DynRealmTO> getActions(final IModel<DynRealmTO> model) {
        ActionsPanel<DynRealmTO> panel = super.getActions(model);
        panel.add(new ActionLink<DynRealmTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, DynRealmTO ignore) {
                DynRealmDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.edit", model));
                DynRealmDirectoryPanel.this.modal.setContent((ModalPanel)new DynRealmModalPanel(new DynRealmWrapper((DynRealmTO)model.getObject()), false, DynRealmDirectoryPanel.this.modal, DynRealmDirectoryPanel.this.pageRef));
                DynRealmDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{DynRealmDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.EDIT, "DYNREALM_UPDATE");
        panel.add(new ActionLink<DynRealmTO>(){
            private static final long serialVersionUID = 3766262567901552032L;

            @Override
            public void onClick(AjaxRequestTarget target, DynRealmTO ignore) {
                try {
                    ((DynRealmRestClient)DynRealmDirectoryPanel.this.restClient).delete(((DynRealmTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)DynRealmDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{DynRealmDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting dynamic realm {}", (Object)((DynRealmTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)DynRealmDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "DYNREALM_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<DynRealmTO, DynRealmWrapper, DynRealmRestClient> {
        private static final long serialVersionUID = 5530948153889495221L;

        public Builder(DynRealmRestClient restClient, PageReference pageRef) {
            super(restClient, pageRef);
        }

        @Override
        protected WizardMgtPanel<DynRealmWrapper> newInstance(String id, boolean wizardInModal) {
            return new DynRealmDirectoryPanel(id, this);
        }
    }

    protected class DynRealmDataProvider
    extends DirectoryDataProvider<DynRealmTO> {
        private static final long serialVersionUID = 3124431855954382273L;
        private final SortableDataProviderComparator<DynRealmTO> comparator;

        public DynRealmDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator(this);
        }

        public Iterator<DynRealmTO> iterator(long first, long count) {
            List<DynRealmTO> result = ((DynRealmRestClient)DynRealmDirectoryPanel.this.restClient).list();
            result.sort(this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((DynRealmRestClient)DynRealmDirectoryPanel.this.restClient).list().size();
        }

        public IModel<DynRealmTO> model(DynRealmTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

