/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.java.AbstractGroupWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultGroupWorkflowAdapter
extends AbstractGroupWorkflowAdapter {
    public DefaultGroupWorkflowAdapter(GroupDataBinder dataBinder, GroupDAO groupDAO, EntityFactory entityFactory, ApplicationEventPublisher publisher) {
        super(dataBinder, groupDAO, entityFactory, publisher);
    }

    @Override
    protected WorkflowResult<String> doCreate(GroupCR groupCR, String creator, String context) {
        Group group = (Group)this.entityFactory.newEntity(Group.class);
        this.dataBinder.create(group, groupCR);
        this.metadata((Any<?>)group, creator, context);
        group = this.groupDAO.saveAndRefreshDynMemberships(group);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Any)group, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.groupDAO.findAllResourceKeys(group.getKey()));
        return new WorkflowResult((Object)group.getKey(), propByRes, "create");
    }

    @Override
    protected WorkflowResult<GroupUR> doUpdate(Group group, GroupUR groupUR, String updater, String context) {
        PropagationByResource propByRes = this.dataBinder.update(group, groupUR);
        this.metadata((Any<?>)group, updater, context);
        Group updated = (Group)this.groupDAO.save((Any)group);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        return new WorkflowResult((Object)groupUR, propByRes, "update");
    }

    @Override
    protected void doDelete(Group group, String eraser, String context) {
        this.groupDAO.delete((Any)group);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Any)group, AuthContextUtils.getDomain()));
    }
}

