/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.lang.Assert;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.error.ErrorHandler;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.client.DefaultClientBuilder;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.deserializer.UserProfileDeserializer;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverServiceImpl;
import com.okta.sdk.impl.oauth2.OAuth2ClientCredentials;
import com.okta.sdk.impl.serializer.UserProfileSerializer;
import com.okta.sdk.impl.util.ConfigUtil;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.UserProfile;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class ConnIdClientBuilder
extends DefaultClientBuilder {
    protected final CacheManager cacheManager = Caches.newDisabledCacheManager();
    protected ClientCredentials clientCredentials;

    public ConnIdClientBuilder() {
        this.setCacheManager(this.cacheManager);
    }

    public ClientBuilder setClientCredentials(ClientCredentials clientCredentials) {
        super.setClientCredentials(clientCredentials);
        this.clientCredentials = clientCredentials;
        return this;
    }

    protected BufferingClientHttpRequestFactory requestFactory() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        ClientConfiguration clientConfig = this.getClientConfiguration();
        if (clientConfig.getProxy() != null) {
            clientBuilder.useSystemProperties();
            clientBuilder.setProxy(new HttpHost(clientConfig.getProxyHost(), clientConfig.getProxyPort()));
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            AuthScope authScope = new AuthScope(clientConfig.getProxyHost(), clientConfig.getProxyPort());
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(clientConfig.getProxyUsername(), clientConfig.getProxyPassword());
            credentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setHttpClient((HttpClient)clientBuilder.build());
        clientHttpRequestFactory.setConnectionRequestTimeout(clientConfig.getConnectionTimeout() * 1000);
        clientHttpRequestFactory.setConnectTimeout(clientConfig.getConnectionTimeout() * 1000);
        clientHttpRequestFactory.setReadTimeout(clientConfig.getConnectionTimeout() * 1000);
        return new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    protected RestTemplate restTemplate() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        SimpleModule module = new SimpleModule();
        module.addSerializer(UserProfile.class, (JsonSerializer)new UserProfileSerializer());
        module.addDeserializer(UserProfile.class, (JsonDeserializer)new UserProfileDeserializer());
        objectMapper.registerModule((Module)module);
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        mappingJackson2HttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"application/x-pem-file"), MediaType.parseMediaType((String)"application/x-x509-ca-cert"), MediaType.parseMediaType((String)"application/pkix-cert")));
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(mappingJackson2HttpMessageConverter);
        DefaultUriBuilderFactory uriTemplateHandler = new DefaultUriBuilderFactory();
        uriTemplateHandler.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        RestTemplate restTemplate = new RestTemplate(messageConverters);
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory());
        restTemplate.setUriTemplateHandler((UriTemplateHandler)uriTemplateHandler);
        return restTemplate;
    }

    protected void validateOAuth2ClientConfig() {
        ClientConfiguration clientConfigu = this.getClientConfiguration();
        Assert.notNull((Object)clientConfigu.getClientId(), (String)"clientId cannot be null");
        Assert.isTrue((clientConfigu.getScopes() != null && !clientConfigu.getScopes().isEmpty() ? 1 : 0) != 0, (String)"At least one scope is required");
        String privateKey = clientConfigu.getPrivateKey();
        Assert.hasText((String)privateKey, (String)"privateKey cannot be null (either PEM file path (or) full PEM content must be supplied)");
        if (!ConfigUtil.hasPrivateKeyContentWrapper((String)privateKey)) {
            Path privateKeyPemFilePath;
            try {
                privateKeyPemFilePath = Paths.get(privateKey, new String[0]);
            }
            catch (InvalidPathException ipe) {
                throw new IllegalArgumentException("Invalid privateKey file path", ipe);
            }
            boolean privateKeyPemFileExists = Files.exists(privateKeyPemFilePath, LinkOption.NOFOLLOW_LINKS);
            Assert.isTrue((boolean)privateKeyPemFileExists, (String)"privateKey file does not exist");
        }
    }

    public ApiClient build() {
        ApiClient apiClient = new ApiClient(this.restTemplate(), this.cacheManager, (HttpClientConfiguration)this.getClientConfiguration());
        apiClient.setBasePath(this.getClientConfiguration().getBaseUrl());
        if (this.getClientConfiguration().getAuthorizationMode() != AuthorizationMode.PRIVATE_KEY) {
            if (this.getClientConfiguration().getClientCredentialsResolver() == null && this.clientCredentials != null) {
                this.getClientConfiguration().setClientCredentialsResolver((ClientCredentialsResolver)new DefaultClientCredentialsResolver(this.clientCredentials));
            } else if (this.getClientConfiguration().getClientCredentialsResolver() == null) {
                this.getClientConfiguration().setClientCredentialsResolver((ClientCredentialsResolver)new DefaultClientCredentialsResolver(this.getClientConfiguration()));
            }
            apiClient.setApiKeyPrefix("SSWS");
            apiClient.setApiKey((String)this.getClientConfiguration().getClientCredentialsResolver().getClientCredentials().getCredentials());
        } else {
            this.getClientConfiguration().setAuthenticationScheme(AuthenticationScheme.OAUTH2_PRIVATE_KEY);
            this.validateOAuth2ClientConfig();
            OAuth2ClientCredentials oAuth2ClientCredentials = new OAuth2ClientCredentials((AccessTokenRetrieverService)new AccessTokenRetrieverServiceImpl(this.getClientConfiguration(), apiClient));
            this.getClientConfiguration().setClientCredentialsResolver((ClientCredentialsResolver)new DefaultClientCredentialsResolver((ClientCredentials)oAuth2ClientCredentials));
        }
        return apiClient;
    }
}

