/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.SAML2SPClientAppTO;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AbstractClientAppMapper;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.model.TriStateBoolean;

public class SAML2SPClientAppTOMapper
extends AbstractClientAppMapper {
    @Override
    public boolean supports(ClientAppTO clientApp) {
        return SAML2SPClientAppTO.class.equals(clientApp.getClass());
    }

    @Override
    public RegisteredService map(WAClientApp clientApp, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy, RegisteredServiceTicketGrantingTicketExpirationPolicy tgtExpirationPolicy, RegisteredServiceServiceTicketExpirationPolicy stExpirationPolicy, RegisteredServiceProxyGrantingTicketExpirationPolicy tgtProxyExpirationPolicy, RegisteredServiceProxyTicketExpirationPolicy stProxyExpirationPolicy, CasConfigurationProperties properties) {
        SAML2SPClientAppTO sp = (SAML2SPClientAppTO)SAML2SPClientAppTO.class.cast(clientApp.getClientAppTO());
        SamlRegisteredService service = new SamlRegisteredService();
        this.setCommon((BaseWebBasedRegisteredService)service, (ClientAppTO)sp);
        service.setServiceId(sp.getEntityId());
        service.setMetadataLocation(sp.getMetadataLocation());
        service.setMetadataSignatureLocation(sp.getMetadataSignatureLocation());
        service.setSignAssertions(TriStateBoolean.fromBoolean((boolean)sp.isSignAssertions()));
        service.setSignResponses(TriStateBoolean.fromBoolean((boolean)sp.isSignResponses()));
        service.setEncryptionOptional(sp.isEncryptionOptional());
        service.setEncryptAssertions(sp.isEncryptAssertions());
        service.setRequiredAuthenticationContextClass(sp.getRequiredAuthenticationContextClass());
        service.setRequiredNameIdFormat(sp.getRequiredNameIdFormat().getNameId());
        service.setSkewAllowance(Optional.ofNullable(sp.getSkewAllowance()).orElse(0).intValue());
        service.setNameIdQualifier(sp.getNameIdQualifier());
        if (!sp.getAssertionAudiences().isEmpty()) {
            service.setAssertionAudiences(sp.getAssertionAudiences().stream().collect(Collectors.joining(",")));
        }
        service.setServiceProviderNameIdQualifier(sp.getServiceProviderNameIdQualifier());
        this.setPolicies((BaseWebBasedRegisteredService)service, authPolicy, mfaPolicy, accessStrategy, attributeReleasePolicy, tgtExpirationPolicy, stExpirationPolicy, tgtProxyExpirationPolicy, stProxyExpirationPolicy);
        return service;
    }
}

