/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AccessMapper;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapperResult;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apache.syncope.wa.starter.mapping.TicketExpirationMapper;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class RegisteredServiceMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredServiceMapper.class);
    protected final String pac4jCoreName;
    protected final ObjectProvider<AuthenticationEventExecutionPlan> authEventExecPlan;
    protected final List<MultifactorAuthenticationProvider> multifactorAuthenticationProviders;
    protected final List<AuthMapper> authMappers;
    protected final List<AccessMapper> accessMappers;
    protected final List<AttrReleaseMapper> attrReleaseMappers;
    protected final List<TicketExpirationMapper> ticketExpirationMappers;
    protected final List<ClientAppMapper> clientAppMappers;
    protected final CasConfigurationProperties properties;

    public RegisteredServiceMapper(String pac4jCoreName, ObjectProvider<AuthenticationEventExecutionPlan> authEventExecPlan, List<MultifactorAuthenticationProvider> multifactorAuthenticationProviders, List<AuthMapper> authMappers, List<AccessMapper> accessMappers, List<AttrReleaseMapper> attrReleaseMappers, List<TicketExpirationMapper> ticketExpirationMappers, List<ClientAppMapper> clientAppMappers, CasConfigurationProperties properties) {
        this.pac4jCoreName = pac4jCoreName;
        this.authEventExecPlan = authEventExecPlan;
        this.multifactorAuthenticationProviders = multifactorAuthenticationProviders;
        this.authMappers = authMappers;
        this.accessMappers = accessMappers;
        this.attrReleaseMappers = attrReleaseMappers;
        this.ticketExpirationMappers = ticketExpirationMappers;
        this.clientAppMappers = clientAppMappers;
        this.properties = properties;
    }

    public RegisteredService toRegisteredService(WAClientApp clientApp) {
        TicketExpirationMapper ticketExpirationMapper;
        ClientAppMapper clientAppMapper = this.clientAppMappers.stream().filter(m -> m.supports(clientApp.getClientAppTO())).findFirst().orElse(null);
        if (clientAppMapper == null) {
            LOG.warn("Unable to locate ClientAppMapper for {}", (Object)clientApp.getClientAppTO().getClass().getName());
            return null;
        }
        RegisteredServiceAuthenticationPolicy authPolicy = null;
        RegisteredServiceMultifactorPolicy mfaPolicy = null;
        RegisteredServiceDelegatedAuthenticationPolicy delegatedAuthPolicy = null;
        if (clientApp.getAuthPolicy() != null) {
            Optional<AuthMapper> authMapper = this.authMappers.stream().filter(m -> m.supports(clientApp.getAuthPolicy().getConf())).findFirst();
            AuthMapperResult result = authMapper.map(mapper -> mapper.build(this.pac4jCoreName, this.authEventExecPlan, this.multifactorAuthenticationProviders, clientApp.getAuthPolicy(), clientApp.getAuthModules())).orElse(AuthMapperResult.EMPTY);
            authPolicy = result.getAuthPolicy();
            mfaPolicy = result.getMfaPolicy();
            delegatedAuthPolicy = result.getDelegateAuthPolicy();
        }
        DefaultRegisteredServiceAccessStrategy accessStrategy = null;
        if (clientApp.getAccessPolicy() != null) {
            Optional<AccessMapper> accessMapper = this.accessMappers.stream().filter(m -> m.supports(clientApp.getAccessPolicy().getConf())).findFirst();
            accessStrategy = accessMapper.map(mapper -> mapper.build(clientApp.getAccessPolicy())).orElse(null);
        }
        if (delegatedAuthPolicy != null) {
            if (accessStrategy == null) {
                accessStrategy = new DefaultRegisteredServiceAccessStrategy();
            }
            if (accessStrategy instanceof DefaultRegisteredServiceAccessStrategy) {
                accessStrategy.setDelegatedAuthenticationPolicy(delegatedAuthPolicy);
            } else {
                LOG.warn("Could not set delegated auth policy because access strategy is instance of {}", (Object)accessStrategy.getClass().getName());
            }
        }
        AttrReleasePolicyTO attrReleasePolicyTO = Optional.ofNullable(clientApp.getAttrReleasePolicy()).orElseGet(() -> {
            AttrReleasePolicyTO arpTO = new AttrReleasePolicyTO();
            arpTO.setConf((AttrReleasePolicyConf)new DefaultAttrReleasePolicyConf());
            return arpTO;
        });
        Optional<AttrReleaseMapper> attrReleaseMapper = this.attrReleaseMappers.stream().filter(m -> m.supports(attrReleasePolicyTO.getConf())).findFirst();
        RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = attrReleaseMapper.map(mapper -> mapper.build(attrReleasePolicyTO)).orElse(null);
        RegisteredServiceTicketGrantingTicketExpirationPolicy tgtExpirationPolicy = null;
        RegisteredServiceServiceTicketExpirationPolicy stExpirationPolicy = null;
        RegisteredServiceProxyGrantingTicketExpirationPolicy tgtProxyExpirationPolicy = null;
        RegisteredServiceProxyTicketExpirationPolicy stProxyExpirationPolicy = null;
        if (clientApp.getTicketExpirationPolicy() != null && (ticketExpirationMapper = (TicketExpirationMapper)this.ticketExpirationMappers.stream().filter(m -> m.supports(clientApp.getTicketExpirationPolicy().getConf())).findFirst().orElse(null)) != null) {
            tgtExpirationPolicy = ticketExpirationMapper.buildTGT(clientApp.getTicketExpirationPolicy());
            stExpirationPolicy = ticketExpirationMapper.buildST(clientApp.getTicketExpirationPolicy());
            tgtProxyExpirationPolicy = ticketExpirationMapper.buildProxyTGT(clientApp.getTicketExpirationPolicy());
            stProxyExpirationPolicy = ticketExpirationMapper.buildProxyST(clientApp.getTicketExpirationPolicy());
        }
        return clientAppMapper.map(clientApp, authPolicy, mfaPolicy, (RegisteredServiceAccessStrategy)accessStrategy, attributeReleasePolicy, tgtExpirationPolicy, stExpirationPolicy, tgtProxyExpirationPolicy, stProxyExpirationPolicy, this.properties);
    }
}

