/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Optional;
import org.apache.syncope.common.lib.clientapps.AnonymousUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.DefaultUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.GroovyUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.PairwiseOidcUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.PrincipalAttributeUsernameAttributeProviderConf;
import org.apache.syncope.common.lib.clientapps.UsernameAttributeProviderConf;
import org.apereo.cas.authentication.principal.OidcPairwisePersistentIdGenerator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.GroovyRegisteredServiceUsernameProvider;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.util.RandomUtils;

public class DefaultUsernameAttributeProviderConfMapper
implements UsernameAttributeProviderConf.Mapper {
    protected final BaseWebBasedRegisteredService service;

    protected static Optional<PersistentIdGenerator> toPersistentIdGenerator(org.apache.syncope.common.lib.types.PersistentIdGenerator persistentIdGenerator) {
        if (persistentIdGenerator == null) {
            return Optional.empty();
        }
        OidcPairwisePersistentIdGenerator result = null;
        switch (persistentIdGenerator) {
            case SHIBBOLETH: {
                result = new ShibbolethCompatiblePersistentIdGenerator(RandomUtils.randomAlphanumeric((int)16));
                break;
            }
            case OIDC: {
                result = new OidcPairwisePersistentIdGenerator();
                break;
            }
        }
        return Optional.ofNullable(result);
    }

    public DefaultUsernameAttributeProviderConfMapper(BaseWebBasedRegisteredService service) {
        this.service = service;
    }

    public void map(AnonymousUsernameAttributeProviderConf conf) {
        AnonymousRegisteredServiceUsernameAttributeProvider arsuap = new AnonymousRegisteredServiceUsernameAttributeProvider();
        DefaultUsernameAttributeProviderConfMapper.toPersistentIdGenerator(conf.getPersistentIdGenerator()).ifPresent(arg_0 -> ((AnonymousRegisteredServiceUsernameAttributeProvider)arsuap).setPersistentIdGenerator(arg_0));
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)arsuap);
    }

    public void map(DefaultUsernameAttributeProviderConf conf) {
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
    }

    public void map(GroovyUsernameAttributeProviderConf conf) {
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new GroovyRegisteredServiceUsernameProvider(conf.getGroovyScript()));
    }

    public void map(PairwiseOidcUsernameAttributeProviderConf conf) {
        PairwiseOidcRegisteredServiceUsernameAttributeProvider porsuap = new PairwiseOidcRegisteredServiceUsernameAttributeProvider();
        DefaultUsernameAttributeProviderConfMapper.toPersistentIdGenerator(conf.getPersistentIdGenerator()).ifPresent(arg_0 -> ((PairwiseOidcRegisteredServiceUsernameAttributeProvider)porsuap).setPersistentIdGenerator(arg_0));
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)porsuap);
    }

    public void map(PrincipalAttributeUsernameAttributeProviderConf conf) {
        this.service.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider(conf.getUsernameAttribute()));
    }
}

