/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.clientapps.UsernameAttributeProviderConf;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apache.syncope.wa.starter.mapping.DefaultUsernameAttributeProviderConfMapper;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;

abstract class AbstractClientAppMapper
implements ClientAppMapper {
    AbstractClientAppMapper() {
    }

    protected void setCommon(BaseWebBasedRegisteredService service, ClientAppTO clientApp) {
        service.setId(clientApp.getClientAppId().longValue());
        service.setName(clientApp.getName());
        service.setDescription(clientApp.getDescription());
        service.setLogo(clientApp.getLogo());
        service.setTheme(clientApp.getTheme());
        service.setInformationUrl(clientApp.getInformationUrl());
        service.setPrivacyUrl(clientApp.getPrivacyUrl());
        Optional.ofNullable(clientApp.getUsernameAttributeProviderConf()).ifPresent(conf -> conf.map((UsernameAttributeProviderConf.Mapper)new DefaultUsernameAttributeProviderConfMapper(service)));
        if (!clientApp.getProperties().isEmpty()) {
            Map<String, RegisteredServiceProperty> properties = clientApp.getProperties().stream().collect(Collectors.toMap(Attr::getSchema, attr -> new DefaultRegisteredServiceProperty((Collection)attr.getValues()), (existing, replacement) -> existing));
            service.setProperties(properties);
        }
    }

    protected void setPolicies(BaseWebBasedRegisteredService service, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy, RegisteredServiceTicketGrantingTicketExpirationPolicy tgtExpirationPolicy, RegisteredServiceServiceTicketExpirationPolicy stExpirationPolicy, RegisteredServiceProxyGrantingTicketExpirationPolicy tgtProxyExpirationPolicy, RegisteredServiceProxyTicketExpirationPolicy stProxyExpirationPolicy) {
        Optional.ofNullable(authPolicy).ifPresent(arg_0 -> ((BaseWebBasedRegisteredService)service).setAuthenticationPolicy(arg_0));
        Optional.ofNullable(mfaPolicy).ifPresent(arg_0 -> ((BaseWebBasedRegisteredService)service).setMultifactorAuthenticationPolicy(arg_0));
        Optional.ofNullable(accessStrategy).ifPresent(arg_0 -> ((BaseWebBasedRegisteredService)service).setAccessStrategy(arg_0));
        Optional.ofNullable(attributeReleasePolicy).ifPresent(arg_0 -> ((BaseWebBasedRegisteredService)service).setAttributeReleasePolicy(arg_0));
        Optional.ofNullable(tgtExpirationPolicy).ifPresent(arg_0 -> ((BaseWebBasedRegisteredService)service).setTicketGrantingTicketExpirationPolicy(arg_0));
        if (service instanceof CasRegisteredService) {
            CasRegisteredService casRegisteredService = (CasRegisteredService)service;
            Optional.ofNullable(stExpirationPolicy).ifPresent(arg_0 -> ((CasRegisteredService)casRegisteredService).setServiceTicketExpirationPolicy(arg_0));
            Optional.ofNullable(tgtProxyExpirationPolicy).ifPresent(arg_0 -> ((CasRegisteredService)casRegisteredService).setProxyGrantingTicketExpirationPolicy(arg_0));
            Optional.ofNullable(stProxyExpirationPolicy).ifPresent(arg_0 -> ((CasRegisteredService)casRegisteredService).setProxyTicketExpirationPolicy(arg_0));
        }
    }
}

