/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.decorator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.model.core.web.flow.RestfulWebflowLoginDecoratorProperties;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.flow.decorator.WebflowDecorator;
import org.hjson.JsonValue;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class RestfulLoginWebflowDecorator
implements WebflowDecorator {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final RestfulWebflowLoginDecoratorProperties restProperties;

    @Override
    public void decorate(RequestContext requestContext, ApplicationContext applicationContext) {
        FunctionUtils.doUnchecked(u -> {
            HttpResponse response = null;
            try {
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(this.restProperties.getBasicAuthPassword()).basicAuthUsername(this.restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)this.restProperties.getMethod().toUpperCase().trim())).url(this.restProperties.getUrl()).build();
                response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                int statusCode = response.getStatusLine().getStatusCode();
                if (HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    Map jsonObject = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), Map.class);
                    requestContext.getFlowScope().put("decoration", (Object)jsonObject);
                }
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
        }, (Object[])new Object[0]);
    }

    @Generated
    public RestfulLoginWebflowDecorator(RestfulWebflowLoginDecoratorProperties restProperties) {
        this.restProperties = restProperties;
    }
}

