/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.api.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.ExecutableHttpRequest;

public interface AsyncExecutableHttpRequest
extends ExecutableHttpRequest {
    @Override
    default public HttpResponse call() {
        try {
            return this.callAsync().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlowableException("Call was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new FlowableException("execution exception", cause);
        }
    }

    public CompletableFuture<HttpResponse> callAsync();
}

