/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.ReconStatusPanel;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;
    protected final MultilevelPanel multiLevelPanelRef;
    protected String type;
    protected final ResourceTO resource;

    public ResourceStatusDirectoryPanel(MultilevelPanel multiLevelPanelRef, PageReference pageRef, String type, ResourceTO resource) {
        super("first", null, pageRef);
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.type = type;
        this.resource = resource;
        this.itemKeyFieldName = "resource";
        this.initResultTable();
    }

    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.multiLevelPanelRef);
    }

    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        return columns;
    }

    public ActionsPanel<StatusBean> getActions(IModel<StatusBean> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            protected boolean statusCondition(StatusBean bean) {
                return StringUtils.isNotBlank((CharSequence)ResourceStatusDirectoryPanel.this.type);
            }

            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next(bean.getResource(), (MultilevelPanel.SecondLevel)new ReconStatusPanel(bean.getResource(), ResourceStatusDirectoryPanel.this.type, bean.getKey()), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        panel.add((ActionLink)new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            protected boolean statusCondition(StatusBean bean) {
                return StringUtils.isNotBlank((CharSequence)ResourceStatusDirectoryPanel.this.type);
            }

            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next("PUSH " + bean.getResource(), (MultilevelPanel.SecondLevel)new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PushTaskTO(), ResourceStatusDirectoryPanel.this.type, bean.getKey(), true, ResourceStatusDirectoryPanel.this.multiLevelPanelRef, ResourceStatusDirectoryPanel.this.pageRef), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.RECONCILIATION_PUSH, "TASK_EXECUTE");
        panel.add((ActionLink)new ActionLink<StatusBean>(){
            private static final long serialVersionUID = -7978723352517770645L;

            protected boolean statusCondition(StatusBean bean) {
                return StringUtils.isNotBlank((CharSequence)ResourceStatusDirectoryPanel.this.type);
            }

            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                ResourceStatusDirectoryPanel.this.multiLevelPanelRef.next("PULL " + bean.getResource(), (MultilevelPanel.SecondLevel)new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PullTaskTO(), ResourceStatusDirectoryPanel.this.type, bean.getKey(), true, ResourceStatusDirectoryPanel.this.multiLevelPanelRef, ResourceStatusDirectoryPanel.this.pageRef), target);
                target.add(new Component[]{ResourceStatusDirectoryPanel.this.multiLevelPanelRef});
                ResourceStatusDirectoryPanel.this.getTogglePanel().close(target);
            }
        }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResultTable(String type, AjaxRequestTarget target) {
        this.type = type;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            switch (type) {
                case "USER": {
                    this.restClient = this.userRestClient;
                    break;
                }
                case "GROUP": {
                    this.restClient = this.groupRestClient;
                    break;
                }
                default: {
                    this.restClient = this.anyObjectRestClient;
                }
            }
        }
        Object object = this;
        synchronized (object) {
            this.dataProvider = this.dataProvider();
        }
        super.updateResultTable(target);
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.UNLINK);
        batches.add(ActionLink.ActionType.LINK);
        batches.add(ActionLink.ActionType.DEPROVISION);
        batches.add(ActionLink.ActionType.PROVISION);
        batches.add(ActionLink.ActionType.ASSIGN);
        batches.add(ActionLink.ActionType.UNASSIGN);
        return batches;
    }

    protected ResourceStatusDataProvider dataProvider() {
        return new ResourceStatusDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "reconciliation.paginator.rows";
    }

    protected class ResourceStatusDataProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;
        private final String fiql;
        private final AbstractAnyRestClient<? extends AnyTO> restClient;

        public ResourceStatusDataProvider(int paginatorRows) {
            super(paginatorRows, AnyTypeKind.USER.name().equals(ResourceStatusDirectoryPanel.this.type) ? "username" : "name");
            if (StringUtils.isEmpty((CharSequence)ResourceStatusDirectoryPanel.this.type)) {
                this.fiql = null;
                this.restClient = null;
            } else {
                UserFiqlSearchConditionBuilder bld;
                switch (ResourceStatusDirectoryPanel.this.type) {
                    case "USER": {
                        bld = SyncopeClient.getUserSearchConditionBuilder();
                        this.restClient = ResourceStatusDirectoryPanel.this.userRestClient;
                        break;
                    }
                    case "GROUP": {
                        bld = SyncopeClient.getGroupSearchConditionBuilder();
                        this.restClient = ResourceStatusDirectoryPanel.this.groupRestClient;
                        break;
                    }
                    default: {
                        bld = SyncopeClient.getAnyObjectSearchConditionBuilder((String)ResourceStatusDirectoryPanel.this.type);
                        this.restClient = ResourceStatusDirectoryPanel.this.anyObjectRestClient;
                    }
                }
                this.fiql = bld.isNotNull("key").query();
            }
        }

        @Override
        protected List<StatusBean> getStatusBeans(long first, long count) {
            ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>();
            if (this.fiql != null && this.restClient != null) {
                int page = (int)first / this.paginatorRows;
                List result = this.restClient.search("/", this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, this.getSort(), ResourceStatusDirectoryPanel.this.type);
                statusBeans.addAll(result.stream().map(any -> StatusUtils.getStatusBean((AnyTO)any, (String)ResourceStatusDirectoryPanel.this.resource.getKey(), null, (boolean)(any instanceof GroupTO))).collect(Collectors.toList()));
            }
            return statusBeans;
        }

        @Override
        public long size() {
            return Optional.ofNullable(this.fiql).map(s -> this.restClient.count("/", s, ResourceStatusDirectoryPanel.this.type)).orElse(0).intValue();
        }
    }
}

