/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushResultHandlerDispatcher;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PushJobDelegate
extends AbstractProvisioningJobDelegate<PushTask>
implements SyncopePushExecutor {
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected SearchCondVisitor searchCondVisitor;
    protected ProvisioningProfile<PushTask, PushActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new ConcurrentHashMap<String, MutablePair<Integer, String>>();
    protected final Map<String, PushActions> perContextActions = new ConcurrentHashMap<String, PushActions>();

    public void reportHandled(String anyType, String key) {
        MutablePair pair = this.handled.get(anyType);
        if (pair == null) {
            pair = MutablePair.of((Object)0, null);
            this.handled.put(anyType, (MutablePair<Integer, String>)pair);
        }
        pair.setLeft((Object)((Integer)pair.getLeft() + 1));
        pair.setRight((Object)key);
        if (!this.handled.isEmpty()) {
            StringBuilder builder = new StringBuilder("Processed:\n");
            this.handled.forEach((k, v) -> builder.append(' ').append(v.getLeft()).append('\t').append((String)k).append(" / latest: ").append((String)v.getRight()).append('\n'));
            this.setStatus(builder.toString());
        }
    }

    public boolean wasInterruptRequested() {
        return this.interrupt;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    protected boolean doHandle(List<? extends Any<?>> anys, PushResultHandlerDispatcher dispatcher, ExternalResource resource) throws JobExecutionException {
        boolean result = true;
        for (int i = 0; i < anys.size() && result; ++i) {
            try {
                result = dispatcher.handle(anys.get(i).getType().getKey(), anys.get(i).getKey());
                continue;
            }
            catch (Exception e) {
                LOG.warn("Failure pushing '{}' on '{}'", new Object[]{anys.get(i), resource, e});
                throw new JobExecutionException("While pushing " + anys.get(i) + " on " + resource, (Throwable)e);
            }
        }
        return result;
    }

    protected RealmPushResultHandler buildRealmHandler() {
        return (RealmPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPushResultHandler.class, 1, false);
    }

    protected AnyObjectPushResultHandler buildAnyObjectHandler() {
        return (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPushResultHandler.class, 1, false);
    }

    protected UserPushResultHandler buildUserHandler() {
        return (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPushResultHandler.class, 1, false);
    }

    protected GroupPushResultHandler buildGroupHandler() {
        return (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPushResultHandler.class, 1, false);
    }

    protected List<PushActions> getPushActions(List<? extends Implementation> impls) {
        ArrayList<PushActions> result = new ArrayList<PushActions>();
        impls.forEach(impl -> {
            try {
                result.add((PushActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PushActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    @Override
    protected String doExecuteProvisioning(PushTask pushTask, Connector connector, boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)pushTask.getResource());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.getActions().addAll(this.getPushActions(pushTask.getActions()));
        this.profile.setDryRun(dryRun);
        this.profile.setConflictResolutionAction(Optional.ofNullable(pushTask.getResource().getPushPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE));
        this.profile.setExecutor(executor);
        PushResultHandlerDispatcher dispatcher = new PushResultHandlerDispatcher(this.profile, this);
        if (!this.profile.isDryRun()) {
            for (PushActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
        }
        this.setStatus("Initialization completed");
        if (pushTask.getResource().getOrgUnit() != null) {
            this.setStatus("Pushing realms");
            dispatcher.addHandlerSupplier("REALM", () -> {
                RealmPushResultHandler handler = this.buildRealmHandler();
                handler.setProfile(this.profile);
                return handler;
            });
            List realms = this.realmDAO.findDescendants(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath(), null, -1, -1).stream().filter(realm -> realm.getParent() != null).collect(Collectors.toList());
            boolean result = true;
            for (int i = 0; i < realms.size() && result; ++i) {
                try {
                    result = dispatcher.handle("REALM", ((Realm)realms.get(i)).getKey());
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Failure pushing '{}' on '{}'", new Object[]{realms.get(i), pushTask.getResource(), e});
                    throw new JobExecutionException("While pushing " + realms.get(i) + " on " + pushTask.getResource(), (Throwable)e);
                }
            }
        }
        ProvisionSorter provisionSorter = this.getProvisionSorter(pushTask);
        for (Provision provision2 : pushTask.getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).sorted((Comparator<Provision>)provisionSorter).collect(Collectors.toList())) {
            this.setStatus("Pushing " + provision2.getAnyType());
            AnyType anyType = this.anyTypeDAO.find(provision2.getAnyType());
            AnyDAO anyDAO = this.anyUtilsFactory.getInstance(anyType.getKind()).dao();
            dispatcher.addHandlerSupplier(provision2.getAnyType(), () -> {
                UserPushResultHandler handler;
                switch (anyType.getKind()) {
                    case USER: {
                        handler = this.buildUserHandler();
                        break;
                    }
                    case GROUP: {
                        handler = this.buildGroupHandler();
                        break;
                    }
                    default: {
                        handler = this.buildAnyObjectHandler();
                    }
                }
                handler.setProfile(this.profile);
                return handler;
            });
            String filter = pushTask.getFilter(anyType.getKey()).orElse(null);
            SearchCond cond = StringUtils.isBlank((CharSequence)filter) ? anyDAO.getAllMatchingCond() : SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)filter, (String[])new String[0]);
            int count = this.searchDAO.count(((PushTask)this.profile.getTask()).getSourceRealm(), true, Set.of(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, anyType.getKind());
            boolean result = true;
            for (int page = 1; page <= count / 500 + 1 && result; ++page) {
                List anys = this.searchDAO.search(((PushTask)this.profile.getTask()).getSourceRealm(), true, Set.of(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, page, 500, List.of(), anyType.getKind());
                result = this.doHandle(anys, dispatcher, pushTask.getResource());
            }
        }
        if (!this.profile.isDryRun()) {
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
        }
        dispatcher.cleanup();
        this.setStatus("Push done");
        String result = this.createReport(this.profile.getResults(), pushTask.getResource(), dryRun);
        LOG.debug("Push result: {}", (Object)result);
        return result;
    }
}

