/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.rules.PullMatch;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.spring.implementation.InstanceScope;
import org.apache.syncope.core.spring.implementation.SyncopeImplementation;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@SyncopeImplementation(scope=InstanceScope.PER_CONTEXT)
public class LDAPMembershipPullActions
implements PullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPullActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected UserProvisioningManager userProvisioningManager;
    protected final Map<String, Set<String>> membershipsBefore = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> membershipsAfter = new HashMap<String, Set<String>>();

    protected String getGroupMembershipAttrName(Connector connector) {
        return connector.getConnInstance().getConf().stream().filter(property -> "groupMemberAttribute".equals(property.getSchema().getName()) && !property.getValues().isEmpty()).findFirst().map(groupMembership -> (String)groupMembership.getValues().get(0)).orElse("uniquemember");
    }

    protected List<Object> getMembAttrValues(SyncDelta delta, Connector connector) {
        String groupMemberName = this.getGroupMembershipAttrName(connector);
        Attribute membAttr = delta.getObject().getAttributeByName(groupMemberName);
        if (membAttr == null) {
            ConnectorObject remoteObj = connector.getObject(ObjectClass.GROUP, (Attribute)delta.getUid(), false, new OperationOptionsBuilder().setAttributesToGet(new String[]{groupMemberName}).build());
            if (remoteObj == null) {
                LOG.debug("Object for '{}' not found", (Object)delta.getUid().getUidValue());
            } else {
                membAttr = remoteObj.getAttributeByName(groupMemberName);
            }
        }
        return membAttr == null || membAttr.getValue() == null ? List.of() : membAttr.getValue();
    }

    @Transactional(readOnly=true)
    public void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, AnyUR anyUR) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.beforeUpdate(profile, delta, entity, anyUR);
            return;
        }
        this.groupDAO.findUMemberships((Group)this.groupDAO.find(entity.getKey())).forEach(uMembership -> {
            Set<String> memb = this.membershipsBefore.get(((User)uMembership.getLeftEnd()).getKey());
            if (memb == null) {
                memb = new HashSet<String>();
                this.membershipsBefore.put(((User)uMembership.getLeftEnd()).getKey(), memb);
            }
            memb.add(entity.getKey());
        });
    }

    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.after(profile, delta, entity, result);
            return;
        }
        Optional<Provision> provision = profile.getTask().getResource().getProvisionByAnyType(AnyTypeKind.USER.name()).filter(p -> p.getMapping() != null);
        if (provision.isEmpty()) {
            super.after(profile, delta, entity, result);
            return;
        }
        this.getMembAttrValues(delta, profile.getConnector()).forEach(membValue -> {
            Optional<PullMatch> match = this.inboundMatcher.match(this.anyTypeDAO.findUser(), membValue.toString(), profile.getTask().getResource(), profile.getConnector());
            if (match.isPresent()) {
                Set<String> memb = this.membershipsAfter.get(match.get().getAny().getKey());
                if (memb == null) {
                    memb = new HashSet<String>();
                    this.membershipsAfter.put(match.get().getAny().getKey(), memb);
                }
                memb.add(entity.getKey());
            } else {
                LOG.warn("Could not find matching user for {}", membValue);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        ArrayList updateReqs = new ArrayList();
        this.membershipsAfter.forEach((user, groups) -> {
            UserUR userUR = new UserUR();
            userUR.setKey(user);
            updateReqs.add(userUR);
            groups.stream().forEach(group -> {
                Set<String> before = this.membershipsBefore.get(user);
                if (before == null || !before.contains(group)) {
                    userUR.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group).operation(PatchOperation.ADD_REPLACE)).build());
                }
            });
        });
        this.membershipsBefore.forEach((user, groups) -> {
            UserUR userUR = updateReqs.stream().filter(req -> user.equals(req.getKey())).findFirst().orElseGet(() -> {
                UserUR req = (UserUR)new UserUR.Builder(user).build();
                updateReqs.add(req);
                return req;
            });
            groups.forEach(group -> {
                Set<String> after = this.membershipsAfter.get(user);
                if (after == null || !after.contains(group)) {
                    userUR.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group).operation(PatchOperation.DELETE)).build());
                }
            });
        });
        this.membershipsAfter.clear();
        this.membershipsBefore.clear();
        String context = "PullTask " + profile.getTask().getKey() + " '" + profile.getTask().getName() + "'";
        updateReqs.stream().filter(req -> !req.isEmpty()).forEach(req -> {
            LOG.debug("About to update memberships for User {}", (Object)req.getKey());
            this.userProvisioningManager.update(req, true, profile.getExecutor(), context);
        });
    }
}

