/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPushResultHandler;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.quartz.JobExecutionException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultUserPushResultHandler
extends AbstractPushResultHandler
implements UserPushResultHandler {
    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected String getName(Any<?> any) {
        return ((User)User.class.cast(any)).getUsername();
    }

    @Override
    protected AnyTO getAnyTO(Any<?> any) {
        return this.userDataBinder.getUserTO((User)any, true);
    }

    @Override
    protected void provision(Any<?> any, Boolean enabled, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any);
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        ((User)any).getLinkedAccounts(((PushTask)this.profile.getTask()).getResource().getKey()).forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.getUserCreateTasks(before.getKey(), null, enabled, propByRes, propByLinkedAccount, (Collection)before.getVirAttrs(), noPropResources), false, this.profile.getExecutor());
        DefaultUserPushResultHandler.reportPropagation(result, reporter);
    }

    @Override
    protected void update(Any<?> any, Boolean enable, ConnectorObject beforeObj, ProvisioningReport result) {
        List ownedResources = this.getAnyUtils().getAllResources(any).stream().map(Entity::getKey).collect(Collectors.toList());
        ArrayList noPropResources = new ArrayList(ownedResources);
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        ((User)any).getLinkedAccounts(((PushTask)this.profile.getTask()).getResource().getKey()).forEach(account -> propByLinkedAccount.add(ResourceOperation.UPDATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        List taskInfos = this.propagationManager.getUpdateTasks(any.getType().getKind(), any.getKey(), true, enable, propByRes, propByLinkedAccount, null, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.profile.getExecutor());
            DefaultUserPushResultHandler.reportPropagation(result, reporter);
        }
    }

    @Override
    protected void deprovision(Any<?> any, ConnectorObject beforeObj, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any);
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        ((User)any).getLinkedAccounts(((PushTask)this.profile.getTask()).getResource().getKey()).forEach(account -> propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        List taskInfos = this.propagationManager.getDeleteTasks(any.getType().getKind(), any.getKey(), propByRes, propByLinkedAccount, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.profile.getExecutor());
            DefaultUserPushResultHandler.reportPropagation(result, reporter);
        }
    }

    @Override
    protected WorkflowResult<? extends AnyUR> update(AnyUR req) {
        UserWorkflowResult update = this.uwfAdapter.update((UserUR)req, this.profile.getExecutor(), this.getContext());
        return new WorkflowResult((Object)((UserUR)((Pair)update.getResult()).getLeft()), update.getPropByRes(), update.getPerformedTasks());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(LinkedAccount account, Provision provision) {
        try {
            this.doHandle(account, provision);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = this.profile.getResults().stream().filter(report -> account.getKey().equalsIgnoreCase(report.getKey())).findFirst().orElse(null);
            if (ignoreResult == null) {
                ignoreResult = new ProvisioningReport();
                ignoreResult.setKey(account.getKey());
                ignoreResult.setAnyType(MatchType.LINKED_ACCOUNT.name());
                ignoreResult.setUidValue(account.getConnObjectKeyValue());
                this.profile.getResults().add(ignoreResult);
            }
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    protected void doHandle(LinkedAccount account, Provision provision) throws JobExecutionException {
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(account.getKey());
        result.setAnyType(MatchType.LINKED_ACCOUNT.name());
        result.setUidValue(account.getConnObjectKeyValue());
        result.setName(account.getConnObjectKeyValue());
        LOG.debug("Pushing linked account {} towards {}", (Object)account.getKey(), (Object)((PushTask)this.profile.getTask()).getResource());
        Optional connObj = MappingUtils.getConnObjectKeyItem(provision).flatMap(connObjectKeyItem -> this.outboundMatcher.matchByConnObjectKeyValue(this.profile.getConnector(), (Item)connObjectKeyItem, account.getConnObjectKeyValue(), ((PushTask)this.profile.getTask()).getResource(), provision, Optional.empty(), Optional.empty()));
        LOG.debug("Match found for linked account {} as {}: {}", new Object[]{account, provision.getObjectClass(), connObj});
        ConnectorObject beforeObj = connObj.orElse(null);
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(DefaultUserPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(DefaultUserPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
        } else {
            Boolean enable = ((PushTask)this.profile.getTask()).isSyncStatus() ? BooleanUtils.negate((Boolean)account.isSuspended()) : null;
            try {
                if (beforeObj == null) {
                    result.setOperation(DefaultUserPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                    switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            for (PushActions action : this.profile.getActions()) {
                                if (((PushTask)this.profile.getTask()).getUnmatchingRule() == UnmatchingRule.ASSIGN) {
                                    action.beforeAssign(this.profile, (Entity)account);
                                    continue;
                                }
                                action.beforeProvision(this.profile, (Entity)account);
                            }
                            if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                                LOG.debug("PushTask not configured for create");
                                result.setStatus(ProvisioningReport.Status.IGNORE);
                                break;
                            }
                            this.provision(account, enable, result);
                            break;
                        }
                        case UNLINK: {
                            LOG.warn("{} not applicable to linked accounts, ignoring", (Object)((PushTask)this.profile.getTask()).getUnmatchingRule());
                            break;
                        }
                        case IGNORE: {
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                    }
                } else {
                    result.setOperation(DefaultUserPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                    switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            for (PushActions action : this.profile.getActions()) {
                                action.beforeUpdate(this.profile, (Entity)account);
                            }
                            if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                                LOG.debug("PushTask not configured for update");
                                result.setStatus(ProvisioningReport.Status.IGNORE);
                                break;
                            }
                            this.update(account, enable, beforeObj, ResourceOperation.UPDATE, result);
                            break;
                        }
                        case UNASSIGN: 
                        case DEPROVISION: {
                            for (PushActions action : this.profile.getActions()) {
                                if (((PushTask)this.profile.getTask()).getMatchingRule() == MatchingRule.UNASSIGN) {
                                    action.beforeUnassign(this.profile, (Entity)account);
                                    continue;
                                }
                                action.beforeDeprovision(this.profile, (Entity)account);
                            }
                            if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                                LOG.debug("PushTask not configured for delete");
                                result.setStatus(ProvisioningReport.Status.IGNORE);
                                break;
                            }
                            this.update(account, enable, beforeObj, ResourceOperation.DELETE, result);
                            break;
                        }
                        case LINK: 
                        case UNLINK: {
                            LOG.warn("{} not applicable to linked accounts, ignoring", (Object)((PushTask)this.profile.getTask()).getMatchingRule());
                            break;
                        }
                        case IGNORE: {
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                    }
                }
                for (PushActions action : this.profile.getActions()) {
                    action.after(this.profile, (Entity)account, result);
                }
                if (result.getStatus() == null) {
                    result.setStatus(ProvisioningReport.Status.SUCCESS);
                }
            }
            catch (IgnoreProvisionException e) {
                throw e;
            }
            catch (Exception e) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.warn("Error pushing linked account {} towards {}", new Object[]{account, ((PushTask)this.profile.getTask()).getResource(), e});
                for (PushActions action : this.profile.getActions()) {
                    action.onError(this.profile, (Entity)account, result, e);
                }
                throw new JobExecutionException((Throwable)e);
            }
        }
    }

    protected void provision(LinkedAccount account, Boolean enable, ProvisioningReport result) {
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
        List taskInfos = this.propagationManager.getUserCreateTasks(account.getOwner().getKey(), null, enable, new PropagationByResource(), propByLinkedAccount, null, null);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.empty());
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.profile.getExecutor());
            DefaultUserPushResultHandler.reportPropagation(result, reporter);
        }
    }

    protected void update(LinkedAccount account, Boolean enable, ConnectorObject beforeObj, ResourceOperation operation, ProvisioningReport result) {
        UserUR req = new UserUR();
        req.setKey(account.getOwner().getKey());
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        propByLinkedAccount.add(operation, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
        List taskInfos = this.propagationManager.getUserUpdateTasks(new UserWorkflowResult((Object)Pair.of((Object)req, (Object)enable), new PropagationByResource(), propByLinkedAccount, ""));
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.empty());
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.profile.getExecutor());
            DefaultUserPushResultHandler.reportPropagation(result, reporter);
        }
    }
}

