/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractRealmResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultRealmPullResultHandler
extends AbstractRealmResultHandler<PullTask, PullActions>
implements RealmPullResultHandler {
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected CASSPClientAppDAO casSPClientAppDAO;
    @Autowired
    protected OIDCRPClientAppDAO oidcRPClientAppDAO;
    @Autowired
    protected SAML2SPClientAppDAO saml2SPClientAppDAO;

    protected static AuditElements.Result and(AuditElements.Result left, AuditElements.Result right) {
        return left == AuditElements.Result.SUCCESS && right == AuditElements.Result.SUCCESS ? AuditElements.Result.SUCCESS : AuditElements.Result.FAILURE;
    }

    public boolean handle(SyncDelta delta) {
        try {
            OrgUnit orgUnit = Optional.ofNullable(((PullTask)this.profile.getTask()).getResource().getOrgUnit()).orElseThrow(() -> new JobExecutionException("No orgUnit found on " + ((PullTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass()));
            AuditElements.Result latestResult = this.doHandle(delta, orgUnit);
            LOG.debug("Successfully handled {}", (Object)delta);
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                return true;
            }
            return latestResult == AuditElements.Result.SUCCESS;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setAnyType("REALM");
            ignoreResult.setKey(null);
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    protected void throwIgnoreProvisionException(SyncDelta delta, Exception exception) throws JobExecutionException {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (PullActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    protected AuditElements.Result assign(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        realmTO.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.end(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        for (PullActions action : this.profile.getActions()) {
            action.beforeAssign(this.profile, delta, realmTO);
        }
        this.profile.getResults().add(result);
        return this.create(realmTO, delta, UnmatchingRule.ASSIGN, result);
    }

    protected AuditElements.Result provision(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.end(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        for (PullActions action : this.profile.getActions()) {
            action.beforeProvision(this.profile, delta, realmTO);
        }
        this.profile.getResults().add(result);
        return this.create(realmTO, delta, UnmatchingRule.PROVISION, result);
    }

    protected AuditElements.Result create(RealmTO realmTO, SyncDelta delta, UnmatchingRule unmatchingRule, ProvisioningReport result) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Throwable output;
        try {
            Realm realm = this.realmDAO.save(this.binder.create(((PullTask)this.profile.getTask()).getDestinationRealm(), realmTO));
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.CREATE, (Collection)realm.getResourceKeys());
            if (unmatchingRule == UnmatchingRule.ASSIGN) {
                List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
                this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
            }
            RealmTO actual = this.binder.getRealmTO(realm, true);
            result.setKey(actual.getKey());
            result.setName(((PullTask)this.profile.getTask()).getDestinationRealm().getFullPath() + "/" + actual.getName());
            output = actual;
            resultStatus = AuditElements.Result.SUCCESS;
            for (PullActions action : this.profile.getActions()) {
                action.after(this.profile, delta, (EntityTO)actual, result);
            }
            LOG.debug("Realm {} successfully created", (Object)actual.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create Realm {} ", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        this.end(UnmatchingRule.toEventName((UnmatchingRule)unmatchingRule), resultStatus, null, output, delta);
        return resultStatus;
    }

    protected AuditElements.Result update(SyncDelta delta, List<Realm> realms, boolean inLink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to update {}", realms);
        AuditElements.Result global = AuditElements.Result.SUCCESS;
        for (Realm realm : realms) {
            LOG.debug("About to update {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Throwable output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    if (!inLink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, delta, (EntityTO)before, null);
                        }
                    }
                    Map beforeAttrs = this.propagationManager.prepareAttrs(realm);
                    PropagationByResource propByRes = this.binder.update(realm, before);
                    realm = this.realmDAO.save(realm);
                    RealmTO updated = this.binder.getRealmTO(realm, true);
                    List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.createTasks(realm, propByRes, null), beforeAttrs, null);
                    this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)updated, result);
                    }
                    output = updated;
                    resultStatus = AuditElements.Result.SUCCESS;
                    result.setName(updated.getFullPath());
                    LOG.debug("{} successfully updated", (Object)updated);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.end(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta);
                global = DefaultRealmPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected AuditElements.Result deprovision(SyncDelta delta, List<Realm> realms, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to deprovision {}", realms);
        AuditElements.Result global = AuditElements.Result.SUCCESS;
        for (Realm realm : realms) {
            LOG.debug("About to unassign resource {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Throwable output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    RealmTO realmTO;
                    if (unlink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, delta, (EntityTO)before);
                        }
                    } else {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                        }
                    }
                    PropagationByResource propByRes = new PropagationByResource();
                    propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PullTask)this.profile.getTask()).getResource().getKey()));
                    this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, null), false, this.securityProperties.getAdminUser());
                    if (unlink) {
                        realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                        realmTO = this.binder.getRealmTO(this.realmDAO.save(realm), true);
                    } else {
                        realmTO = this.binder.getRealmTO(realm, true);
                    }
                    output = realmTO;
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)realmTO, result);
                    }
                    resultStatus = AuditElements.Result.SUCCESS;
                    LOG.debug("{} successfully updated", (Object)realm);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.end(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), resultStatus, before, output, delta);
                global = DefaultRealmPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected AuditElements.Result link(SyncDelta delta, List<Realm> realms, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to link {}", realms);
        AuditElements.Result global = AuditElements.Result.SUCCESS;
        for (Realm realm : realms) {
            LOG.debug("About to unassign resource {}", (Object)realm);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(realm.getKey());
            result.setName(realm.getFullPath());
            if (!this.profile.isDryRun()) {
                AuditElements.Result resultStatus;
                Throwable output;
                RealmTO before = this.binder.getRealmTO(realm, true);
                try {
                    if (unlink) {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, delta, (EntityTO)before);
                        }
                    } else {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, delta, (EntityTO)before);
                        }
                    }
                    if (unlink) {
                        realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                    } else {
                        realm.add(((PullTask)this.profile.getTask()).getResource());
                    }
                    output = this.update(delta, List.of(realm), true);
                    resultStatus = AuditElements.Result.SUCCESS;
                    LOG.debug("{} successfully updated", (Object)realm);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                this.end(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta);
                global = DefaultRealmPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected AuditElements.Result delete(SyncDelta delta, List<Realm> realms) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.end(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to delete {}", realms);
        AuditElements.Result global = AuditElements.Result.SUCCESS;
        for (Realm realm : realms) {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            RealmTO before = this.binder.getRealmTO(realm, true);
            try {
                result.setKey(realm.getKey());
                result.setName(realm.getFullPath());
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType("REALM");
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                if (!this.profile.isDryRun()) {
                    Exception output;
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    try {
                        if (!this.realmDAO.findChildren(realm).isEmpty()) {
                            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
                        }
                        Set<String> adminRealms = Set.of(realm.getFullPath());
                        AnyCond keyCond = new AnyCond(AttrCond.Type.ISNOTNULL);
                        keyCond.setSchema("key");
                        SearchCond allMatchingCond = SearchCond.getLeaf((AbstractSearchCond)keyCond);
                        int users = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.USER);
                        int groups = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.GROUP);
                        int anyObjects = this.searchDAO.count(this.realmDAO.getRoot(), true, adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
                        int macroTasks = this.taskDAO.findByRealm(realm).size();
                        int clientApps = this.casSPClientAppDAO.findByRealm(realm).size() + this.saml2SPClientAppDAO.findByRealm(realm).size() + this.oidcRPClientAppDAO.findByRealm(realm).size();
                        if (users + groups + anyObjects + macroTasks + clientApps > 0) {
                            SyncopeClientException realmContains = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
                            realmContains.getElements().add(users + " user(s)");
                            realmContains.getElements().add(groups + " group(s)");
                            realmContains.getElements().add(anyObjects + " anyObject(s)");
                            realmContains.getElements().add(macroTasks + " command task(s)");
                            realmContains.getElements().add(clientApps + " client app(s)");
                            throw realmContains;
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.addAll(ResourceOperation.DELETE, (Collection)realm.getResourceKeys());
                        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
                        this.taskExecutor.execute((Collection)taskInfos, false, this.securityProperties.getAdminUser());
                        this.realmDAO.delete(realm);
                        output = null;
                        resultStatus = AuditElements.Result.SUCCESS;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, result);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {}", (Object)realm, (Object)e);
                        output = e;
                    }
                    this.end(ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta);
                    global = DefaultRealmPullResultHandler.and(global, resultStatus);
                }
                this.profile.getResults().add(result);
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read Realm {}", (Object)realm, (Object)e);
            }
            catch (Exception e) {
                LOG.error("Could not delete Realm {}", (Object)realm, (Object)e);
            }
        }
        return global;
    }

    protected AuditElements.Result ignore(SyncDelta delta, boolean matching) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ProvisioningReport report = new ProvisioningReport();
        report.setKey(null);
        report.setName(delta.getObject().getUid().getUidValue());
        report.setOperation(ResourceOperation.NONE);
        report.setAnyType("REALM");
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        this.profile.getResults().add(report);
        if (!this.profile.isDryRun()) {
            this.end(matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta);
            return AuditElements.Result.SUCCESS;
        }
        return AuditElements.Result.SUCCESS;
    }

    protected AuditElements.Result doHandle(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta finalDelta = delta;
        for (PullActions action : this.profile.getActions()) {
            finalDelta = action.preprocess(this.profile, finalDelta);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{finalDelta.getDeltaType(), finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass()});
        List<Realm> realms = this.inboundMatcher.match(finalDelta, orgUnit);
        LOG.debug("Match found for {} as {}: {}", new Object[]{finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass(), realms});
        if (realms.size() > 1) {
            switch (this.profile.getConflictResolutionAction()) {
                case IGNORE: {
                    throw new IgnoreProvisionException("More than one match found for " + finalDelta.getObject().getUid().getUidValue() + ": " + realms);
                }
                case FIRSTMATCH: {
                    realms = realms.subList(0, 1);
                    break;
                }
                case LASTMATCH: {
                    realms = realms.subList(realms.size() - 1, realms.size());
                    break;
                }
            }
        }
        AuditElements.Result result = AuditElements.Result.SUCCESS;
        try {
            block6 : switch (delta.getDeltaType()) {
                case CREATE: 
                case UPDATE: 
                case CREATE_OR_UPDATE: {
                    if (realms.isEmpty()) {
                        switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                            case ASSIGN: {
                                result = this.assign(finalDelta, orgUnit);
                                break block6;
                            }
                            case PROVISION: {
                                result = this.provision(finalDelta, orgUnit);
                                break block6;
                            }
                            case IGNORE: {
                                result = this.ignore(finalDelta, false);
                                break block6;
                            }
                        }
                        break;
                    }
                    switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            result = this.update(finalDelta, realms, false);
                            break block6;
                        }
                        case DEPROVISION: {
                            result = this.deprovision(finalDelta, realms, false);
                            break block6;
                        }
                        case UNASSIGN: {
                            result = this.deprovision(finalDelta, realms, true);
                            break block6;
                        }
                        case LINK: {
                            result = this.link(finalDelta, realms, false);
                            break block6;
                        }
                        case UNLINK: {
                            result = this.link(finalDelta, realms, true);
                            break block6;
                        }
                        case IGNORE: {
                            result = this.ignore(finalDelta, true);
                            break block6;
                        }
                    }
                    break;
                }
                case DELETE: {
                    if (realms.isEmpty()) {
                        this.end(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, finalDelta);
                        LOG.debug("No match found for deletion");
                        break;
                    }
                    result = this.delete(finalDelta, realms);
                    break;
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
        return result;
    }

    protected void end(String event, AuditElements.Result result, Object before, Object output, SyncDelta delta) {
        this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
        this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
    }
}

