/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.identityconnectors.common.IOUtil;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.Transactional;

public class DefaultJobManager
implements JobManager,
SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    protected final DomainHolder domainHolder;
    protected final SchedulerFactoryBean scheduler;
    protected final TaskDAO taskDAO;
    protected final ReportDAO reportDAO;
    protected final ImplementationDAO implementationDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final ConfParamOps confParamOps;
    protected final SecurityProperties securityProperties;
    protected boolean disableQuartzInstance;

    public DefaultJobManager(DomainHolder domainHolder, SchedulerFactoryBean scheduler, TaskDAO taskDAO, ReportDAO reportDAO, ImplementationDAO implementationDAO, TaskUtilsFactory taskUtilsFactory, ConfParamOps confParamOps, SecurityProperties securityProperties) {
        this.domainHolder = domainHolder;
        this.scheduler = scheduler;
        this.taskDAO = taskDAO;
        this.reportDAO = reportDAO;
        this.implementationDAO = implementationDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.confParamOps = confParamOps;
        this.securityProperties = securityProperties;
    }

    public void setDisableQuartzInstance(boolean disableQuartzInstance) {
        this.disableQuartzInstance = disableQuartzInstance;
    }

    protected boolean isRunningHere(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getScheduler().getCurrentlyExecutingJobs().stream().anyMatch(jec -> jobKey.equals((Object)jec.getJobDetail().getKey()));
    }

    protected boolean isRunningElsewhere(JobKey jobKey) throws SchedulerException {
        boolean bl;
        if (!this.scheduler.getScheduler().getMetaData().isJobStoreClustered()) {
            return false;
        }
        DataSource dataSource = (DataSource)this.domainHolder.getDomains().get("Master");
        Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement("SELECT 1 FROM QRTZ_FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?");
            stmt.setString(1, jobKey.getName());
            stmt.setString(2, jobKey.getGroup());
            resultSet = stmt.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new SchedulerException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.quietClose(resultSet);
                IOUtil.quietClose((Statement)stmt);
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
                throw throwable;
            }
        }
        IOUtil.quietClose((ResultSet)resultSet);
        IOUtil.quietClose((Statement)stmt);
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
        return bl;
    }

    public boolean isRunning(JobKey jobKey) throws SchedulerException {
        return this.isRunningHere(jobKey) || this.isRunningElsewhere(jobKey);
    }

    protected void registerJob(String jobName, Class<? extends Job> jobClass, String cronExpression, Date startAt, Map<String, Object> jobMap) throws SchedulerException {
        if (this.isRunning(new JobKey(jobName, "DEFAULT"))) {
            LOG.debug("Job {} already running, cancel", (Object)jobName);
            return;
        }
        this.unregisterJob(jobName);
        JobBuilder jobDetailBuilder = JobBuilder.newJob(jobClass).withIdentity(jobName).usingJobData(new JobDataMap(jobMap));
        if (cronExpression == null && startAt == null) {
            this.scheduler.getScheduler().addJob(jobDetailBuilder.storeDurably().build(), true);
        } else {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(JobNamer.getTriggerName((String)jobName));
            if (cronExpression == null) {
                triggerBuilder.startAt(startAt);
            } else {
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
                if (startAt == null) {
                    triggerBuilder.startNow();
                } else {
                    triggerBuilder.startAt(startAt);
                }
            }
            this.scheduler.getScheduler().scheduleJob(jobDetailBuilder.build(), triggerBuilder.build());
        }
    }

    public Map<String, Object> register(SchedTask task, OffsetDateTime startAt, String executor) throws SchedulerException {
        Implementation jobDelegate;
        Object object = task.getJobDelegate() == null ? (task instanceof PullTask ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> PullJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : (task instanceof PushTask ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> PushJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElse(null) : null)) : (jobDelegate = task.getJobDelegate());
        if (jobDelegate == null) {
            throw new IllegalArgumentException("Task " + task + " does not provide any " + SchedTaskJobDelegate.class.getSimpleName());
        }
        Map<String, Object> jobMap = this.createJobMapForExecutionContext(executor);
        jobMap.put("taskType", this.taskUtilsFactory.getInstance((Task)task).getType());
        jobMap.put("taskKey", task.getKey());
        jobMap.put("delegateImpl", jobDelegate.getKey());
        this.registerJob(JobNamer.getJobKey((Task)task).getName(), TaskJob.class, task.getCronExpression(), Optional.ofNullable(startAt).map(s -> new Date(s.toInstant().toEpochMilli())).orElse(null), jobMap);
        return jobMap;
    }

    public Map<String, Object> register(Report report, OffsetDateTime startAt, String executor) throws SchedulerException {
        Map<String, Object> jobMap = this.createJobMapForExecutionContext(executor);
        jobMap.put("reportKey", report.getKey());
        jobMap.put("delegateImpl", report.getJobDelegate().getKey());
        this.registerJob(JobNamer.getJobKey((Report)report).getName(), ReportJob.class, report.getCronExpression(), Optional.ofNullable(startAt).map(s -> new Date(s.toInstant().toEpochMilli())).orElse(null), jobMap);
        return jobMap;
    }

    protected Map<String, Object> createJobMapForExecutionContext(String executor) {
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("domain", AuthContextUtils.getDomain());
        jobMap.put("executor", executor);
        return jobMap;
    }

    protected void unregisterJob(String jobName) {
        try {
            this.scheduler.getScheduler().unscheduleJob(new TriggerKey(jobName, "DEFAULT"));
            this.scheduler.getScheduler().deleteJob(new JobKey(jobName, "DEFAULT"));
        }
        catch (SchedulerException e) {
            LOG.error("Could not remove job " + jobName, (Throwable)e);
        }
    }

    public void unregister(Task<?> task) {
        this.unregisterJob(JobNamer.getJobKey(task).getName());
    }

    public void unregister(Report report) {
        this.unregisterJob(JobNamer.getJobKey((Report)report).getName());
    }

    public int getOrder() {
        return 500;
    }

    @Transactional
    public void load(String domain, DataSource datasource) {
        if (this.disableQuartzInstance) {
            String instanceId = "AUTO";
            try {
                instanceId = this.scheduler.getScheduler().getSchedulerInstanceId();
                this.scheduler.getScheduler().standby();
                LOG.info("Successfully put Quartz instance {} in standby", (Object)instanceId);
            }
            catch (SchedulerException e) {
                LOG.error("Could not put Quartz instance {} in standby", (Object)instanceId, (Object)e);
            }
            return;
        }
        String notificationJobCronExp = (String)AuthContextUtils.callAsAdmin((String)"Master", () -> {
            String result = "";
            String conf = (String)this.confParamOps.get("Master", "notificationjob.cronExpression", null, String.class);
            if (conf == null) {
                result = "0 0/5 * * * ?";
            } else if (!"".equals(conf)) {
                result = conf;
            }
            return result;
        });
        AuthContextUtils.callAsAdmin((String)domain, () -> {
            HashSet tasks = new HashSet(this.taskDAO.findAll(TaskType.SCHEDULED));
            tasks.addAll(this.taskDAO.findAll(TaskType.PULL));
            tasks.addAll(this.taskDAO.findAll(TaskType.PUSH));
            boolean loadException = false;
            Iterator it = tasks.iterator();
            while (it.hasNext() && !loadException) {
                SchedTask task = (SchedTask)it.next();
                try {
                    this.register(task, task.getStartAt(), this.securityProperties.getAdminUser());
                }
                catch (Exception e) {
                    LOG.error("While loading job instance for task " + task.getKey(), (Throwable)e);
                    loadException = true;
                }
            }
            if (loadException) {
                LOG.debug("Errors while loading job instances for tasks, aborting");
            } else {
                it = this.reportDAO.findAll().iterator();
                while (it.hasNext() && !loadException) {
                    Report report = (Report)it.next();
                    try {
                        this.register(report, null, this.securityProperties.getAdminUser());
                    }
                    catch (Exception e) {
                        LOG.error("While loading job instance for report " + report.getName(), (Throwable)e);
                        loadException = true;
                    }
                }
                if (loadException) {
                    LOG.debug("Errors while loading job instances for reports, aborting");
                }
            }
            return null;
        });
        if ("Master".equals(domain)) {
            Map<String, Object> jobData;
            if (StringUtils.isBlank((CharSequence)notificationJobCronExp)) {
                LOG.debug("Empty value provided for {}'s cron, not registering anything on Quartz", (Object)NotificationJob.class.getSimpleName());
            } else {
                LOG.debug("{}'s cron expression: {} - registering Quartz job and trigger", (Object)NotificationJob.class.getSimpleName(), (Object)notificationJobCronExp);
                try {
                    jobData = this.createJobMapForExecutionContext(this.securityProperties.getAdminUser());
                    this.registerJob(NOTIFICATION_JOB.getName(), NotificationJob.class, notificationJobCronExp, null, jobData);
                }
                catch (Exception e) {
                    LOG.error("While loading {} instance", (Object)NotificationJob.class.getSimpleName(), (Object)e);
                }
            }
            LOG.debug("Registering {}", SystemLoadReporterJob.class);
            try {
                jobData = this.createJobMapForExecutionContext(this.securityProperties.getAdminUser());
                this.registerJob(StringUtils.uncapitalize((String)SystemLoadReporterJob.class.getSimpleName()), SystemLoadReporterJob.class, "0 * * * * ?", null, jobData);
            }
            catch (Exception e) {
                LOG.error("While loading {} instance", (Object)SystemLoadReporterJob.class.getSimpleName(), (Object)e);
            }
        }
    }

    public void unload(String domain) {
        AuthContextUtils.callAsAdmin((String)domain, () -> {
            HashSet tasks = new HashSet(this.taskDAO.findAll(TaskType.SCHEDULED));
            tasks.addAll(this.taskDAO.findAll(TaskType.PULL));
            tasks.addAll(this.taskDAO.findAll(TaskType.PUSH));
            tasks.forEach(task -> {
                try {
                    this.unregister((Task<?>)task);
                }
                catch (Exception e) {
                    LOG.error("While unloading job instance for task " + task.getKey(), (Throwable)e);
                }
            });
            this.reportDAO.findAll().forEach(report -> {
                try {
                    this.unregister((Report)report);
                }
                catch (Exception e) {
                    LOG.error("While unloading job instance for report " + report.getName(), (Throwable)e);
                }
            });
            return null;
        });
    }
}

