/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AbstractAnyDataBinder
implements UserDataBinder {
    protected final RoleDAO roleDAO;
    protected final SecurityQuestionDAO securityQuestionDAO;
    protected final ApplicationDAO applicationDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final DelegationDAO delegationDAO;
    protected final ConfParamOps confParamOps;
    protected final SecurityProperties securityProperties;

    public UserDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmDAO realmDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, RoleDAO roleDAO, SecurityQuestionDAO securityQuestionDAO, ApplicationDAO applicationDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps, SecurityProperties securityProperties) {
        super(anyTypeDAO, realmDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, plainAttrDAO, plainAttrValueDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, virAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
        this.roleDAO = roleDAO;
        this.securityQuestionDAO = securityQuestionDAO;
        this.applicationDAO = applicationDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.delegationDAO = delegationDAO;
        this.confParamOps = confParamOps;
        this.securityProperties = securityProperties;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.securityProperties.getAnonymousUser().equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.securityProperties.getAnonymousUser());
        } else if (this.securityProperties.getAdminUser().equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.securityProperties.getAdminUser());
        } else {
            User authUser = this.userDAO.findByUsername(authUsername);
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    protected RuntimeException aggregateException(SyncopeClientCompositeException scce, RuntimeException e, ClientExceptionType clientExceptionType) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)clientExceptionType);
        sce.getElements().add(e.getMessage());
        scce.addException(sce);
        return scce;
    }

    protected void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            this.setCipherAlgorithm(user);
            user.setPassword(password);
        }
        catch (IllegalArgumentException e) {
            throw this.aggregateException(scce, e, ClientExceptionType.NotFound);
        }
    }

    protected void setSecurityAnswer(User user, String securityAnswer, SyncopeClientCompositeException scce) {
        try {
            this.setCipherAlgorithm(user);
            user.setSecurityAnswer(securityAnswer);
        }
        catch (IllegalArgumentException e) {
            throw this.aggregateException(scce, e, ClientExceptionType.NotFound);
        }
    }

    protected void setCipherAlgorithm(User user) {
        if (user.getCipherAlgorithm() == null) {
            user.setCipherAlgorithm(CipherAlgorithm.valueOf((String)((String)this.confParamOps.get(AuthContextUtils.getDomain(), "password.cipher.algorithm", (Object)CipherAlgorithm.AES.name(), String.class))));
        }
    }

    protected void linkedAccount(final User user, final LinkedAccountTO accountTO, AnyUtils anyUtils, SyncopeClientException invalidValues) {
        final ExternalResource resource = this.resourceDAO.find(accountTO.getResource());
        if (resource == null) {
            LOG.debug("Ignoring invalid resource {}", (Object)accountTO.getResource());
        } else {
            Optional found = user.getLinkedAccount(resource.getKey(), accountTO.getConnObjectKeyValue());
            LinkedAccount account = found.isPresent() ? (LinkedAccount)found.get() : new Supplier<LinkedAccount>(){

                @Override
                public LinkedAccount get() {
                    LinkedAccount acct = (LinkedAccount)UserDataBinderImpl.this.entityFactory.newEntity(LinkedAccount.class);
                    acct.setOwner(user);
                    user.add(acct);
                    acct.setConnObjectKeyValue(accountTO.getConnObjectKeyValue());
                    acct.setResource(resource);
                    return acct;
                }
            }.get();
            account.setUsername(accountTO.getUsername());
            if (StringUtils.isBlank((CharSequence)accountTO.getPassword())) {
                account.setEncodedPassword(null, null);
            } else if (!accountTO.getPassword().equals(account.getPassword())) {
                if (account.getCipherAlgorithm() == null) {
                    account.setCipherAlgorithm(CipherAlgorithm.AES);
                }
                account.setPassword(accountTO.getPassword());
            }
            account.setSuspended(Boolean.valueOf(accountTO.isSuspended()));
            accountTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> {
                PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                if (schema != null) {
                    LAPlainAttr attr = account.getPlainAttr(schema.getKey()).orElse(null);
                    if (attr == null) {
                        attr = (LAPlainAttr)this.entityFactory.newEntity(LAPlainAttr.class);
                        attr.setSchema(schema);
                        attr.setOwner((Any)user);
                        attr.setAccount(account);
                    }
                    this.fillAttr(attrTO.getValues(), anyUtils, schema, (PlainAttr<?>)attr, invalidValues);
                    if (attr.getValuesAsStrings().isEmpty()) {
                        attr.setOwner(null);
                    } else {
                        account.add((PlainAttr)attr);
                    }
                }
            });
            accountTO.getPrivileges().forEach(key -> {
                Privilege privilege = this.applicationDAO.findPrivilege(key);
                if (privilege == null) {
                    LOG.debug("Invalid privilege {}, ignoring", key);
                } else {
                    account.add(privilege);
                }
            });
        }
    }

    public void create(User user, UserCR userCR) {
        SecurityQuestion securityQuestion;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        user.setUsername(userCR.getUsername());
        if (StringUtils.isBlank((CharSequence)userCR.getPassword()) || !userCR.isStorePassword()) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userCR.getPassword(), scce);
            user.setChangePwdDate(OffsetDateTime.now());
        }
        user.setMustChangePassword(userCR.isMustChangePassword());
        if (userCR.getSecurityQuestion() != null && (securityQuestion = this.securityQuestionDAO.find(userCR.getSecurityQuestion())) != null) {
            user.setSecurityQuestion(securityQuestion);
        }
        this.setSecurityAnswer(user, userCR.getSecurityAnswer(), scce);
        userCR.getRoles().forEach(roleKey -> {
            Role role = this.roleDAO.find(roleKey);
            if (role == null) {
                LOG.warn("Ignoring unknown role with id {}", roleKey);
            } else {
                user.add(role);
            }
        });
        Realm realm = this.realmDAO.findByFullPath(userCR.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userCR.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        HashSet relationships = new HashSet();
        userCR.getRelationships().forEach(relationshipTO -> {
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
            } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()))) {
                LOG.error("{} was already in relationship {} with {}", new Object[]{otherEnd, relationshipTO.getType(), user});
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                assigned.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " in relationship " + relationshipTO.getType());
                scce.addException(assigned);
            } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()));
                RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                if (relationshipType == null) {
                    LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                } else {
                    URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)user);
                    user.add((Relationship)relationship);
                }
            } else {
                LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)user);
                SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                scce.addException(unrelatable);
            }
        });
        HashSet groups = new HashSet();
        userCR.getMemberships().forEach(membershipTO -> {
            Group group;
            Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)(membershipTO.getGroupKey() + " / " + membershipTO.getGroupName()));
            } else if (groups.contains(group.getKey())) {
                LOG.error("{} was already assigned to {}", (Object)group, (Object)user);
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                assigned.getElements().add("Group " + group.getName() + " was already assigned");
                scce.addException(assigned);
            } else {
                groups.add(group.getKey());
                UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)user);
                user.add((Membership)membership);
                this.fill((Any)user, (Membership)membership, (MembershipTO)membershipTO, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        userCR.getLinkedAccounts().forEach(acct -> this.linkedAccount(user, (LinkedAccountTO)acct, this.anyUtilsFactory.getLinkedAccountInstance(), invalidValues));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        this.fill((Any)user, (AnyCR)userCR, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    protected boolean isPasswordMapped(ExternalResource resource) {
        return resource.getProvisionByAnyType(AnyTypeKind.USER.name()).filter(provision -> provision.getMapping() != null).map(provision -> provision.getMapping().getItems().stream().anyMatch(Item::isPassword)).orElse(false);
    }

    public Pair<PropagationByResource<String>, PropagationByResource<Pair<String, String>>> update(User toBeUpdated, UserUR userUR) {
        User user = (User)this.userDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        String password = null;
        boolean changePwd = false;
        if (userUR.getPassword() != null) {
            if (userUR.getPassword().getOperation() == PatchOperation.DELETE) {
                user.setEncodedPassword(null, null);
                changePwd = true;
            } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)userUR.getPassword().getValue()))) {
                if (userUR.getPassword().isOnSyncope()) {
                    this.setPassword(user, (String)userUR.getPassword().getValue(), scce);
                    user.setChangePwdDate(OffsetDateTime.now());
                }
                password = (String)userUR.getPassword().getValue();
                changePwd = true;
            }
            if (changePwd) {
                propByRes.addAll(ResourceOperation.UPDATE, (Collection)userUR.getPassword().getResources());
            }
        }
        Map<String, ConnObject> beforeOnResources = this.onResources((Any<?>)user, this.userDAO.findAllResourceKeys(user.getKey()), password, changePwd);
        this.setRealm((Any<?>)user, (AnyUR)userUR);
        if (userUR.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userUR.getUsername().getValue()))) {
            AccessToken accessToken;
            String oldUsername = user.getUsername();
            user.setUsername((String)userUR.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userUR.getUsername().getValue()));
            }
            if ((accessToken = this.accessTokenDAO.findByOwner(oldUsername)) != null) {
                accessToken.setOwner((String)userUR.getUsername().getValue());
                this.accessTokenDAO.save(accessToken);
            }
        }
        if (userUR.getSecurityQuestion() != null) {
            if (userUR.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                SecurityQuestion securityQuestion = this.securityQuestionDAO.find((String)userUR.getSecurityQuestion().getValue());
                if (securityQuestion != null) {
                    user.setSecurityQuestion(securityQuestion);
                    this.setSecurityAnswer(user, (String)userUR.getSecurityAnswer().getValue(), scce);
                }
            }
        }
        block3: for (StringPatchItem patch2 : userUR.getRoles()) {
            Role role = this.roleDAO.find((String)patch2.getValue());
            if (role == null) {
                LOG.warn("Ignoring unknown role with key {}", patch2.getValue());
                continue;
            }
            switch (patch2.getOperation()) {
                case ADD_REPLACE: {
                    user.add(role);
                    continue block3;
                }
            }
            user.getRoles().remove(role);
        }
        this.fill((Any)user, (AnyUR)userUR, anyUtils, scce);
        HashSet relationships = new HashSet();
        userUR.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEach(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                user.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    user.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                    } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()))) {
                        LOG.error("{} was already in relationship {} with {}", new Object[]{user, patch.getRelationshipTO().getType(), otherEnd});
                        SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        assigned.getElements().add("User was already in relationship " + patch.getRelationshipTO().getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                        scce.addException(assigned);
                    } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                        relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()));
                        URelationship newRelationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                        newRelationship.setType(relationshipType);
                        newRelationship.setRightEnd((Any)otherEnd);
                        newRelationship.setLeftEnd((Any)user);
                        user.add((Relationship)newRelationship);
                    } else {
                        LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)user);
                        SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                        scce.addException(unrelatable);
                    }
                }
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        HashSet groups = new HashSet();
        userUR.getMemberships().stream().filter(patch -> patch.getGroup() != null).forEach(patch -> {
            user.getMembership(patch.getGroup()).ifPresent(membership -> {
                user.remove((Membership)membership);
                membership.setLeftEnd(null);
                user.getPlainAttrs((Membership)membership).forEach(attr -> {
                    user.remove((PlainAttr)attr);
                    attr.setOwner(null);
                    attr.setMembership(null);
                    this.plainAttrValueDAO.deleteAll((PlainAttr)attr, anyUtils);
                    this.plainAttrDAO.delete((PlainAttr)attr);
                });
                if (patch.getOperation() == PatchOperation.DELETE) {
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()));
                }
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = (Group)this.groupDAO.find(patch.getGroup());
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)patch.getGroup());
                } else if (groups.contains(group.getKey())) {
                    LOG.error("Multiple patches for group {} of {} were found", (Object)group, (Object)user);
                    SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    assigned.getElements().add("Multiple patches for group " + group.getName() + " were found");
                    scce.addException(assigned);
                } else {
                    groups.add(group.getKey());
                    UMembership newMembership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)user);
                    user.add((Membership)newMembership);
                    patch.getPlainAttrs().forEach(attrTO -> {
                        PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                        if (schema == null) {
                            LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        } else {
                            UPlainAttr attr = user.getPlainAttr(schema.getKey(), (Membership)newMembership).orElse(null);
                            if (attr == null) {
                                LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)newMembership.getRightEnd());
                                attr = (UPlainAttr)anyUtils.newPlainAttr();
                                attr.setOwner((Any)user);
                                attr.setMembership((Membership)newMembership);
                                attr.setSchema(schema);
                                user.add((PlainAttr)attr);
                                this.processAttrPatch((Any)user, (AttrPatch)new AttrPatch.Builder(attrTO).build(), schema, (PlainAttr<?>)attr, anyUtils, invalidValues);
                            }
                        }
                    });
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                    if (toBeUpdated.canDecodeSecrets()) {
                        if (userUR.getPassword() == null) {
                            userUR.setPassword(new PasswordPatch());
                        }
                        group.getResources().stream().filter(this::isPasswordMapped).forEach(resource -> userUR.getPassword().getResources().add(resource.getKey()));
                    }
                }
            }
        });
        userUR.getLinkedAccounts().stream().filter(patch -> patch.getLinkedAccountTO() != null).forEach(patch -> {
            user.getLinkedAccount(patch.getLinkedAccountTO().getResource(), patch.getLinkedAccountTO().getConnObjectKeyValue()).ifPresent(account -> {
                if (patch.getOperation() == PatchOperation.DELETE) {
                    user.getLinkedAccounts().remove(account);
                    account.setOwner(null);
                    propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
                }
                account.getPlainAttrs().stream().collect(Collectors.toSet()).forEach(attr -> {
                    account.remove((PlainAttr)attr);
                    attr.setOwner(null);
                    attr.setAccount(null);
                    this.plainAttrValueDAO.deleteAll((PlainAttr)attr, this.anyUtilsFactory.getLinkedAccountInstance());
                    this.plainAttrDAO.delete((PlainAttr)attr);
                });
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                this.linkedAccount(user, patch.getLinkedAccountTO(), this.anyUtilsFactory.getLinkedAccountInstance(), invalidValues);
            }
        });
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        if (scce.hasExceptions()) {
            throw scce;
        }
        User saved = (User)this.userDAO.save((Any)user);
        Map<String, ConnObject> afterOnResources = this.onResources((Any<?>)user, this.userDAO.findAllResourceKeys(user.getKey()), password, changePwd);
        propByRes.merge(this.propByRes(beforeOnResources, afterOnResources));
        if (userUR.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userUR.getMustChangePassword().getValue()).booleanValue());
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)anyUtils.getAllResources((Any)saved).stream().map(resource -> resource.getProvisionByAnyType(saved.getType().getKey()).filter(arg_0 -> ((MappingManager)this.mappingManager).hasMustChangePassword(arg_0)).map(provision -> resource.getKey()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return Pair.of((Object)propByRes, (Object)propByLinkedAccount);
    }

    protected LinkedAccountTO getLinkedAccountTO(LinkedAccount account, boolean returnPasswordValue) {
        LinkedAccountTO accountTO = new LinkedAccountTO.Builder(account.getKey(), account.getResource().getKey(), account.getConnObjectKeyValue()).username(account.getUsername()).password(returnPasswordValue ? account.getPassword() : null).suspended(BooleanUtils.isTrue((Boolean)account.isSuspended())).build();
        account.getPlainAttrs().forEach(plainAttr -> accountTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        accountTO.getPrivileges().addAll(account.getPrivileges().stream().map(Entity::getKey).collect(Collectors.toList()));
        return accountTO;
    }

    @Transactional(readOnly=true)
    public LinkedAccountTO getLinkedAccountTO(LinkedAccount account) {
        return this.getLinkedAccountTO(account, true);
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(User user, boolean details) {
        Boolean returnPasswordValue = (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "return.password.value", (Object)Boolean.FALSE, Boolean.class);
        UserTO userTO = new UserTO();
        userTO.setKey(user.getKey());
        userTO.setUsername(user.getUsername());
        if (returnPasswordValue.booleanValue()) {
            userTO.setPassword(user.getPassword());
            userTO.setSecurityAnswer(user.getSecurityAnswer());
        }
        userTO.setType(user.getType().getKey());
        userTO.setCreationDate(user.getCreationDate());
        userTO.setCreator(user.getCreator());
        userTO.setCreationDate(user.getCreationDate());
        userTO.setCreationContext(user.getCreationContext());
        userTO.setLastModifier(user.getLastModifier());
        userTO.setLastChangeDate(user.getLastChangeDate());
        userTO.setLastChangeContext(user.getLastChangeContext());
        userTO.setChangePwdDate(user.getChangePwdDate());
        userTO.setFailedLogins(user.getFailedLogins());
        userTO.setLastLoginDate(user.getLastLoginDate());
        userTO.setToken(user.getToken());
        userTO.setTokenExpireTime(user.getTokenExpireTime());
        userTO.setKey(user.getKey());
        userTO.setUsername(user.getUsername());
        userTO.setType(user.getType().getKey());
        userTO.setStatus(user.getStatus());
        userTO.setSuspended(BooleanUtils.isTrue((Boolean)user.isSuspended()));
        userTO.setMustChangePassword(user.isMustChangePassword());
        if (user.getSecurityQuestion() != null) {
            userTO.setSecurityQuestion(user.getSecurityQuestion().getKey());
        }
        UserDataBinderImpl.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), this.derAttrHandler.getValues((Any)user), details ? this.virAttrHandler.getValues((Any)user) : Map.of(), this.userDAO.findAllResources(user));
        userTO.getDynRealms().addAll(this.userDAO.findDynRealms(user.getKey()));
        if (details) {
            userTO.getRoles().addAll(user.getRoles().stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getDynRoles().addAll(this.userDAO.findDynRoles(user.getKey()).stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getPrivileges().addAll(this.userDAO.findAllRoles(user).stream().flatMap(role -> role.getPrivileges().stream()).map(Entity::getKey).collect(Collectors.toSet()));
            userTO.getRelationships().addAll(user.getRelationships().stream().map(relationship -> UserDataBinderImpl.getRelationshipTO(relationship.getType().getKey(), (AnyObject)relationship.getRightEnd())).collect(Collectors.toList()));
            userTO.getMemberships().addAll(user.getMemberships().stream().map(membership -> UserDataBinderImpl.getMembershipTO(user.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((GroupableRelatable)user, (Membership)membership), this.virAttrHandler.getValues((Any)user, (Membership)membership), membership)).collect(Collectors.toList()));
            userTO.getDynMemberships().addAll(this.userDAO.findDynGroups(user.getKey()).stream().map(group -> new MembershipTO.Builder(group.getKey()).groupName(group.getName()).build()).collect(Collectors.toList()));
            userTO.getLinkedAccounts().addAll(user.getLinkedAccounts().stream().map(account -> this.getLinkedAccountTO((LinkedAccount)account, returnPasswordValue)).collect(Collectors.toList()));
            userTO.getDelegatingDelegations().addAll(this.delegationDAO.findByDelegating(user).stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getDelegatedDelegations().addAll(this.delegationDAO.findByDelegated(user).stream().map(Entity::getKey).collect(Collectors.toList()));
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

