/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.UnaryOp;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.util.InternalException;

class Type
extends UnaryOp {
    private static final long serialVersionUID = 1L;
    Discriminator _disc = null;

    public Type(Val val) {
        super(val);
        this.setMetaData(val.getMetaData());
        if (this.getMetaData() != null) {
            this._disc = ((ClassMapping)this.getMetaData()).getDiscriminator();
        }
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return this.initializeValue(sel, ctx, flags);
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        Object type = null;
        if (this._disc != null && this._disc.getColumns().length > 0) {
            ClassMapping[] subs;
            type = res.getObject(this._disc.getColumns()[0], null, state.joins);
            ClassMapping sup = (ClassMapping)this.getMetaData();
            for (ClassMapping sub : subs = sup.getMappedPCSubclassMappings()) {
                if (!sub.getDiscriminator().getValue().equals(type)) continue;
                return sub.getDescribedType();
            }
        } else {
            type = this.getValue().load(ctx, state, res);
        }
        return type.getClass();
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, null, null);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        if (this._disc != null && this._disc.getColumns().length > 0) {
            sel.select(this._disc.getColumns(), state.joins);
        } else {
            this.getValue().select(sel, ctx, state, pks);
        }
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        this.getValue().calculateValue(sel, ctx, state, null, null);
        this.getValue().appendType(sel, ctx, state, sql);
        sel.append(sql, state.joins);
    }

    @Override
    protected Class getType(Class c) {
        return Class.class;
    }

    @Override
    protected String getOperator() {
        throw new InternalException();
    }

    @Override
    public Path getPath() {
        return this.getValue() instanceof Path ? (Path)this.getValue() : null;
    }

    public Discriminator getDiscriminator() {
        return this._disc;
    }
}

