/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.selectable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.ui.interaction.draggable.Draggable;
import com.googlecode.wicket.jquery.ui.interaction.selectable.ISelectableListener;
import com.googlecode.wicket.jquery.ui.interaction.selectable.SelectableBehavior;
import com.googlecode.wicket.jquery.ui.interaction.selectable.SelectableDraggableFactory;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;

public class Selectable<T extends Serializable>
extends JQueryGenericContainer<List<T>>
implements ISelectableListener<T> {
    private static final long serialVersionUID = 1L;
    private IModel<? extends List<T>> items;

    public Selectable(String id, List<T> items) {
        this(id, Model.ofList(items));
    }

    public Selectable(String id, IModel<? extends List<T>> items) {
        super(id, (IModel)new ListModel());
        this.items = this.wrap(items);
    }

    public Selectable(String id, IModel<? extends List<T>> model, List<T> items) {
        this(id, model, Model.ofList(items));
    }

    public Selectable(String id, IModel<? extends List<T>> model, IModel<? extends List<T>> items) {
        super(id, model);
        this.items = this.wrap(items);
    }

    protected List<T> getItemList() {
        return (List)this.items.getObject();
    }

    protected String getItemSelector() {
        return "li";
    }

    protected void onConfigure() {
        super.onConfigure();
        this.add(new Behavior[]{this.newSelectedBehavior()});
    }

    public void onSelect(AjaxRequestTarget target) {
    }

    @Override
    public final void onSelect(AjaxRequestTarget target, List<T> items) {
        this.setModelObject(items);
        this.onSelect(target);
    }

    protected void onDetach() {
        super.onDetach();
        this.items.detach();
    }

    protected JQueryAbstractBehavior newSelectedBehavior() {
        return new JQueryAbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public boolean isTemporary(Component component) {
                return true;
            }

            private String getSelector() {
                return String.format("%s %s", IJQueryWidget.JQueryWidget.getSelector((Component)Selectable.this), Selectable.this.getItemSelector());
            }

            protected String $() {
                StringBuilder statement = new StringBuilder("");
                List list = (List)Selectable.this.getModelObject();
                if (list != null) {
                    List items = Selectable.this.getItemList();
                    for (Serializable item : list) {
                        int index = items.indexOf(item);
                        if (index <= -1) continue;
                        statement.append("jQuery('").append(this.getSelector()).append("').eq(").append(index).append(").addClass('ui-selected');");
                    }
                }
                return statement.toString();
            }
        };
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SelectableBehavior<T>(selector, (ISelectableListener)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<T> getItemList() {
                return Selectable.this.getItemList();
            }

            @Override
            protected String getItemSelector() {
                return Selectable.this.getItemSelector();
            }
        };
    }

    public Draggable<?> createDraggable(String id) {
        return this.createDraggable(id, new DefaultDraggableFactory());
    }

    public Draggable<?> createDraggable(String id, SelectableDraggableFactory factory) {
        return factory.create(id, IJQueryWidget.JQueryWidget.getSelector((Component)this));
    }

    class DefaultDraggableFactory
    extends SelectableDraggableFactory {
        private static final long serialVersionUID = 1L;

        DefaultDraggableFactory() {
        }

        protected Draggable<T> create(String id, String selector, final String helper) {
            return new Draggable<T>(id){
                private static final long serialVersionUID = 1L;

                public void onConfigure(JQueryBehavior behavior) {
                    super.onConfigure(behavior);
                    behavior.setOption("helper", (Object)helper);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.append("class", (CharSequence)"ui-icon ui-icon-arrow-4-diag", " ");
                    tag.append("style", (CharSequence)"display: inline-block; background-position: -16px -80px !important;", ";");
                }
            };
        }
    }
}

