/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v11.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.PagedResults;
import net.tirasa.connid.bundles.scim.common.service.AbstractSCIMService;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11BasePatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Group;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11GroupPatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11User;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.framework.common.objects.Attribute;

public class SCIMv11Client
extends AbstractSCIMService<SCIMv11User, SCIMv11Group, SCIMv11BasePatch> {
    public SCIMv11Client(SCIMConnectorConfiguration config) {
        super(config);
    }

    @Override
    public SCIMv11User getUser(String userId) {
        WebClient webClient = this.getWebclient("Users", null).path((Object)userId);
        return this.doGetUser(webClient, SCIMv11User.class, SCIMv11Attribute.class);
    }

    @Override
    public SCIMv11User createUser(SCIMv11User user) {
        return (SCIMv11User)SCIMv11User.class.cast(this.doCreateUser(user));
    }

    @Override
    public SCIMv11User updateUser(SCIMv11User user) {
        return this.doUpdateUser(user, Collections.emptySet(), SCIMv11User.class);
    }

    @Override
    public void deleteUser(String userId) {
        WebClient webClient = this.getWebclient("Users", null).path((Object)userId);
        this.doDeleteUser(userId, webClient);
    }

    @Override
    public void activateUser(String userId) {
        this.doActivateUser(userId);
    }

    @Override
    public boolean testService() {
        HashSet<String> attributesToGet = new HashSet<String>();
        attributesToGet.add("userName");
        return this.getAllUsers(1, 1, attributesToGet) != null;
    }

    @Override
    public SCIMv11Group getGroup(String groupId) {
        return this.doGetGroup(this.getWebclient("Groups", null).path((Object)groupId), SCIMv11Group.class);
    }

    @Override
    public SCIMv11Group updateGroup(SCIMv11Group group) {
        return this.doUpdateGroup(group, Collections.emptySet(), null, SCIMv11Group.class);
    }

    @Override
    public SCIMv11Group updateGroup(String groupId, SCIMv11BasePatch groupPatch) {
        return this.doUpdateGroup(new SCIMv11Group.Builder().id(groupId).build(), Collections.emptySet(), null, SCIMv11Group.class);
    }

    @Override
    protected PagedResults<SCIMv11User> deserializeUserPagedResults(String node) throws JsonProcessingException {
        return (PagedResults)SCIMUtils.MAPPER.readValue(node, (TypeReference)new TypeReference<PagedResults<SCIMv11User>>(){});
    }

    @Override
    protected PagedResults<SCIMv11Group> deserializeGroupPagedResults(String node) throws JsonProcessingException {
        return (PagedResults)SCIMUtils.MAPPER.readValue(node, (TypeReference)new TypeReference<PagedResults<SCIMv11Group>>(){});
    }

    @Override
    protected SCIMv11GroupPatch buildPatchFromAttrs(Set<Attribute> replaceAttributes) {
        return null;
    }
}

