/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v11;

import java.util.List;
import java.util.Map;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11BasePatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Group;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11GroupPatch;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11User;
import net.tirasa.connid.bundles.scim.v11.dto.Scimv11GroupPatchOperation;
import net.tirasa.connid.bundles.scim.v11.service.SCIMv11Client;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv11Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class)
public class SCIMv11Connector
extends AbstractSCIMConnector<SCIMv11User, SCIMv11Group, SCIMv11BasePatch, SCIMv11Client> {
    private Schema schema;

    @Override
    protected SCIMv11Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv11Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), SCIMv11Attribute.class);
        }
        return this.schema;
    }

    @Override
    public SCIMv11Client getClient() {
        return (SCIMv11Client)this.client;
    }

    @Override
    protected SCIMv11User buildNewUserEntity() {
        return new SCIMv11User();
    }

    @Override
    protected SCIMv11Group buildNewGroupEntity() {
        return new SCIMv11Group();
    }

    @Override
    protected void fillGroupPatches(SCIMv11User user, Map<String, SCIMv11BasePatch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> {
            SCIMv11BasePatch cfr_ignored_0 = groupPatches.put((String)grp, new SCIMv11GroupPatch.Builder().members(CollectionUtil.newList((Object[])new Scimv11GroupPatchOperation[]{new Scimv11GroupPatchOperation.Builder().display(user.getDisplayName()).value(user.getId()).build()})).build());
        });
        groupsToRemove.forEach(grp -> {
            SCIMv11BasePatch cfr_ignored_0 = groupPatches.put((String)grp, new SCIMv11GroupPatch.Builder().members(CollectionUtil.newList((Object[])new Scimv11GroupPatchOperation[]{new Scimv11GroupPatchOperation.Builder().operation("delete").display(user.getDisplayName()).value(user.getId()).build()})).build());
        });
    }
}

