/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.AbstractSCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseMeta;
import net.tirasa.connid.bundles.scim.common.dto.SCIMComplexAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMDefaultComplex;
import net.tirasa.connid.bundles.scim.common.dto.SCIMEnterpriseUser;
import net.tirasa.connid.bundles.scim.common.dto.SCIMGenericComplex;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUser;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUserAddress;
import net.tirasa.connid.bundles.scim.common.types.AddressCanonicalType;
import net.tirasa.connid.bundles.scim.common.types.EmailCanonicalType;
import net.tirasa.connid.bundles.scim.common.types.IMCanonicalType;
import net.tirasa.connid.bundles.scim.common.types.PhoneNumberCanonicalType;
import net.tirasa.connid.bundles.scim.common.types.PhotoCanonicalType;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMUserName;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;

public abstract class AbstractSCIMUser<SAT extends SCIMBaseAttribute<SAT>, CT extends SCIMComplexAttribute, MT extends SCIMBaseMeta, EUT extends SCIMEnterpriseUser<?>>
extends AbstractSCIMBaseResource<MT>
implements SCIMUser<MT, EUT> {
    private static final long serialVersionUID = 9147517308573800805L;
    protected Boolean active = true;
    protected List<SCIMUserAddress> addresses = new ArrayList<SCIMUserAddress>();
    protected String displayName;
    protected List<SCIMGenericComplex<EmailCanonicalType>> emails = new ArrayList<SCIMGenericComplex<EmailCanonicalType>>();
    protected List<CT> entitlements = new ArrayList<CT>();
    protected List<BaseResourceReference> groups = new ArrayList<BaseResourceReference>();
    protected List<SCIMGenericComplex<IMCanonicalType>> ims = new ArrayList<SCIMGenericComplex<IMCanonicalType>>();
    protected String locale;
    protected SCIMUserName name;
    protected String nickName;
    protected String password;
    protected List<SCIMGenericComplex<PhoneNumberCanonicalType>> phoneNumbers = new ArrayList<SCIMGenericComplex<PhoneNumberCanonicalType>>();
    protected List<SCIMGenericComplex<PhotoCanonicalType>> photos = new ArrayList<SCIMGenericComplex<PhotoCanonicalType>>();
    protected String profileUrl;
    protected String preferredLanguage;
    protected List<CT> roles = new ArrayList<CT>();
    protected String timezone;
    protected String title;
    protected String userName;
    protected String userType;
    protected List<CT> x509Certificates = new ArrayList<CT>();
    protected String externalId;
    @JsonIgnore
    protected final Map<SAT, List<Object>> scimCustomAttributes = new HashMap<SAT, List<Object>>();
    @JsonIgnore
    protected final Map<String, List<Object>> returnedCustomAttributes = new HashMap<String, List<Object>>();

    public AbstractSCIMUser() {
    }

    protected AbstractSCIMUser(String schemaUri, MT meta) {
        super(meta);
        this.baseSchema = schemaUri;
        this.schemas.add(this.baseSchema);
    }

    public Boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(Boolean active) {
        this.active = active;
    }

    public List<SCIMUserAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<SCIMUserAddress> addresses) {
        this.addresses = addresses;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<SCIMGenericComplex<EmailCanonicalType>> getEmails() {
        return this.emails;
    }

    public List<CT> getEntitlements() {
        return this.entitlements;
    }

    @Override
    public List<BaseResourceReference> getGroups() {
        return this.groups;
    }

    public List<SCIMGenericComplex<IMCanonicalType>> getIms() {
        return this.ims;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public SCIMUserName getName() {
        return this.name;
    }

    public void setName(SCIMUserName name) {
        this.name = name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public List<SCIMGenericComplex<PhoneNumberCanonicalType>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<SCIMGenericComplex<PhotoCanonicalType>> getPhotos() {
        return this.photos;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public List<CT> getRoles() {
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Override
    @JsonIgnore
    public Map<SAT, List<Object>> getSCIMCustomAttributes() {
        return this.scimCustomAttributes;
    }

    @Override
    @JsonIgnore
    public Map<String, List<Object>> getReturnedCustomAttributes() {
        return this.returnedCustomAttributes;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setEmails(List<SCIMGenericComplex<EmailCanonicalType>> emails) {
        this.emails = emails;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setEntitlements(List<CT> entitlements) {
        this.entitlements = entitlements;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setGroups(List<BaseResourceReference> groups) {
        this.groups = groups;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setIms(List<SCIMGenericComplex<IMCanonicalType>> ims) {
        this.ims = ims;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setPhoneNumbers(List<SCIMGenericComplex<PhoneNumberCanonicalType>> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setPhotos(List<SCIMGenericComplex<PhotoCanonicalType>> photos) {
        this.photos = photos;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setRoles(List<CT> roles) {
        this.roles = roles;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setX509Certificates(List<CT> x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    @Override
    @JsonIgnore
    public void fromAttributes(Set<Attribute> attributes) {
        attributes.stream().filter(attribute -> !CollectionUtil.isEmpty((Collection)attribute.getValue())).forEach(attribute -> {
            try {
                this.doSetAttribute(attribute.getName(), attribute.getValue());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "While populating User field from ConnId attribute: {0}", new Object[]{attribute});
            }
        });
    }

    @JsonIgnore
    private void doSetAttribute(String name, List<Object> values) {
        Object value = values.get(0);
        switch (name) {
            case "userName": {
                this.userName = (String)String.class.cast(value);
                break;
            }
            case "name.formatted": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setFormatted((String)String.class.cast(value));
                break;
            }
            case "name.familyName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setFamilyName((String)String.class.cast(value));
                break;
            }
            case "name.givenName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setGivenName((String)String.class.cast(value));
                break;
            }
            case "name.middleName": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setMiddleName((String)String.class.cast(value));
                break;
            }
            case "name.honorificPrefix": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setHonorificPrefix((String)String.class.cast(value));
                break;
            }
            case "name.honorificSuffix": {
                if (this.name == null) {
                    this.name = new SCIMUserName();
                }
                this.name.setHonorificSuffix((String)String.class.cast(value));
                break;
            }
            case "displayName": {
                this.displayName = (String)String.class.cast(value);
                break;
            }
            case "nickName": {
                this.nickName = (String)String.class.cast(value);
                break;
            }
            case "profileUrl": {
                this.profileUrl = (String)String.class.cast(value);
                break;
            }
            case "title": {
                this.title = (String)String.class.cast(value);
                break;
            }
            case "userType": {
                this.userType = (String)String.class.cast(value);
                break;
            }
            case "locale": {
                this.locale = (String)String.class.cast(value);
                break;
            }
            case "preferredLanguage": {
                this.preferredLanguage = (String)String.class.cast(value);
                break;
            }
            case "timezone": {
                this.timezone = (String)String.class.cast(value);
                break;
            }
            case "active": {
                this.active = (Boolean)Boolean.class.cast(value);
                break;
            }
            case "emails.value": {
                this.handleSCIMComplexObject(null, this.emails, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "emails.primary": {
                this.handleSCIMComplexObject(null, this.emails, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "emails.operation": {
                this.handleSCIMComplexObject(null, this.emails, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "emails.work.value": {
                this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "emails.work.primary": {
                this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "emails.work.operation": {
                this.handleSCIMComplexObject(EmailCanonicalType.work, this.emails, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "emails.home.value": {
                this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "emails.home.primary": {
                this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "emails.home.operation": {
                this.handleSCIMComplexObject(EmailCanonicalType.home, this.emails, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "emails.other.value": {
                this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "emails.other.primary": {
                this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "emails.other.operation": {
                this.handleSCIMComplexObject(EmailCanonicalType.other, this.emails, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.value": {
                this.handleSCIMComplexObject(null, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.primary": {
                this.handleSCIMComplexObject(null, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.operation": {
                this.handleSCIMComplexObject(null, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.work.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.work.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.work.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.work, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.home.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.home.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.home.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.home, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.other.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.other.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.other.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.other, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.pager.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.pager.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.pager.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.pager, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.fax.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.fax.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.fax.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.fax, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.mobile.value": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "phoneNumbers.mobile.primary": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "phoneNumbers.mobile.operation": {
                this.handleSCIMComplexObject(PhoneNumberCanonicalType.mobile, this.phoneNumbers, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.value": {
                this.handleSCIMComplexObject(null, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.primary": {
                this.handleSCIMComplexObject(null, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.operation": {
                this.handleSCIMComplexObject(null, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.aim.value": {
                this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.aim.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.aim.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.aim, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.xmpp.value": {
                this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.xmpp.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.xmpp.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.xmpp, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.skype.value": {
                this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.skype.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.skype.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.skype, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.qq.value": {
                this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.qq.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.qq.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.qq, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.yahoo.value": {
                this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.yahoo.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.yahoo.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.yahoo, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.msn.value": {
                this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.msn.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.msn.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.msn, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.icq.value": {
                this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.icq.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.icq.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.icq, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "ims.gtalk.value": {
                this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "ims.gtalk.primary": {
                this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "ims.gtalk.operation": {
                this.handleSCIMComplexObject(IMCanonicalType.gtalk, this.ims, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "photos.photo.value": {
                this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "photos.photo.primary": {
                this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "photos.photo.operation": {
                this.handleSCIMComplexObject(PhotoCanonicalType.photo, this.photos, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "photos.thumbnail.value": {
                this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos, s -> s.setValue((String)String.class.cast(value)));
                break;
            }
            case "photos.thumbnail.primary": {
                this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "photos.thumbnail.operation": {
                this.handleSCIMComplexObject(PhotoCanonicalType.thumbnail, this.photos, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "addresses.streetAddress": {
                this.handleSCIMUserAddressObject(null, s -> s.setStreetAddress((String)String.class.cast(value)));
                break;
            }
            case "addresses.locality": {
                this.handleSCIMUserAddressObject(null, s -> s.setLocality((String)String.class.cast(value)));
                break;
            }
            case "addresses.formatted": {
                this.handleSCIMUserAddressObject(null, s -> s.setFormatted((String)String.class.cast(value)));
                break;
            }
            case "addresses.region": {
                this.handleSCIMUserAddressObject(null, s -> s.setRegion((String)String.class.cast(value)));
                break;
            }
            case "addresses.postalCode": {
                this.handleSCIMUserAddressObject(null, s -> s.setPostalCode((String)String.class.cast(value)));
                break;
            }
            case "addresses.country": {
                this.handleSCIMUserAddressObject(null, s -> s.setCountry((String)String.class.cast(value)));
                break;
            }
            case "addresses.primary": {
                this.handleSCIMUserAddressObject(null, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "addresses.operation": {
                this.handleSCIMUserAddressObject(null, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.streetAddress": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setStreetAddress((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.locality": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setLocality((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.formatted": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setFormatted((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.region": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setRegion((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.postalCode": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setPostalCode((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.country": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setCountry((String)String.class.cast(value)));
                break;
            }
            case "addresses.work.primary": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "addresses.work.operation": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.work, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.streetAddress": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setStreetAddress((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.locality": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setLocality((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.formatted": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setFormatted((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.region": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setRegion((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.postalCode": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setPostalCode((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.country": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setCountry((String)String.class.cast(value)));
                break;
            }
            case "addresses.home.primary": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "addresses.home.operation": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.home, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.streetAddress": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setStreetAddress((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.locality": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setLocality((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.formatted": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setFormatted((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.region": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setRegion((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.postalCode": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setPostalCode((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.country": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setCountry((String)String.class.cast(value)));
                break;
            }
            case "addresses.other.primary": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setPrimary((Boolean)Boolean.class.cast(value)));
                break;
            }
            case "addresses.other.operation": {
                this.handleSCIMUserAddressObject(AddressCanonicalType.other, s -> s.setOperation((String)String.class.cast(value)));
                break;
            }
            case "roles.default.value": {
                this.handleRoles(value);
                break;
            }
            case "entitlements.default.value": {
                this.handleEntitlements(value);
                break;
            }
            case "x509Certificates.default.value": {
                this.handlex509Certificates(value);
                break;
            }
            case "schemas": {
                this.schemas.addAll(new ArrayList<Object>(values));
                break;
            }
        }
    }

    protected abstract void handleRoles(Object var1);

    protected abstract void handlex509Certificates(Object var1);

    protected abstract void handleEntitlements(Object var1);

    @JsonIgnore
    protected <T extends Serializable> void handleSCIMComplexObject(T type, List<SCIMGenericComplex<T>> list, Consumer<SCIMGenericComplex<T>> setter) {
        SCIMGenericComplex<T> selected = null;
        for (SCIMGenericComplex<T> complex : list) {
            if (complex.getType() == null || !complex.getType().equals(type)) continue;
            selected = complex;
            break;
        }
        if (selected == null) {
            selected = new SCIMGenericComplex<T>();
            if (type != null) {
                selected.setType(type);
            }
            list.add(selected);
        }
        setter.accept(selected);
    }

    @JsonIgnore
    private void handleSCIMUserAddressObject(AddressCanonicalType type, Consumer<SCIMUserAddress> setter) {
        SCIMUserAddress selected = null;
        for (SCIMUserAddress complex : this.addresses) {
            if (complex.getType() == null || !complex.getType().equals((Object)type)) continue;
            selected = complex;
            break;
        }
        if (selected == null) {
            selected = new SCIMUserAddress();
            if (type != null) {
                selected.setType(type);
            }
            this.addresses.add(selected);
        }
        setter.accept(selected);
    }

    @JsonIgnore
    private void addAttribute(Set<Attribute> toAttrs, Set<Attribute> attrs, Class<?> type) {
        for (Attribute toAttribute : toAttrs) {
            attrs.add(SCIMAttributeUtils.doBuildAttributeFromClassField(toAttribute.getValue(), toAttribute.getName(), type).build());
        }
    }

    @Override
    @JsonProperty
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getBaseSchema() {
        return this.baseSchema;
    }

    @Override
    @JsonIgnore
    public Set<Attribute> toAttributes(Class<?> type, SCIMConnectorConfiguration configuration) throws IllegalArgumentException, IllegalAccessException {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        SCIMUtils.getAllFieldsList(type).stream().filter(f -> !"LOG".equals(f.getName()) && !"serialVersionUID".equals(f.getName()) && !"RESOURCE_NAME".equals(f.getName()) && !"SCHEMA_URI".equals(f.getName())).forEach(field -> {
            try {
                field.setAccessible(true);
                if (SCIMEnterpriseUser.class.isAssignableFrom(field.getType()) && this.getEnterpriseUser() != null) {
                    field.setAccessible(true);
                    this.addAttribute(this.getEnterpriseUser().toAttributes("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User"), attrs, field.getType());
                } else if (!field.isAnnotationPresent(JsonIgnore.class) && !SCIMUtils.isEmptyObject(field.get(this))) {
                    Object objInstance = field.get(this);
                    if (field.getGenericType().toString().contains(SCIMGenericComplex.class.getName())) {
                        if (field.getGenericType().toString().contains(PhoneNumberCanonicalType.class.getName())) {
                            if (field.getType().equals(List.class)) {
                                List list = (List)objInstance;
                                for (SCIMGenericComplex complex : list) {
                                    this.addAttribute(complex.toAttributes("phoneNumbers", configuration), attrs, field.getType());
                                }
                            } else {
                                SCIMGenericComplex complex = (SCIMGenericComplex)objInstance;
                                this.addAttribute(complex.toAttributes("phoneNumbers", configuration), attrs, field.getType());
                            }
                        } else if (field.getGenericType().toString().contains(IMCanonicalType.class.getName())) {
                            if (field.getType().equals(List.class)) {
                                List list = (List)objInstance;
                                for (SCIMGenericComplex complex : list) {
                                    this.addAttribute(complex.toAttributes("ims", configuration), attrs, field.getType());
                                }
                            } else {
                                SCIMGenericComplex complex = (SCIMGenericComplex)objInstance;
                                this.addAttribute(complex.toAttributes("ims", configuration), attrs, field.getType());
                            }
                        } else if (field.getGenericType().toString().contains(EmailCanonicalType.class.getName())) {
                            if (field.getType().equals(List.class)) {
                                List list = (List)objInstance;
                                for (SCIMGenericComplex complex : list) {
                                    this.addAttribute(complex.toAttributes("emails", configuration), attrs, field.getType());
                                }
                            } else {
                                SCIMGenericComplex complex = (SCIMGenericComplex)objInstance;
                                this.addAttribute(complex.toAttributes("emails", configuration), attrs, field.getType());
                            }
                        } else if (field.getGenericType().toString().contains(PhotoCanonicalType.class.getName())) {
                            if (field.getType().equals(List.class)) {
                                List list = (List)objInstance;
                                for (SCIMGenericComplex complex : list) {
                                    this.addAttribute(complex.toAttributes("photos", configuration), attrs, field.getType());
                                }
                            } else {
                                SCIMGenericComplex complex = (SCIMGenericComplex)objInstance;
                                this.addAttribute(complex.toAttributes("photos", configuration), attrs, field.getType());
                            }
                        }
                    } else if (field.getGenericType().toString().contains(SCIMUserName.class.getName())) {
                        if (field.getType().equals(List.class)) {
                            List list = (List)objInstance;
                            for (SCIMUserName scimUserName : list) {
                                this.addAttribute(scimUserName.toAttributes(), attrs, field.getType());
                            }
                        } else {
                            this.addAttribute(((SCIMUserName)SCIMUserName.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                        }
                    } else if (field.getGenericType().toString().contains(SCIMUserAddress.class.getName())) {
                        if (field.getType().equals(List.class)) {
                            List list = (List)objInstance;
                            for (SCIMUserAddress scimUserAddress : list) {
                                this.addAttribute(scimUserAddress.toAttributes(configuration), attrs, field.getType());
                            }
                        } else {
                            this.addAttribute(((SCIMUserAddress)SCIMUserAddress.class.cast(objInstance)).toAttributes(configuration), attrs, field.getType());
                        }
                    } else if (field.getGenericType().toString().contains(SCIMDefaultComplex.class.getName())) {
                        if (field.getType().equals(List.class)) {
                            List list = (List)objInstance;
                            for (SCIMComplexAttribute ct : list) {
                                String localId = null;
                                if (StringUtil.isNotBlank((String)ct.getValue())) {
                                    if (this.entitlements.contains(ct)) {
                                        localId = "entitlements";
                                    } else if (this.roles.contains(ct)) {
                                        localId = "roles";
                                    }
                                }
                                if (localId == null) continue;
                                this.addAttribute(ct.toAttributes(localId, configuration), attrs, field.getType());
                            }
                        } else {
                            SCIMComplexAttribute ct = (SCIMComplexAttribute)objInstance;
                            String localId = null;
                            if (StringUtil.isNotBlank((String)ct.getValue())) {
                                if (this.entitlements.contains(ct)) {
                                    localId = "entitlements";
                                } else if (this.roles.contains(ct)) {
                                    localId = "roles";
                                } else if (this.groups.contains(ct)) {
                                    localId = "groups";
                                }
                            }
                            if (localId != null) {
                                this.addAttribute(ct.toAttributes(localId, configuration), attrs, field.getType());
                            }
                        }
                    } else if (field.getGenericType().toString().contains(SCIMBaseMeta.class.getName())) {
                        if (field.getType().equals(List.class)) {
                            List list = (List)objInstance;
                            for (SCIMBaseMeta scimMeta : list) {
                                this.addAttribute(scimMeta.toAttributes(), attrs, field.getType());
                            }
                        } else {
                            this.addAttribute(((SCIMBaseMeta)SCIMBaseMeta.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                        }
                    } else if ("groups".equals(field.getName())) {
                        List groupRefs = (List)objInstance;
                        attrs.add(AttributeBuilder.build((String)"groups", (Collection)groupRefs.stream().map(g -> g.getValue()).collect(Collectors.toList())));
                    } else {
                        attrs.add(SCIMAttributeUtils.buildAttributeFromClassField(field, this).build());
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e, "Unable to build user attributes by reflection", new Object[0]);
            }
        });
        return attrs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{active=" + this.active + ", addresses=" + this.addresses + ", displayName=" + this.displayName + ", emails=" + this.emails + ", entitlements=" + this.entitlements + ", groups=" + this.groups + ", ims=" + this.ims + ", locale=" + this.locale + ", name=" + this.name + ", nickName=" + this.nickName + ", password=" + this.password + ", phoneNumbers=" + this.phoneNumbers + ", photos=" + this.photos + ", profileUrl=" + this.profileUrl + ", preferredLanguage=" + this.preferredLanguage + ", roles=" + this.roles + ", timezone=" + this.timezone + ", title=" + this.title + ", userName=" + this.userName + ", userType=" + this.userType + ", x509Certificates=" + this.x509Certificates + ", externalId=" + this.externalId + ", enterpriseUser=" + this.getEnterpriseUser() + ", scimCustomAttributes=" + this.scimCustomAttributes + ", returnedCustomAttributes=" + this.returnedCustomAttributes + '}';
    }
}

