/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.web.flow;

import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OneTimeTokenAccountSaveRegistrationAction<T extends OneTimeTokenAccount>
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OneTimeTokenAccountSaveRegistrationAction.class);
    public static final String REQUEST_PARAMETER_ACCOUNT_NAME = "accountName";
    public static final String REQUEST_PARAMETER_VALIDATE = "validate";
    private final OneTimeTokenCredentialRepository repository;
    private final CasConfigurationProperties casProperties;

    protected OneTimeTokenAccount buildOneTimeTokenAccount(RequestContext requestContext) {
        T currentAcct = this.getCandidateAccountFrom(requestContext);
        String accountName = requestContext.getRequestParameters().getRequired(REQUEST_PARAMETER_ACCOUNT_NAME);
        return OneTimeTokenAccount.builder().username(currentAcct.getUsername()).secretKey(currentAcct.getSecretKey()).validationCode(currentAcct.getValidationCode()).scratchCodes(currentAcct.getScratchCodes()).name(accountName).build();
    }

    protected T getCandidateAccountFrom(RequestContext requestContext) {
        return (T)((OneTimeTokenAccount)requestContext.getFlowScope().get("key", OneTimeTokenAccount.class));
    }

    protected Event doExecute(RequestContext requestContext) {
        try {
            T currentAcct = this.getCandidateAccountFrom(requestContext);
            if (!this.casProperties.getAuthn().getMfa().getGauth().getCore().isMultipleDeviceRegistrationEnabled() && this.repository.count(currentAcct.getUsername()) > 0L) {
                LOGGER.warn("Unable to register multiple devices for [{}]", (Object)currentAcct.getUsername());
                return this.getErrorEvent(requestContext);
            }
            OneTimeTokenAccount account = this.buildOneTimeTokenAccount(requestContext);
            if (!this.validate(account, requestContext)) {
                LOGGER.error("Unable to validate account");
                return this.getErrorEvent(requestContext);
            }
            Boolean validate = requestContext.getRequestParameters().getBoolean(REQUEST_PARAMETER_VALIDATE);
            if (validate == null || !validate.booleanValue()) {
                LOGGER.trace("Storing account [{}]", (Object)account);
                WebUtils.putOneTimeTokenAccount((RequestContext)requestContext, (OneTimeTokenAccount)this.repository.save(account));
            }
            return this.success();
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.getErrorEvent(requestContext);
        }
    }

    protected boolean validate(T account, RequestContext requestContext) {
        return true;
    }

    protected Event getErrorEvent(RequestContext requestContext) {
        return this.error();
    }

    @Generated
    public OneTimeTokenAccountSaveRegistrationAction(OneTimeTokenCredentialRepository repository, CasConfigurationProperties casProperties) {
        this.repository = repository;
        this.casProperties = casProperties;
    }
}

