/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.syncope.common.lib.to.ErrorTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.DomainHolder;

@Provider
@PreMatching
public class CheckDomainFilter
implements ContainerRequestFilter {
    protected final DomainHolder domainHolder;

    public CheckDomainFilter(DomainHolder domainHolder) {
        this.domainHolder = domainHolder;
    }

    public void filter(ContainerRequestContext reqContext) throws IOException {
        String domain = reqContext.getHeaderString("X-Syncope-Domain");
        if (domain != null && !"Master".equals(domain) && !this.domainHolder.getDomains().containsKey(domain)) {
            String message = "Domain '" + domain + "' not available";
            ErrorTO error = new ErrorTO();
            error.setStatus(Response.Status.NOT_FOUND.getStatusCode());
            error.setType(ClientExceptionType.NotFound);
            error.getElements().add(message);
            reqContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).header("Content-Type", (Object)(reqContext.getAcceptableMediaTypes().isEmpty() ? "application/json" : ((MediaType)reqContext.getAcceptableMediaTypes().get(0)).toString())).header("X-Application-Error-Code", (Object)ClientExceptionType.NotFound.name()).header("X-Application-Error-Info", (Object)ClientExceptionType.NotFound.getInfoHeaderValue(message)).build());
        }
    }
}

