/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.lib.types.ReportExecStatus;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ReportLogic
extends AbstractExecutableLogic<ReportTO> {
    protected static final Pattern XSLT_PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][\\w\\-\\.]*");
    protected static final SAXTransformerFactory TRAX_FACTORY;
    protected static final FopFactory FOP_FACTORY;
    protected final ReportDAO reportDAO;
    protected final ReportExecDAO reportExecDAO;
    protected final ConfParamOps confParamOps;
    protected final ReportDataBinder binder;
    protected final EntityFactory entityFactory;

    public ReportLogic(JobManager jobManager, SchedulerFactoryBean scheduler, JobStatusDAO jobStatusDAO, ReportDAO reportDAO, ReportExecDAO reportExecDAO, ConfParamOps confParamOps, ReportDataBinder binder, EntityFactory entityFactory) {
        super(jobManager, scheduler, jobStatusDAO);
        this.reportDAO = reportDAO;
        this.reportExecDAO = reportExecDAO;
        this.confParamOps = confParamOps;
        this.binder = binder;
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('REPORT_CREATE')")
    public ReportTO create(ReportTO reportTO) {
        Report report = (Report)this.entityFactory.newEntity(Report.class);
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, ((Long)this.confParamOps.get(AuthContextUtils.getDomain(), "tasks.interruptMaxRetries", (Object)1L, Long.class)).longValue(), AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_UPDATE')")
    public ReportTO update(ReportTO reportTO) {
        Report report = this.reportDAO.find(reportTO.getKey());
        if (report == null) {
            throw new NotFoundException("Report " + reportTO.getKey());
        }
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobManager.register(report, null, ((Long)this.confParamOps.get(AuthContextUtils.getDomain(), "tasks.interruptMaxRetries", (Object)1L, Long.class)).longValue(), AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @Transactional(readOnly=true)
    public List<ReportTO> list() {
        return this.reportDAO.findAll().stream().map(arg_0 -> ((ReportDataBinder)this.binder).getReportTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public ReportTO read(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        return this.binder.getReportTO(report);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public ExecTO execute(String key, OffsetDateTime startAt, boolean dryRun) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        if (!report.isActive()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Report " + key + " is not active");
            throw sce;
        }
        try {
            this.jobManager.register(report, startAt, ((Long)this.confParamOps.get(AuthContextUtils.getDomain(), "tasks.interruptMaxRetries", (Object)1L, Long.class)).longValue(), AuthContextUtils.getUsername());
            this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Report)report));
        }
        catch (Exception e) {
            LOG.error("While executing report {}", (Object)report, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        ExecTO result = new ExecTO();
        result.setJobType(JobType.REPORT);
        result.setRefKey(report.getKey());
        result.setRefDesc(this.binder.buildRefDesc(report));
        result.setStart(OffsetDateTime.now());
        result.setStatus(ReportExecStatus.STARTED.name());
        result.setMessage("Job fired; waiting for results...");
        result.setExecutor(AuthContextUtils.getUsername());
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    public ReportExec getReportExec(String executionKey) {
        ReportExec reportExec = this.reportExecDAO.find(executionKey);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionKey);
        }
        if (!ReportExecStatus.SUCCESS.name().equals(reportExec.getStatus()) || reportExec.getExecResult() == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidReportExec);
            sce.getElements().add(reportExec.getExecResult() == null ? "No report data produced" : "Report did not run successfully");
            throw sce;
        }
        return reportExec;
    }

    protected Transformer buildXSLTTransformer(String template, Map<String, Object> parameters) throws TransformerConfigurationException {
        Templates templates = TRAX_FACTORY.newTemplates(new StreamSource(IOUtils.toInputStream((String)template, (Charset)StandardCharsets.UTF_8)));
        TransformerHandler transformerHandler = TRAX_FACTORY.newTransformerHandler(templates);
        Transformer transformer = transformerHandler.getTransformer();
        parameters.forEach((name, values) -> {
            if (XSLT_PARAMETER_NAME_PATTERN.matcher((CharSequence)name).matches()) {
                transformer.setParameter((String)name, values);
            }
        });
        return transformer;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    public void exportExecutionResult(OutputStream os, ReportExec reportExec, ReportExecExportFormat format) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(reportExec.getExecResult());
             ZipInputStream zis = new ZipInputStream(bais);){
            zis.getNextEntry();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("status", reportExec.getStatus());
            parameters.put("message", reportExec.getMessage());
            parameters.put("start", reportExec.getStart());
            parameters.put("end", reportExec.getEnd());
            switch (format) {
                case HTML: {
                    Transformer html = this.buildXSLTTransformer(reportExec.getReport().getTemplate().getHTMLTemplate(), parameters);
                    html.setOutputProperty("omit-xml-declaration", "yes");
                    html.transform(new StreamSource(zis), new StreamResult(os));
                    break;
                }
                case PDF: {
                    Transformer pdf = this.buildXSLTTransformer(reportExec.getReport().getTemplate().getFOTemplate(), parameters);
                    pdf.transform(new StreamSource(zis), new SAXResult(FOP_FACTORY.newFop("application/pdf", os).getDefaultHandler()));
                    break;
                }
                case RTF: {
                    Transformer rtf = this.buildXSLTTransformer(reportExec.getReport().getTemplate().getFOTemplate(), parameters);
                    rtf.transform(new StreamSource(zis), new SAXResult(FOP_FACTORY.newFop("application/rtf", os).getDefaultHandler()));
                    break;
                }
                case CSV: {
                    Transformer csv = this.buildXSLTTransformer(reportExec.getReport().getTemplate().getCSVTemplate(), parameters);
                    csv.setOutputProperty("omit-xml-declaration", "yes");
                    csv.transform(new StreamSource(zis), new StreamResult(os));
                    break;
                }
                default: {
                    zis.transferTo(os);
                }
            }
            LOG.debug("Result of {} successfully exported as {}", (Object)reportExec, (Object)format);
        }
        catch (Exception e) {
            LOG.error("While exporting content", (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ReportTO delete(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        ReportTO deletedReport = this.binder.getReportTO(report);
        this.jobManager.unregister(report);
        this.reportDAO.delete(report);
        return deletedReport;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public Pair<Integer, List<ExecTO>> listExecutions(String key, OffsetDateTime before, OffsetDateTime after, int page, int size, List<OrderByClause> orderByClauses) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        Integer count = this.reportExecDAO.count(report, before, after);
        List result = this.reportExecDAO.findAll(report, before, after, page, size, orderByClauses).stream().map(reportExec -> this.binder.getExecTO(reportExec)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.reportExecDAO.findRecent(max).stream().map(reportExec -> this.binder.getExecTO(reportExec)).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ExecTO deleteExecution(String executionKey) {
        ReportExec reportExec = this.reportExecDAO.find(executionKey);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionKey);
        }
        ExecTO reportExecToDelete = this.binder.getExecTO(reportExec);
        this.reportExecDAO.delete(reportExec);
        return reportExecToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, OffsetDateTime before, OffsetDateTime after) {
        Report report = Optional.ofNullable(this.reportDAO.find(key)).orElseThrow(() -> new NotFoundException("Report " + key));
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.reportExecDAO.findAll(report, before, after, -1, -1, List.of()).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(exec.getKey()));
            batchResponseItems.add(item);
            try {
                this.reportExecDAO.delete(exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of report {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        String key = JobNamer.getReportKeyFromJobName((String)jobKey.getName());
        return Optional.ofNullable(this.reportDAO.find(key)).map(f -> Triple.of((Object)JobType.REPORT, (Object)key, (Object)this.binder.buildRefDesc(f))).orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(false);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public JobTO getJob(String key) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        JobTO jobTO = null;
        try {
            jobTO = this.getJobTO(JobNamer.getJobKey((Report)report), false);
        }
        catch (SchedulerException e) {
            LOG.error("Problems while retrieving scheduled job {}", (Object)JobNamer.getJobKey((Report)report), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (jobTO == null) {
            throw new NotFoundException("Job for report " + key);
        }
        return jobTO;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Report report = this.reportDAO.find(key);
        if (report == null) {
            throw new NotFoundException("Report " + key);
        }
        this.doActionJob(JobNamer.getJobKey((Report)report), action);
    }

    @Override
    protected ReportTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && ("create".equals(method.getName()) || "update".equals(method.getName()) || "delete".equals(method.getName()))) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ReportTO)) continue;
                key = ((ReportTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getReportTO(this.reportDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }

    static {
        FOP_FACTORY = new FopFactoryBuilder(new File(".").toURI()).build();
        TRAX_FACTORY = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TRAX_FACTORY.setURIResolver((href, base) -> null);
        try {
            TRAX_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not enable secure XML processing", (Throwable)e);
        }
    }
}

