/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.api.LogicActions;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.job.GroupMemberProvisionTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.quartz.JobDataMap;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class GroupLogic
extends AbstractAnyLogic<GroupTO, GroupCR, GroupUR> {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final SecurityProperties securityProperties;
    protected final AnySearchDAO searchDAO;
    protected final ImplementationDAO implementationDAO;
    protected final TaskDAO taskDAO;
    protected final GroupDataBinder binder;
    protected final GroupProvisioningManager provisioningManager;
    protected final TaskDataBinder taskDataBinder;
    protected final ConfParamOps confParamOps;
    protected final JobManager jobManager;
    protected final SchedulerFactoryBean scheduler;
    protected final EntityFactory entityFactory;

    public GroupLogic(RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils, UserDAO userDAO, GroupDAO groupDAO, SecurityProperties securityProperties, AnySearchDAO searchDAO, ImplementationDAO implementationDAO, TaskDAO taskDAO, GroupDataBinder binder, GroupProvisioningManager provisioningManager, TaskDataBinder taskDataBinder, ConfParamOps confParamOps, JobManager jobManager, SchedulerFactoryBean scheduler, EntityFactory entityFactory) {
        super(realmDAO, anyTypeDAO, templateUtils);
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.securityProperties = securityProperties;
        this.searchDAO = searchDAO;
        this.implementationDAO = implementationDAO;
        this.taskDAO = taskDAO;
        this.binder = binder;
        this.provisioningManager = provisioningManager;
        this.taskDataBinder = taskDataBinder;
        this.confParamOps = confParamOps;
        this.jobManager = jobManager;
        this.scheduler = scheduler;
        this.entityFactory = entityFactory;
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_READ')")
    @Transactional(readOnly=true)
    public GroupTO read(String key) {
        return this.binder.getGroupTO(key);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    @Transactional(readOnly=true)
    public List<GroupTO> own() {
        if (this.securityProperties.getAdminUser().equals(AuthContextUtils.getUsername())) {
            return List.of();
        }
        return this.userDAO.findAllGroups(this.userDAO.findByUsername(AuthContextUtils.getUsername())).stream().map(group -> this.binder.getGroupTO(group, true)).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_SEARCH')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<GroupTO>> search(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, boolean recursive, boolean details) {
        Realm base = Optional.ofNullable(this.realmDAO.findByFullPath(realm)).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_SEARCH")), (String)realm);
        SearchCond effectiveCond = searchCond == null ? this.groupDAO.getAllMatchingCond() : searchCond;
        int count = this.searchDAO.count(base, recursive, authRealms, effectiveCond, AnyTypeKind.GROUP);
        List matching = this.searchDAO.search(base, recursive, authRealms, effectiveCond, page, size, orderBy, AnyTypeKind.GROUP);
        List result = matching.stream().map(group -> this.binder.getGroupTO(group, details)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="hasRole('GROUP_CREATE')")
    public ProvisioningResult<GroupTO> create(GroupCR createReq, boolean nullPriorityAsync) {
        Pair<GroupCR, List<LogicActions>> before = this.beforeCreate(createReq);
        if (((GroupCR)before.getLeft()).getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_CREATE")), (String)((GroupCR)before.getLeft()).getRealm());
        this.groupDAO.securityChecks(authRealms, null, ((GroupCR)before.getLeft()).getRealm());
        Pair created = this.provisioningManager.create((AnyCR)((GroupCR)before.getLeft()), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        return this.afterCreate(this.binder.getGroupTO((String)created.getKey()), (List)created.getRight(), (List)before.getRight());
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public ProvisioningResult<GroupTO> update(GroupUR req, boolean nullPriorityAsync) {
        GroupTO groupTO = this.binder.getGroupTO(req.getKey());
        Pair<GroupUR, List<LogicActions>> before = this.beforeUpdate(req, groupTO.getRealm());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_UPDATE")), (String)groupTO.getRealm());
        this.groupDAO.securityChecks(authRealms, ((GroupUR)before.getLeft()).getKey(), groupTO.getRealm());
        Pair after = this.provisioningManager.update((AnyUR)req, Set.of(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        ProvisioningResult<GroupTO> result = this.afterUpdate(this.binder.getGroupTO(((GroupUR)after.getLeft()).getKey()), (List)after.getRight(), (List)before.getRight());
        authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_UPDATE")), (String)((GroupTO)result.getEntity()).getRealm());
        this.groupDAO.securityChecks(authRealms, ((GroupUR)after.getLeft()).getKey(), ((GroupTO)result.getEntity()).getRealm());
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_DELETE')")
    public ProvisioningResult<GroupTO> delete(String key, boolean nullPriorityAsync) {
        GroupTO group = this.binder.getGroupTO(key);
        Pair<GroupTO, List<LogicActions>> before = this.beforeDelete(group);
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_DELETE")), (String)((GroupTO)before.getLeft()).getRealm());
        this.groupDAO.securityChecks(authRealms, ((GroupTO)before.getLeft()).getKey(), ((GroupTO)before.getLeft()).getRealm());
        List ownedGroups = this.groupDAO.findOwnedByGroup(((GroupTO)before.getLeft()).getKey());
        if (!ownedGroups.isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.GroupOwnership);
            sce.getElements().addAll(ownedGroups.stream().map(g -> g.getKey() + " " + g.getName()).collect(Collectors.toList()));
            throw sce;
        }
        List statuses = this.provisioningManager.delete(((GroupTO)before.getLeft()).getKey(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        GroupTO groupTO = new GroupTO();
        groupTO.setKey(((GroupTO)before.getLeft()).getKey());
        return this.afterDelete(groupTO, statuses, (List)before.getRight());
    }

    protected GroupTO updateChecks(String key) {
        GroupTO group = this.binder.getGroupTO(key);
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_UPDATE")), (String)group.getRealm());
        this.groupDAO.securityChecks(authRealms, group.getKey(), group.getRealm());
        return group;
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public GroupTO unlink(String key, Collection<String> resources) {
        GroupTO groupTO = this.updateChecks(key);
        GroupUR req = (GroupUR)((GroupUR.Builder)new GroupUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).collect(Collectors.toList()))).udynMembershipCond(groupTO.getUDynMembershipCond()).adynMembershipConds(groupTO.getADynMembershipConds()).build();
        return this.binder.getGroupTO(this.provisioningManager.unlink((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public GroupTO link(String key, Collection<String> resources) {
        GroupTO groupTO = this.updateChecks(key);
        GroupUR req = (GroupUR)((GroupUR.Builder)new GroupUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).collect(Collectors.toList()))).udynMembershipCond(groupTO.getUDynMembershipCond()).adynMembershipConds(groupTO.getADynMembershipConds()).build();
        return this.binder.getGroupTO(this.provisioningManager.link((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public ProvisioningResult<GroupTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        GroupTO groupTO = this.updateChecks(key);
        GroupUR req = (GroupUR)((GroupUR.Builder)new GroupUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).collect(Collectors.toList()))).udynMembershipCond(groupTO.getUDynMembershipCond()).adynMembershipConds(groupTO.getADynMembershipConds()).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public ProvisioningResult<GroupTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        GroupTO groupTO = this.updateChecks(key);
        GroupUR req = (GroupUR)((GroupUR.Builder)new GroupUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).collect(Collectors.toList()))).udynMembershipCond(groupTO.getUDynMembershipCond()).adynMembershipConds(groupTO.getADynMembershipConds()).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public ProvisioningResult<GroupTO> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getGroupTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('GROUP_UPDATE')")
    public ProvisioningResult<GroupTO> provision(String key, Collection<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.provision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getGroupTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @PreAuthorize(value="hasRole('TASK_CREATE') and hasRole('TASK_EXECUTE')")
    @Transactional
    public ExecTO provisionMembers(String key, ProvisionAction action) {
        Group group = (Group)this.groupDAO.find(key);
        if (group == null) {
            throw new NotFoundException("Group " + key);
        }
        Implementation jobDelegate = this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> GroupMemberProvisionTaskJobDelegate.class.getName().equals(impl.getBody())).findFirst().orElseGet(() -> {
            Implementation groupMemberProvision = (Implementation)this.entityFactory.newEntity(Implementation.class);
            groupMemberProvision.setKey(GroupMemberProvisionTaskJobDelegate.class.getSimpleName());
            groupMemberProvision.setEngine(ImplementationEngine.JAVA);
            groupMemberProvision.setType("TASKJOB_DELEGATE");
            groupMemberProvision.setBody(GroupMemberProvisionTaskJobDelegate.class.getName());
            groupMemberProvision = this.implementationDAO.save(groupMemberProvision);
            return groupMemberProvision;
        });
        SchedTask task = (SchedTask)this.entityFactory.newEntity(SchedTask.class);
        task.setName((action == ProvisionAction.DEPROVISION ? "de" : "") + "provision members of group " + group.getName());
        task.setActive(true);
        task.setJobDelegate(jobDelegate);
        task = (SchedTask)this.taskDAO.save((Task)task);
        try {
            Map jobDataMap = this.jobManager.register(task, null, ((Long)this.confParamOps.get(AuthContextUtils.getDomain(), "tasks.interruptMaxRetries", (Object)1L, Long.class)).longValue(), AuthContextUtils.getUsername());
            jobDataMap.put("dryRun", false);
            jobDataMap.put("groupKey", key);
            jobDataMap.put("action", action);
            this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Task)task), new JobDataMap(jobDataMap));
        }
        catch (Exception e) {
            LOG.error("While executing task {}", (Object)task, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        ExecTO result = new ExecTO();
        result.setJobType(JobType.TASK);
        result.setRefKey(task.getKey());
        result.setRefDesc(this.taskDataBinder.buildRefDesc((Task)task));
        result.setStart(OffsetDateTime.now());
        result.setStatus("JOB_FIRED");
        result.setMessage("Job fired; waiting for results...");
        return result;
    }

    @Override
    protected GroupTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (args[i] instanceof GroupTO) {
                    key = ((GroupTO)args[i]).getKey();
                    continue;
                }
                if (!(args[i] instanceof GroupUR)) continue;
                key = ((GroupUR)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getGroupTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

