/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.message.BasicHeader;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.DefaultCasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientTrustStoreProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Order(value=-2147483648)
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Core)
@AutoConfiguration
public class CasCoreHttpConfiguration {

    @Configuration(value="CasCoreHttpClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreHttpClientConfiguration {
        private static SimpleHttpClientFactoryBean buildHttpClientFactoryBean(CasSSLContext casSslContext, HostnameVerifier hostnameVerifier, LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            SimpleHttpClientFactoryBean.DefaultHttpClient c = new SimpleHttpClientFactoryBean.DefaultHttpClient();
            HttpClientProperties httpClient = casProperties.getHttpClient();
            c.setConnectionTimeout(Beans.newDuration((String)httpClient.getConnectionTimeout()).toMillis());
            c.setReadTimeout((int)Beans.newDuration((String)httpClient.getReadTimeout()).toMillis());
            if (StringUtils.isNotBlank((CharSequence)httpClient.getProxyHost()) && httpClient.getProxyPort() > 0) {
                c.setProxy(new HttpHost(httpClient.getProxyHost(), httpClient.getProxyPort()));
            }
            c.setSslSocketFactory(trustStoreSslSocketFactory);
            c.setHostnameVerifier(hostnameVerifier);
            c.setSslContext(casSslContext.getSslContext());
            c.setTrustManagers(casSslContext.getTrustManagers());
            ArrayList defaultHeaders = new ArrayList();
            httpClient.getDefaultHeaders().forEach((name, value) -> defaultHeaders.add(new BasicHeader(name, value)));
            c.setDefaultHeaders(defaultHeaders);
            return c;
        }

        private static SimpleHttpClient getHttpClient(boolean redirectEnabled, CasSSLContext casSslContext, HostnameVerifier hostnameVerifier, LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) {
            SimpleHttpClientFactoryBean c = CasCoreHttpClientConfiguration.buildHttpClientFactoryBean(casSslContext, hostnameVerifier, trustStoreSslSocketFactory, casProperties);
            c.setRedirectsEnabled(redirectEnabled);
            c.setCircularRedirectsAllowed(redirectEnabled);
            return c.getObject();
        }

        @ConditionalOnMissingBean(name={"httpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FactoryBean<SimpleHttpClient> httpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) throws Exception {
            return CasCoreHttpClientConfiguration.buildHttpClientFactoryBean(casSslContext, hostnameVerifier, trustStoreSslSocketFactory, casProperties);
        }

        @ConditionalOnMissingBean(name={"noRedirectHttpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HttpClient noRedirectHttpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) throws Exception {
            return CasCoreHttpClientConfiguration.getHttpClient(false, casSslContext, hostnameVerifier, trustStoreSslSocketFactory, casProperties);
        }

        @ConditionalOnMissingBean(name={"supportsTrustStoreSslSocketFactoryHttpClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HttpClient supportsTrustStoreSslSocketFactoryHttpClient(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, @Qualifier(value="trustStoreSslSocketFactory") LayeredConnectionSocketFactory trustStoreSslSocketFactory, CasConfigurationProperties casProperties) throws Exception {
            return CasCoreHttpClientConfiguration.getHttpClient(true, casSslContext, hostnameVerifier, trustStoreSslSocketFactory, casProperties);
        }
    }

    @Configuration(value="CasCoreHttpTlsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreHttpTlsConfiguration {
        @ConditionalOnMissingBean(name={"casSslContext"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSSLContext casSslContext(@Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier, CasConfigurationProperties casProperties) throws Exception {
            HttpClientTrustStoreProperties client = casProperties.getHttpClient().getTruststore();
            if (client.getFile() != null && client.getFile().exists() && StringUtils.isNotBlank((CharSequence)client.getPsw())) {
                return new DefaultCasSSLContext(client.getFile(), client.getPsw(), client.getType(), casProperties.getHttpClient(), hostnameVerifier);
            }
            if (casProperties.getHttpClient().getHostNameVerifier().equalsIgnoreCase("none")) {
                return CasSSLContext.disabled();
            }
            return CasSSLContext.system();
        }
    }

    @Configuration(value="CasCoreHttpHostnameConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreHttpHostnameConfiguration {
        @ConditionalOnMissingBean(name={"hostnameVerifier"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HostnameVerifier hostnameVerifier(CasConfigurationProperties casProperties) {
            if (casProperties.getHttpClient().getHostNameVerifier().equalsIgnoreCase("none")) {
                return NoopHostnameVerifier.INSTANCE;
            }
            return new DefaultHostnameVerifier();
        }
    }

    @Configuration(value="CasCoreHttpSslFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreHttpSslFactoryConfiguration {
        @ConditionalOnMissingBean(name={"trustStoreSslSocketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LayeredConnectionSocketFactory trustStoreSslSocketFactory(@Qualifier(value="casSslContext") CasSSLContext casSslContext, @Qualifier(value="hostnameVerifier") HostnameVerifier hostnameVerifier) {
            return new SSLConnectionSocketFactory(casSslContext.getSslContext(), hostnameVerifier);
        }
    }
}

