/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20DefaultCode;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceToken;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.OAuth)
@AutoConfiguration
public class CasOAuth20ProtocolTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuth20ProtocolTicketCatalogConfiguration.class);

    public void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) {
        LOGGER.trace("Registering core OAuth protocol ticket definitions...");
        this.buildAndRegisterOAuthCodeDefinition(plan, this.buildTicketDefinition(plan, "OC", OAuth20Code.class, OAuth20DefaultCode.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterAccessTokenDefinition(plan, this.buildTicketDefinition(plan, "AT", OAuth20AccessToken.class, OAuth20DefaultAccessToken.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterRefreshTokenDefinition(plan, this.buildTicketDefinition(plan, "RT", OAuth20RefreshToken.class, OAuth20DefaultRefreshToken.class, Integer.MIN_VALUE), casProperties);
        this.buildAndRegisterDeviceTokenDefinition(plan, this.buildTicketDefinition(plan, "ODT", OAuth20DeviceToken.class, OAuth20DefaultDeviceToken.class), casProperties);
        this.buildAndRegisterDeviceUserCodeDefinition(plan, this.buildTicketDefinition(plan, "ODUC", OAuth20DefaultDeviceUserCode.class, OAuth20DeviceUserCode.class), casProperties);
    }

    protected void buildAndRegisterAccessTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getAccessToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getAccessToken().getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getLogout().isRemoveDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterRefreshTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getRefreshToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(casProperties.getLogout().isRemoveDescendantTickets());
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterOAuthCodeDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getCode().getStorageName());
        metadata.getProperties().setStorageTimeout(casProperties.getAuthn().getOauth().getCode().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }

    private void buildAndRegisterDeviceTokenDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getDeviceToken().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getDeviceToken().getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(true);
        this.registerTicketDefinition(plan, metadata);
    }

    private void buildAndRegisterDeviceUserCodeDefinition(TicketCatalog plan, TicketDefinition metadata, CasConfigurationProperties casProperties) {
        metadata.getProperties().setStorageName(casProperties.getAuthn().getOauth().getDeviceUserCode().getStorageName());
        long timeout = Beans.newDuration((String)casProperties.getAuthn().getOauth().getDeviceUserCode().getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        metadata.getProperties().setExcludeFromCascade(true);
        this.registerTicketDefinition(plan, metadata);
    }
}

