/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;

public class CollectionUtils {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    public static final AttributeMap<Object> EMPTY_ATTRIBUTE_MAP = new LocalAttributeMap<Object>(Collections.emptyMap());

    private CollectionUtils() {
    }

    public static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <V> AttributeMap<V> singleEntryMap(String attributeName, V attributeValue) {
        return new LocalAttributeMap<V>(attributeName, attributeValue);
    }

    public static <T> boolean addAllNoDuplicates(List<T> target, T ... objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        boolean changed = false;
        for (T object : objects) {
            if (target.contains(object)) continue;
            target.add(object);
            changed = true;
        }
        return changed;
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E>,
    Serializable {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new UnsupportedOperationException("There are no elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("There are no elements");
        }
    }
}

