/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Reflectable;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.util.collections.AbstractReferenceMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.UserException;

public class Reflection {
    private static final Localizer _loc = Localizer.forPackage(Reflection.class);
    private static Map<Class<?>, Map<String, Method>> getterMethodCache = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private static Map<Class<?>, Map<String, Method>> setterMethodCache = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private static Map<Class<?>, Set<String>> beanPropertiesNameCache = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);

    private static Method getGetterMethod(Class<?> cls, String prop) {
        Method rtnMethod = null;
        Map<String, Method> clsMap = getterMethodCache.get(cls);
        if (clsMap != null) {
            rtnMethod = clsMap.get(prop);
        }
        return rtnMethod;
    }

    private static void setGetterMethod(Class<?> cls, String prop, Method method) {
        ConcurrentReferenceHashMap clsMap = getterMethodCache.get(cls);
        if (clsMap == null) {
            clsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
            getterMethodCache.put(cls, (Map<String, Method>)clsMap);
        }
        clsMap.put((String)prop, (Method)method);
    }

    private static Method getSetterMethod(Class<?> cls, String prop) {
        Method rtnMethod = null;
        Map<String, Method> clsMap = setterMethodCache.get(cls);
        if (clsMap != null) {
            rtnMethod = clsMap.get(prop);
        }
        return rtnMethod;
    }

    private static void setSetterMethod(Class<?> cls, String prop, Method method) {
        ConcurrentReferenceHashMap clsMap = setterMethodCache.get(cls);
        if (clsMap == null) {
            clsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
            setterMethodCache.put(cls, (Map<String, Method>)clsMap);
        }
        clsMap.put((String)prop, (Method)method);
    }

    public static Method findGetter(Class cls, String prop, boolean mustExist) {
        Method m = Reflection.getGetterMethod(cls, prop);
        if (m != null) {
            return m;
        }
        String capProp = StringUtil.capitalize((String)prop);
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                m = Reflection.getDeclaredMethod(c, "get" + capProp, null);
                if (m != null) {
                    Reflection.setGetterMethod(cls, prop, m);
                    return m;
                }
                m = Reflection.getDeclaredMethod(c, "is" + capProp, null);
                if (m != null && (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class)) {
                    Reflection.setGetterMethod(cls, prop, m);
                    return m;
                }
                m = Reflection.getDeclaredMethod(c, "get" + prop, null);
                if (m != null) {
                    Reflection.setGetterMethod(cls, prop, m);
                    return m;
                }
                m = Reflection.getDeclaredMethod(c, "is" + prop, null);
                if (m == null || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class) continue;
                Reflection.setGetterMethod(cls, prop, m);
                return m;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-getter", (Object)cls, (Object)prop));
        }
        return null;
    }

    public static Method findSetter(Class cls, String prop, boolean mustExist) {
        Method getter = Reflection.findGetter(cls, prop, mustExist);
        return getter == null ? null : Reflection.findSetter(cls, prop, getter.getReturnType(), mustExist);
    }

    public static Method findSetter(Class cls, String prop, Class param, boolean mustExist) {
        Method m = Reflection.getSetterMethod(cls, prop);
        if (m != null) {
            return m;
        }
        String name = "set" + StringUtil.capitalize((String)prop);
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                m = Reflection.getDeclaredMethod(c, name, param);
                if (m == null) continue;
                Reflection.setSetterMethod(cls, prop, m);
                return m;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-setter", (Object)cls, (Object)prop));
        }
        return null;
    }

    static Method getDeclaredMethod(Class cls, String name, Class param) {
        Method[] methods = (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction((Class)cls));
        Method candidate = null;
        for (Method method : methods) {
            if (!name.equals(method.getName())) continue;
            Class<?>[] methodParams = method.getParameterTypes();
            if (param == null && methodParams.length == 0) {
                candidate = Reflection.mostDerived(method, candidate);
                continue;
            }
            if (param == null || methodParams.length != 1 || !param.equals(methodParams[0])) continue;
            candidate = Reflection.mostDerived(method, candidate);
        }
        return candidate;
    }

    static Method mostDerived(Method meth1, Method meth2) {
        if (meth1 == null) {
            return meth2;
        }
        if (meth2 == null) {
            return meth1;
        }
        Class<?> cls2 = meth2.getDeclaringClass();
        Class<?> cls1 = meth1.getDeclaringClass();
        if (cls1.equals(cls2)) {
            Class<?> ret2;
            Class<?> ret1 = meth1.getReturnType();
            if (ret1.isAssignableFrom(ret2 = meth2.getReturnType())) {
                return meth2;
            }
            if (ret2.isAssignableFrom(ret1)) {
                return meth1;
            }
            throw new IllegalArgumentException(_loc.get("most-derived-unrelated-same-type", (Object)meth1, (Object)meth2).getMessage());
        }
        if (cls1.isAssignableFrom(cls2)) {
            return meth2;
        }
        if (cls2.isAssignableFrom(cls1)) {
            return meth1;
        }
        throw new IllegalArgumentException(_loc.get("most-derived-unrelated", (Object)meth1, (Object)meth2).getMessage());
    }

    public static Field findField(Class cls, String name, boolean mustExist) {
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                Field f = Reflection.getDeclaredField(c, name);
                if (f == null) continue;
                return f;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-field", (Object)cls, (Object)name));
        }
        return null;
    }

    private static Field getDeclaredField(Class cls, String name) {
        Field[] fields;
        for (Field field : fields = (Field[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction((Class)cls))) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Object get(Object target, Field field) {
        if (target == null || field == null) {
            return null;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.get(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static Object getValue(Object obj, String prop, boolean mustExist) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        Field field = Reflection.findField(cls, prop, false);
        if (field != null) {
            return Reflection.get(obj, field);
        }
        Method getter = Reflection.findGetter(cls, prop, false);
        if (getter != null) {
            return Reflection.get(obj, getter);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-field", cls, (Object)prop));
        }
        return null;
    }

    private static void makeAccessible(AccessibleObject ao, int mods) {
        try {
            if (!Modifier.isPublic(mods) && !ao.isAccessible()) {
                AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)ao, (boolean)true));
            }
        }
        catch (SecurityException se) {
            throw new UserException(_loc.get("reflect-security", (Object)ao)).setFatal(true);
        }
    }

    private static RuntimeException wrapReflectionException(Throwable t, Localizer.Message message) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        t.initCause(new IllegalArgumentException(message.getMessage()));
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new GeneralException(t);
    }

    public static boolean getBoolean(Object target, Field field) {
        if (target == null || field == null) {
            return false;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getBoolean(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static byte getByte(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getByte(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static char getChar(Object target, Field field) {
        if (target == null || field == null) {
            return '\u0000';
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getChar(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static double getDouble(Object target, Field field) {
        if (target == null || field == null) {
            return 0.0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getDouble(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static float getFloat(Object target, Field field) {
        if (target == null || field == null) {
            return 0.0f;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getFloat(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static int getInt(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getInt(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static long getLong(Object target, Field field) {
        if (target == null || field == null) {
            return 0L;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getLong(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static short getShort(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getShort(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-field", target, (Object)field));
        }
    }

    public static Object get(Object target, Method getter) {
        if (target == null || getter == null) {
            return null;
        }
        Reflection.makeAccessible(getter, getter.getModifiers());
        try {
            return getter.invoke(target, (Object[])null);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("get-method", target, (Object)getter));
        }
    }

    public static boolean getBoolean(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? false : (Boolean)o;
    }

    public static byte getByte(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    public static char getChar(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (char)'\u0000' : ((Character)o).charValue();
    }

    public static double getDouble(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    public static float getFloat(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    public static int getInt(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0 : ((Number)o).intValue();
    }

    public static long getLong(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0L : ((Number)o).longValue();
    }

    public static short getShort(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    public static void set(Object target, Field field, Object value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.set(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, value == null ? "" : value.getClass()}));
        }
    }

    public static void set(Object target, Field field, boolean value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setBoolean(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "boolean"}));
        }
    }

    public static void set(Object target, Field field, byte value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setByte(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "byte"}));
        }
    }

    public static void set(Object target, Field field, char value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setChar(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, Character.valueOf(value), "char"}));
        }
    }

    public static void set(Object target, Field field, double value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setDouble(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "double"}));
        }
    }

    public static void set(Object target, Field field, float value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setFloat(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, Float.valueOf(value), "float"}));
        }
    }

    public static void set(Object target, Field field, int value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setInt(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "int"}));
        }
    }

    public static void set(Object target, Field field, long value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setLong(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "long"}));
        }
    }

    public static void set(Object target, Field field, short value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setShort(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-field", new Object[]{target, field, value, "short"}));
        }
    }

    public static void set(Object target, Object value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, boolean value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, byte value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, char value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, double value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, float value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, int value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, long value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, short value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, Method setter, Object value) {
        if (target == null || setter == null) {
            return;
        }
        Reflection.makeAccessible(setter, setter.getModifiers());
        try {
            setter.invoke(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t, _loc.get("set-method", new Object[]{target, setter, value, value == null ? "" : value.getClass()}));
        }
    }

    public static void set(Object target, Method setter, boolean value) {
        Reflection.set(target, setter, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
    }

    public static void set(Object target, Method setter, byte value) {
        Reflection.set(target, setter, (Object)value);
    }

    public static void set(Object target, Method setter, char value) {
        Reflection.set(target, setter, (Object)Character.valueOf(value));
    }

    public static void set(Object target, Method setter, double value) {
        Reflection.set(target, setter, (Object)new Double(value));
    }

    public static void set(Object target, Method setter, float value) {
        Reflection.set(target, setter, (Object)new Float(value));
    }

    public static void set(Object target, Method setter, int value) {
        Reflection.set(target, setter, (Object)value);
    }

    public static void set(Object target, Method setter, long value) {
        Reflection.set(target, setter, (Object)value);
    }

    public static void set(Object target, Method setter, short value) {
        Reflection.set(target, setter, (Object)value);
    }

    public static Set<String> getBeanStylePropertyNames(Class<?> c) {
        if (c == null) {
            return Collections.emptySet();
        }
        Set<String> result = beanPropertiesNameCache.get(c);
        if (result != null) {
            return result;
        }
        Method[] methods = c.getMethods();
        if (methods == null || methods.length < 2) {
            return Collections.emptySet();
        }
        result = new TreeSet<String>();
        for (Method m : methods) {
            if (!m.getName().startsWith("get") || !Reflection.canReflect(m)) continue;
            String prop = StringUtil.capitalize((String)m.getName().substring("get".length()));
            Class<?> rtype = m.getReturnType();
            try {
                Method setter = c.getMethod("set" + prop, rtype);
                if (setter.getReturnType() != Void.TYPE && !setter.getReturnType().isAssignableFrom(c)) continue;
                result.add(prop);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        beanPropertiesNameCache.put(c, result);
        return result;
    }

    public static Set<String> getPublicFieldNames(Class c) {
        if (c == null) {
            return Collections.EMPTY_SET;
        }
        Field[] fields = c.getFields();
        if (fields == null || fields.length == 0) {
            return Collections.EMPTY_SET;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (Field f : fields) {
            if (!Reflection.canReflect(f)) continue;
            result.add(f.getName());
        }
        return result;
    }

    public static <T> Set<T> getFieldValues(Class c, int mods, Class<T> t) {
        if (c == null) {
            return Collections.EMPTY_SET;
        }
        Field[] fields = c.getFields();
        if (fields == null || fields.length == 0) {
            return Collections.EMPTY_SET;
        }
        TreeSet<Object> result = new TreeSet<Object>();
        for (Field f : fields) {
            if (mods != f.getModifiers() || t != Object.class && !t.isAssignableFrom(f.getType()) || !Reflection.canReflect(f)) continue;
            try {
                result.add(f.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }

    static boolean canReflect(Reflectable cls, Reflectable member) {
        if (cls == null || cls.value()) {
            return member == null || member.value();
        }
        return member != null && member.value();
    }

    static boolean canReflect(Field field) {
        Class<?> cls = field.getDeclaringClass();
        return Reflection.canReflect(cls.getAnnotation(Reflectable.class), field.getAnnotation(Reflectable.class));
    }

    static boolean canReflect(Method method) {
        Class cls = Reflection.getDeclaringClass(method);
        if (cls != method.getDeclaringClass()) {
            method = Reflection.getDeclaringMethod(cls, method);
        }
        return Reflection.canReflect(cls.getAnnotation(Reflectable.class), method.getAnnotation(Reflectable.class));
    }

    public static Class getDeclaringClass(Method m) {
        Class<?>[] intfs;
        if (m == null) {
            return null;
        }
        Class<?> cls = m.getDeclaringClass();
        for (Class<?> intf : intfs = cls.getInterfaces()) {
            if (Reflection.getDeclaringMethod(intf, m) == null) continue;
            cls = intf;
        }
        return cls;
    }

    public static Method getDeclaringMethod(Class c, Method m) {
        try {
            Method m0 = c.getMethod(m.getName(), m.getParameterTypes());
            return m0;
        }
        catch (Exception e) {
            return null;
        }
    }
}

