/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;

public class ListQueryParameterObject {
    protected static final OrderBy DEFAULT_ORDER_BY = new OrderBy("RES.ID_", "asc", null);
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected int firstResult = -1;
    protected int maxResults = -1;
    protected Object parameter;
    protected Collection<OrderBy> orderByCollection;
    protected OrderBy defaultOrderBy = DEFAULT_ORDER_BY;
    protected QueryProperty orderProperty;
    protected String nullHandlingColumn;
    protected Query.NullHandlingOnOrder nullHandlingOnOrder;
    protected ResultType resultType;
    protected String databaseType;

    public ListQueryParameterObject() {
    }

    public ListQueryParameterObject(Object parameter, int firstResult, int maxResults) {
        this.parameter = parameter;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    public void addOrder(String column, String sortOrder, Query.NullHandlingOnOrder nullHandlingOnOrder) {
        if (this.orderByCollection == null) {
            this.orderByCollection = new ArrayList<OrderBy>(2);
        }
        this.orderByCollection.add(new OrderBy(column, sortOrder, nullHandlingOnOrder));
    }

    public boolean isNeedsPaging() {
        return this.firstResult >= 0;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getFirstRow() {
        return this.firstResult + 1;
    }

    public int getLastRow() {
        if (this.maxResults == Integer.MAX_VALUE) {
            return this.maxResults;
        }
        return this.firstResult + this.maxResults + 1;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public boolean hasOrderBy() {
        if (this.orderByCollection != null && !this.orderByCollection.isEmpty()) {
            return true;
        }
        return this.defaultOrderBy != null;
    }

    public String getOrderByForWindow() {
        return this.buildOrderBy();
    }

    protected String buildOrderBy() {
        Collection<OrderBy> orderBy = this.getOrderByCollectionSafe();
        if (orderBy.isEmpty()) {
            return "";
        }
        return orderBy.stream().map(this::mapOrderByToSql).collect(Collectors.joining(",", "order by ", ""));
    }

    protected Collection<OrderBy> getOrderByCollectionSafe() {
        if (this.orderByCollection != null && !this.orderByCollection.isEmpty()) {
            return this.orderByCollection;
        }
        if (this.defaultOrderBy != null) {
            return Collections.singleton(this.defaultOrderBy);
        }
        return Collections.emptyList();
    }

    public String getOuterJoinOrderBy() {
        if (this.isNeedsPaging()) {
            if ("mssql".equals(this.databaseType)) {
                return "order by RES.rn asc";
            }
            if ("db2".equals(this.databaseType)) {
                return "order by RES.rnk asc";
            }
            if ("oracle".equals(this.databaseType)) {
                return "order by RES.rnum asc";
            }
        }
        return this.buildOrderBy();
    }

    protected String mapOrderByToSql(OrderBy by) {
        Query.NullHandlingOnOrder nullHandlingOnOrder = by.getNullHandlingOnOrder();
        String columnAndDirection = by.getColumnName() + " " + by.getDirection();
        if (nullHandlingOnOrder == null) {
            return columnAndDirection;
        }
        if (nullHandlingOnOrder == Query.NullHandlingOnOrder.NULLS_FIRST) {
            if ("h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "cockroachdb".equals(this.databaseType) || "oracle".equals(this.databaseType)) {
                return columnAndDirection + " NULLS FIRST";
            }
            if ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType) || "mysql".equals(this.databaseType)) {
                return "CASE WHEN " + by.getColumnName() + " IS NULL THEN 0 ELSE 1 END, " + columnAndDirection;
            }
            return columnAndDirection + " NULLS FIRST";
        }
        if ("h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "cockroachdb".equals(this.databaseType) || "oracle".equals(this.databaseType)) {
            return columnAndDirection + " NULLS LAST";
        }
        if ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType) || "mysql".equals(this.databaseType)) {
            return "CASE WHEN " + by.getColumnName() + " IS NULL THEN 1 ELSE 0 END ASC, " + columnAndDirection;
        }
        return columnAndDirection + " NULLS LAST";
    }

    public String getOrderBy() {
        if (this.isNeedsPaging() && ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType))) {
            return "";
        }
        return this.buildOrderBy();
    }

    protected boolean hasOrderByForColumn(String name) {
        for (OrderBy orderBy : this.getOrderByCollectionSafe()) {
            if (!name.equals(orderBy.getColumnName())) continue;
            return true;
        }
        return false;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getNullHandlingColumn() {
        return this.nullHandlingColumn;
    }

    public void setNullHandlingColumn(String nullHandlingColumn) {
        this.nullHandlingColumn = nullHandlingColumn;
    }

    public static class OrderBy {
        protected final String columnName;
        protected final String direction;
        protected final Query.NullHandlingOnOrder nullHandlingOnOrder;

        public OrderBy(String columnName, String direction, Query.NullHandlingOnOrder nullHandlingOnOrder) {
            this.columnName = columnName;
            this.direction = direction;
            this.nullHandlingOnOrder = nullHandlingOnOrder;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getDirection() {
            return this.direction;
        }

        public Query.NullHandlingOnOrder getNullHandlingOnOrder() {
            return this.nullHandlingOnOrder;
        }
    }

    public static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

