/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.task.JPATaskUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;

public class JPATaskUtilsFactory
implements TaskUtilsFactory {
    protected final Map<TaskType, TaskUtils> instances = new HashMap<TaskType, TaskUtils>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskUtils getInstance(TaskType type) {
        TaskUtils instance;
        Map<TaskType, TaskUtils> map = this.instances;
        synchronized (map) {
            instance = this.instances.get(type);
            if (instance == null) {
                instance = new JPATaskUtils(type);
                ApplicationContextProvider.getBeanFactory().autowireBean((Object)instance);
                this.instances.put(type, instance);
            }
        }
        return instance;
    }

    public TaskUtils getInstance(Task<?> task) {
        TaskType type;
        if (task instanceof PullTask) {
            type = TaskType.PULL;
        } else if (task instanceof PushTask) {
            type = TaskType.PUSH;
        } else if (task instanceof MacroTask) {
            type = TaskType.MACRO;
        } else if (task instanceof SchedTask) {
            type = TaskType.SCHEDULED;
        } else if (task instanceof PropagationTask) {
            type = TaskType.PROPAGATION;
        } else if (task instanceof NotificationTask) {
            type = TaskType.NOTIFICATION;
        } else {
            throw new IllegalArgumentException("Invalid task: " + task);
        }
        return this.getInstance(type);
    }

    public TaskUtils getInstance(Class<? extends TaskTO> taskClass) {
        TaskType type;
        if (taskClass == PropagationTaskTO.class) {
            type = TaskType.PROPAGATION;
        } else if (taskClass == NotificationTaskTO.class) {
            type = TaskType.NOTIFICATION;
        } else if (taskClass == SchedTaskTO.class) {
            type = TaskType.SCHEDULED;
        } else if (taskClass == PullTaskTO.class) {
            type = TaskType.PULL;
        } else if (taskClass == PushTaskTO.class) {
            type = TaskType.PUSH;
        } else if (taskClass == MacroTaskTO.class) {
            type = TaskType.MACRO;
        } else {
            throw new IllegalArgumentException("Invalid TaskTO class: " + taskClass.getName());
        }
        return this.getInstance(type);
    }

    public TaskUtils getInstance(TaskTO taskTO) {
        return this.getInstance(taskTO.getClass());
    }
}

