/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class JPAExternalResourceDAO
extends AbstractDAO<ExternalResource>
implements ExternalResourceDAO {
    protected final TaskDAO taskDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final PolicyDAO policyDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final RealmDAO realmDAO;

    public JPAExternalResourceDAO(TaskDAO taskDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PolicyDAO policyDAO, VirSchemaDAO virSchemaDAO, RealmDAO realmDAO) {
        this.taskDAO = taskDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.policyDAO = policyDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.realmDAO = realmDAO;
    }

    @Transactional(readOnly=true)
    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPAExternalResource.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public ExternalResource find(String name) {
        return (ExternalResource)this.entityManager().find(JPAExternalResource.class, (Object)name);
    }

    public ExternalResource authFind(String key) {
        ExternalResource resource = this.find(key);
        if (resource == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_READ");
        if (authRealms == null || authRealms.isEmpty() || !authRealms.stream().anyMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))) {
            throw new DelegatedAdministrationException(resource.getConnector().getAdminRealm().getFullPath(), ExternalResource.class.getSimpleName(), resource.getKey());
        }
        return resource;
    }

    public List<Provision> findProvisionsByAuxClass(AnyTypeClass anyTypeClass) {
        return this.findAll().stream().flatMap(resource -> resource.getProvisions().stream()).filter(provision -> provision.getAuxClasses().contains(anyTypeClass.getKey())).collect(Collectors.toList());
    }

    public boolean anyItemHaving(Implementation transformer) {
        return this.findAll().stream().flatMap(resource -> resource.getProvisions().stream()).flatMap(provision -> provision.getMapping().getItems().stream()).filter(item -> item.getTransformers().contains(transformer.getKey())).count() > 0L;
    }

    public List<ExternalResource> findByPropagationActions(Implementation propagationActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAExternalResource.class.getSimpleName() + " e WHERE :propagationActions MEMBER OF e.propagationActions", ExternalResource.class);
        query.setParameter("propagationActions", (Object)propagationActions);
        return query.getResultList();
    }

    public List<ExternalResource> findByProvisionSorter(Implementation provisionSorter) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAExternalResource.class.getSimpleName() + " e WHERE e.provisionSorter=:provisionSorter", ExternalResource.class);
        query.setParameter("provisionSorter", (Object)provisionSorter);
        return query.getResultList();
    }

    protected StringBuilder getByPolicyQuery(Class<? extends Policy> policyClass) {
        StringBuilder query = new StringBuilder("SELECT e FROM ").append(JPAExternalResource.class.getSimpleName()).append(" e WHERE e.");
        if (AccountPolicy.class.isAssignableFrom(policyClass)) {
            query.append("accountPolicy");
        } else if (PasswordPolicy.class.isAssignableFrom(policyClass)) {
            query.append("passwordPolicy");
        } else if (PropagationPolicy.class.isAssignableFrom(policyClass)) {
            query.append("propagationPolicy");
        } else if (PullPolicy.class.isAssignableFrom(policyClass)) {
            query.append("pullPolicy");
        } else if (PushPolicy.class.isAssignableFrom(policyClass)) {
            query.append("pushPolicy");
        }
        return query;
    }

    public List<ExternalResource> findByPolicy(Policy policy) {
        TypedQuery query = this.entityManager().createQuery(this.getByPolicyQuery(policy.getClass()).append("=:policy").toString(), ExternalResource.class);
        query.setParameter("policy", (Object)policy);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ExternalResource> findAll() {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_LIST");
        if (CollectionUtils.isEmpty((Collection)authRealms)) {
            return List.of();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + JPAExternalResource.class.getSimpleName() + " e", ExternalResource.class);
        return query.getResultList().stream().filter(resource -> authRealms.stream().anyMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public ExternalResource save(ExternalResource resource) {
        ((JPAExternalResource)resource).list2json();
        return (ExternalResource)this.entityManager().merge((Object)resource);
    }

    public void deleteMapping(String intAttrName) {
        this.findAll().forEach(resource -> {
            AtomicBoolean removed = new AtomicBoolean(false);
            resource.getProvisions().forEach(provision -> removed.set(removed.get() || provision.getMapping() != null && provision.getMapping().getItems().removeIf(item -> intAttrName.equals(item.getIntAttrName()))));
            if (removed.get()) {
                this.entityManager().merge(resource);
            }
        });
    }

    public void delete(String name) {
        ExternalResource resource = this.find(name);
        if (resource == null) {
            return;
        }
        this.taskDAO.deleteAll(resource, TaskType.PROPAGATION);
        this.taskDAO.deleteAll(resource, TaskType.PULL);
        this.taskDAO.deleteAll(resource, TaskType.PUSH);
        this.realmDAO.findByResource(resource).forEach(realm -> realm.getResources().remove(resource));
        this.anyObjectDAO.findByResource(resource).forEach(anyObject -> anyObject.getResources().remove(resource));
        this.userDAO.findLinkedAccountsByResource(resource).forEach(account -> {
            account.getOwner().getLinkedAccounts().remove(account);
            account.setOwner(null);
        });
        this.userDAO.findByResource(resource).forEach(user -> user.getResources().remove(resource));
        this.groupDAO.findByResource(resource).forEach(group -> group.getResources().remove(resource));
        this.policyDAO.findByResource(resource).forEach(policy -> policy.getResources().remove(resource));
        this.virSchemaDAO.find(resource).forEach(arg_0 -> ((VirSchemaDAO)this.virSchemaDAO).delete(arg_0));
        if (resource.getConnector() != null && resource.getConnector().getResources() != null && !resource.getConnector().getResources().isEmpty()) {
            resource.getConnector().getResources().remove(resource);
        }
        resource.setConnector(null);
        this.entityManager().remove((Object)resource);
    }
}

