/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import java.util.HashMap;
import javax.persistence.ValidationMode;
import javax.validation.Validator;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.AttrRepoDAO;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCJWKSDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.ReportTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPEntityDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPEntityDAO;
import org.apache.syncope.core.persistence.api.dao.SRARouteDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.jpa.DomainConfFactory;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.apache.syncope.core.persistence.jpa.RuntimeDomainLoader;
import org.apache.syncope.core.persistence.jpa.StartupDomainLoader;
import org.apache.syncope.core.persistence.jpa.attrvalue.validation.DefaultPlainAttrValidationManager;
import org.apache.syncope.core.persistence.jpa.content.KeymasterConfParamLoader;
import org.apache.syncope.core.persistence.jpa.content.XMLContentExporter;
import org.apache.syncope.core.persistence.jpa.content.XMLContentLoader;
import org.apache.syncope.core.persistence.jpa.dao.JPAAccessTokenDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnyMatchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnyObjectDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnyTypeClassDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnyTypeDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAApplicationDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAttrRepoDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAuditConfDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAuthModuleDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAuthProfileDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPABatchDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPACASSPClientAppDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAConnInstanceDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPADelegationDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPADerSchemaDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPADynRealmDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAEntityCacheDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAExternalResourceDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAFIQLQueryDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAGroupDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAImplementationDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAJobStatusDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAMailTemplateDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPANotificationDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAOIDCJWKSDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAOIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainAttrDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainAttrValueDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainSchemaDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPolicyDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARealmDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARelationshipTypeDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARemediationDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAReportDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAReportExecDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAReportTemplateDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPARoleDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPASAML2IdPEntityDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPASAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPASAML2SPEntityDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPASRARouteDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPASecurityQuestionDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPATaskDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPATaskExecDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAUserDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAVirSchemaDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAWAConfigDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.JPAEntityFactory;
import org.apache.syncope.core.persistence.jpa.entity.am.JPAClientAppUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPolicyUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.task.JPATaskUtilsFactory;
import org.apache.syncope.core.persistence.jpa.spring.CommonEntityManagerFactoryConf;
import org.apache.syncope.core.persistence.jpa.spring.DomainTransactionInterceptorInjector;
import org.apache.syncope.core.persistence.jpa.spring.MultiJarAwarePersistenceUnitPostProcessor;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@EnableConfigurationProperties(value={PersistenceProperties.class})
@Configuration(proxyBeanMethods=false)
public class PersistenceContext {
    private static final Logger OPENJPA_LOG = LoggerFactory.getLogger((String)"org.apache.openjpa");

    @Bean
    public static BeanFactoryPostProcessor domainTransactionInterceptorInjector() {
        return new DomainTransactionInterceptorInjector();
    }

    @ConditionalOnMissingBean
    @Bean
    public SearchCondVisitor searchCondVisitor() {
        return new SearchCondVisitor();
    }

    @Bean
    public Validator localValidatorFactoryBean() {
        return new LocalValidatorFactoryBean();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainAttrValidationManager plainAttrValidationManager() {
        return new DefaultPlainAttrValidationManager();
    }

    @ConditionalOnMissingBean
    @Bean
    public CommonEntityManagerFactoryConf commonEMFConf(PersistenceProperties persistenceProperties) {
        CommonEntityManagerFactoryConf commonEMFConf = new CommonEntityManagerFactoryConf();
        commonEMFConf.setPackagesToScan("org.apache.syncope.core.persistence.jpa.entity");
        commonEMFConf.setValidationMode(ValidationMode.NONE);
        commonEMFConf.setPersistenceUnitPostProcessors(new MultiJarAwarePersistenceUnitPostProcessor());
        HashMap<String, Object> jpaPropertyMap = new HashMap<String, Object>();
        jpaPropertyMap.put("openjpa.Log", "slf4j");
        if (OPENJPA_LOG.isDebugEnabled()) {
            jpaPropertyMap.put("openjpa.Log", "SQL=TRACE");
            jpaPropertyMap.put("openjpa.ConnectionFactoryProperties", "PrintParameters=true, PrettyPrint=true, PrettyPrintLineLength=120");
        }
        jpaPropertyMap.put("openjpa.NontransactionalWrite", false);
        jpaPropertyMap.put("openjpa.jdbc.MappingDefaults", "ForeignKeyDeleteAction=restrict, JoinForeignKeyDeleteAction=restrict,FieldStrategies='java.util.Locale=org.apache.syncope.core.persistence.jpa.openjpa.LocaleValueHandler,java.lang.Boolean=org.apache.syncope.core.persistence.jpa.openjpa.BooleanValueHandler'");
        jpaPropertyMap.put("openjpa.DataCache", "true");
        jpaPropertyMap.put("openjpa.QueryCache", "true");
        jpaPropertyMap.put("openjpa.RemoteCommitProvider", persistenceProperties.getRemoteCommitProvider());
        commonEMFConf.setJpaPropertyMap(jpaPropertyMap);
        return commonEMFConf;
    }

    @ConditionalOnMissingBean
    @Bean
    public XMLContentLoader xmlContentLoader(PersistenceProperties persistenceProperties, ResourceLoader resourceLoader, Environment env) {
        return new XMLContentLoader(resourceLoader.getResource(persistenceProperties.getViewsXML()), resourceLoader.getResource(persistenceProperties.getIndexesXML()), env);
    }

    @ConditionalOnMissingBean
    @Bean
    public XMLContentExporter xmlContentExporter(DomainHolder domainHolder, RealmDAO realmDAO) {
        return new XMLContentExporter(domainHolder, realmDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public KeymasterConfParamLoader keymasterConfParamLoader(ConfParamOps confParamOps) {
        return new KeymasterConfParamLoader(confParamOps);
    }

    @ConditionalOnMissingBean
    @Bean
    public DomainRegistry domainRegistry(Environment env) {
        return new DomainConfFactory(env);
    }

    @ConditionalOnMissingBean
    @Bean
    public RuntimeDomainLoader runtimeDomainLoader(DomainHolder domainHolder, DomainRegistry domainRegistry, ListableBeanFactory beanFactory) {
        return new RuntimeDomainLoader(domainHolder, domainRegistry, beanFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public StartupDomainLoader startupDomainLoader(PersistenceProperties persistenceProperties, ResourceLoader resourceLoader, DomainOps domainOps, DomainHolder domainHolder, DomainRegistry domainRegistry) {
        return new StartupDomainLoader(domainOps, domainHolder, persistenceProperties, resourceLoader, domainRegistry);
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityFactory entityFactory() {
        return new JPAEntityFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyUtilsFactory anyUtilsFactory(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy EntityFactory entityFactory) {
        return new JPAAnyUtilsFactory(userDAO, groupDAO, anyObjectDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ClientAppUtilsFactory clientAppUtilsFactory() {
        return new JPAClientAppUtilsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyUtilsFactory policyUtilsFactory() {
        return new JPAPolicyUtilsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskUtilsFactory taskUtilsFactory() {
        return new JPATaskUtilsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public EntityCacheDAO entityCacheDAO() {
        return new JPAEntityCacheDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenDAO accessTokenDAO() {
        return new JPAAccessTokenDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ApplicationDAO applicationDAO(RoleDAO roleDAO, @Lazy UserDAO userDAO) {
        return new JPAApplicationDAO(roleDAO, userDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyMatchDAO anyMatchDAO(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, RealmDAO realmDAO, PlainSchemaDAO plainSchemaDAO, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator) {
        return new JPAAnyMatchDAO(userDAO, groupDAO, anyObjectDAO, realmDAO, plainSchemaDAO, anyUtilsFactory, validator);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectDAO anyObjectDAO(AnyUtilsFactory anyUtilsFactory, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy DerSchemaDAO derSchemaDAO, @Lazy DynRealmDAO dynRealmDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO) {
        return new JPAAnyObjectDAO(anyUtilsFactory, plainSchemaDAO, derSchemaDAO, dynRealmDAO, userDAO, groupDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnySearchDAO anySearchDAO(RealmDAO realmDAO, @Lazy DynRealmDAO dynRealmDAO, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator) {
        return new JPAAnySearchDAO(realmDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeDAO anyTypeDAO(RemediationDAO remediationDAO) {
        return new JPAAnyTypeDAO(remediationDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeClassDAO anyTypeClassDAO(AnyTypeDAO anyTypeDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, @Lazy GroupDAO groupDAO, ExternalResourceDAO resourceDAO) {
        return new JPAAnyTypeClassDAO(anyTypeDAO, plainSchemaDAO, derSchemaDAO, virSchemaDAO, groupDAO, resourceDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditConfDAO auditConfDAO() {
        return new JPAAuditConfDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthModuleDAO authModuleDAO(PolicyDAO policyDAO) {
        return new JPAAuthModuleDAO(policyDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public AttrRepoDAO attrRepoDAO() {
        return new JPAAttrRepoDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthProfileDAO authProfileDAO() {
        return new JPAAuthProfileDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public BatchDAO batchDAO() {
        return new JPABatchDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public CASSPClientAppDAO casSPClientAppDAO() {
        return new JPACASSPClientAppDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnInstanceDAO connInstanceDAO(@Lazy ExternalResourceDAO resourceDAO) {
        return new JPAConnInstanceDAO(resourceDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public DelegationDAO delegationDAO() {
        return new JPADelegationDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public FIQLQueryDAO fiqlQueryDAO() {
        return new JPAFIQLQueryDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public DerSchemaDAO derSchemaDAO(@Lazy ExternalResourceDAO resourceDAO) {
        return new JPADerSchemaDAO(resourceDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public DynRealmDAO dynRealmDAO(ApplicationEventPublisher publisher, @Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, AnySearchDAO searchDAO, AnyMatchDAO anyMatchDAO, SearchCondVisitor searchCondVisitor) {
        return new JPADynRealmDAO(publisher, userDAO, groupDAO, anyObjectDAO, searchDAO, anyMatchDAO, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupDAO groupDAO(ApplicationEventPublisher publisher, AnyUtilsFactory anyUtilsFactory, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy DerSchemaDAO derSchemaDAO, @Lazy DynRealmDAO dynRealmDAO, AnyMatchDAO anyMatchDAO, PlainAttrDAO plainAttrDAO, @Lazy UserDAO userDAO, @Lazy AnyObjectDAO anyObjectDAO, AnySearchDAO anySearchDAO, SearchCondVisitor searchCondVisitor) {
        return new JPAGroupDAO(anyUtilsFactory, publisher, plainSchemaDAO, derSchemaDAO, dynRealmDAO, anyMatchDAO, plainAttrDAO, userDAO, anyObjectDAO, anySearchDAO, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public ImplementationDAO implementationDAO(@Lazy ExternalResourceDAO resourceDAO, @Lazy EntityCacheDAO entityCacheDAO) {
        return new JPAImplementationDAO(resourceDAO, entityCacheDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public JobStatusDAO jobStatusDAO() {
        return new JPAJobStatusDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public MailTemplateDAO mailTemplateDAO() {
        return new JPAMailTemplateDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationDAO notificationDAO(TaskDAO taskDAO) {
        return new JPANotificationDAO(taskDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCJWKSDAO oidcJWKSDAO() {
        return new JPAOIDCJWKSDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCRPClientAppDAO oidcRPClientAppDAO() {
        return new JPAOIDCRPClientAppDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainAttrDAO plainAttrDAO() {
        return new JPAPlainAttrDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainAttrValueDAO plainAttrValueDAO() {
        return new JPAPlainAttrValueDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainSchemaDAO plainSchemaDAO(AnyUtilsFactory anyUtilsFactory, PlainAttrDAO plainAttrDAO, @Lazy ExternalResourceDAO resourceDAO) {
        return new JPAPlainSchemaDAO(anyUtilsFactory, plainAttrDAO, resourceDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyDAO policyDAO(@Lazy RealmDAO realmDAO, @Lazy ExternalResourceDAO resourceDAO, @Lazy CASSPClientAppDAO casSPClientAppDAO, @Lazy OIDCRPClientAppDAO oidcRPClientAppDAO, @Lazy SAML2SPClientAppDAO saml2SPClientAppDAO, @Lazy EntityCacheDAO entityCacheDAO) {
        return new JPAPolicyDAO(realmDAO, resourceDAO, casSPClientAppDAO, oidcRPClientAppDAO, saml2SPClientAppDAO, entityCacheDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public RealmDAO realmDAO(@Lazy RoleDAO roleDAO) {
        return new JPARealmDAO(roleDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public RelationshipTypeDAO relationshipTypeDAO() {
        return new JPARelationshipTypeDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public RemediationDAO remediationDAO() {
        return new JPARemediationDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportTemplateDAO reportTemplateDAO() {
        return new JPAReportTemplateDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportDAO reportDAO() {
        return new JPAReportDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportExecDAO reportExecDAO() {
        return new JPAReportExecDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public ExternalResourceDAO resourceDAO(TaskDAO taskDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PolicyDAO policyDAO, VirSchemaDAO virSchemaDAO, RealmDAO realmDAO) {
        return new JPAExternalResourceDAO(taskDAO, anyObjectDAO, userDAO, groupDAO, policyDAO, virSchemaDAO, realmDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public RoleDAO roleDAO(ApplicationEventPublisher publisher, @Lazy AnyMatchDAO anyMatchDAO, @Lazy AnySearchDAO anySearchDAO, DelegationDAO delegationDAO, SearchCondVisitor searchCondVisitor) {
        return new JPARoleDAO(anyMatchDAO, publisher, anySearchDAO, delegationDAO, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPClientAppDAO saml2SPClientAppDAO() {
        return new JPASAML2SPClientAppDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2IdPEntityDAO saml2IdPEntityDAO() {
        return new JPASAML2IdPEntityDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPEntityDAO saml2SPEntityDAO() {
        return new JPASAML2SPEntityDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public SecurityQuestionDAO securityQuestionDAO(UserDAO userDAO) {
        return new JPASecurityQuestionDAO(userDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public SRARouteDAO sraRouteDAO() {
        return new JPASRARouteDAO();
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskDAO taskDAO(RealmDAO realmDAO, RemediationDAO remediationDAO, TaskUtilsFactory taskUtilsFactory, SecurityProperties securityProperties) {
        return new JPATaskDAO(realmDAO, remediationDAO, taskUtilsFactory, securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskExecDAO taskExecDAO(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory) {
        return new JPATaskExecDAO(taskDAO, taskUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDAO userDAO(SecurityProperties securityProperties, AnyUtilsFactory anyUtilsFactory, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy DerSchemaDAO derSchemaDAO, @Lazy DynRealmDAO dynRealmDAO, RoleDAO roleDAO, AccessTokenDAO accessTokenDAO, RealmDAO realmDAO, @Lazy GroupDAO groupDAO, DelegationDAO delegationDAO, FIQLQueryDAO fiqlQueryDAO) {
        return new JPAUserDAO(anyUtilsFactory, plainSchemaDAO, derSchemaDAO, dynRealmDAO, roleDAO, accessTokenDAO, realmDAO, groupDAO, delegationDAO, fiqlQueryDAO, securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public VirSchemaDAO virSchemaDAO(@Lazy ExternalResourceDAO resourceDAO) {
        return new JPAVirSchemaDAO(resourceDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAConfigDAO waConfigDAO() {
        return new JPAWAConfigDAO();
    }
}

