/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.role;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.role.RoleWrapper;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;

public class RoleWizardBuilder
extends BaseAjaxWizardBuilder<RoleWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;

    public RoleWizardBuilder(RoleTO roleTO, PageReference pageRef) {
        super(new RoleWrapper(roleTO), pageRef);
    }

    public AjaxWizardBuilder<RoleWrapper> setItem(RoleWrapper item) {
        return (AjaxWizardBuilder)(item != null ? super.setItem((Serializable)new RoleWrapper(item.getInnerObject())) : super.setItem(null));
    }

    protected Serializable onApplyInternal(RoleWrapper modelObject) {
        modelObject.fillDynamicConditions();
        if (this.getOriginalItem() == null || ((RoleWrapper)this.getOriginalItem()).getInnerObject() == null || StringUtils.isBlank((CharSequence)((RoleWrapper)this.getOriginalItem()).getInnerObject().getKey())) {
            RoleRestClient.create(modelObject.getInnerObject());
        } else {
            RoleRestClient.update(modelObject.getInnerObject());
        }
        return null;
    }

    protected WizardModel buildModelSteps(RoleWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Entitlements(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new Realms(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new DynRealms(modelObject.getInnerObject()));
        wizardModel.add((IWizardStep)new Privileges(modelObject.getInnerObject()));
        return wizardModel;
    }

    public static class Privileges
    extends WizardStep {
        private static final long serialVersionUID = 6896014330702958579L;

        public Privileges(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("privileges"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("privileges", (IModel)new PropertyModel((Object)modelObject, "privileges"), (IModel)new ListModel(ApplicationRestClient.list().stream().flatMap(application -> application.getPrivileges().stream()).map(PrivilegeTO::getKey).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class DynRealms
    extends WizardStep {
        private static final long serialVersionUID = 6846234574424462255L;

        public DynRealms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("dynRealms"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("dynRealms", (IModel)new PropertyModel((Object)modelObject, "dynRealms"), (IModel)new ListModel(DynRealmRestClient.list().stream().map(DynRealmTO::getKey).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class Realms
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722257L;

        public Realms(RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("realms"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("realms", (IModel)new PropertyModel((Object)modelObject, "realms"), (IModel)new ListModel(RealmRestClient.list("/").stream().map(RealmTO::getFullPath).collect(Collectors.toList()))).hideLabel().setOutputMarkupId(true)});
        }
    }

    public static class Entitlements
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722256L;

        public Entitlements(final RoleTO modelObject) {
            this.setTitleModel((IModel)new ResourceModel("entitlements"));
            this.add(new Component[]{new AjaxPalettePanel.Builder().build("entitlements", (IModel)new PropertyModel<List<String>>((Object)modelObject, "entitlements"){
                private static final long serialVersionUID = -7809699384012595307L;

                public List<String> getObject() {
                    return new ArrayList<String>(modelObject.getEntitlements());
                }

                public void setObject(List<String> object) {
                    modelObject.getEntitlements().clear();
                    modelObject.getEntitlements().addAll(object);
                }
            }, (IModel)new ListModel(RoleRestClient.getAllAvailableEntitlements())).hideLabel().setOutputMarkupId(true)});
        }
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = 5514523040031722255L;

        public Details(final RoleWrapper modelObject) {
            this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)modelObject.getInnerObject(), "key"), false).setEnabled(StringUtils.isEmpty((CharSequence)modelObject.getInnerObject().getKey()))});
            this.add(new Component[]{new Accordion("dynMembershipCond", List.of(new AbstractTab((IModel)new ResourceModel("dynMembershipCond", "Dynamic USER Membership Conditions")){
                private static final long serialVersionUID = 1037272333056449378L;

                public Panel getPanel(String panelId) {
                    return new UserSearchPanel.Builder((IModel<List<SearchClause>>)new PropertyModel((Object)modelObject, "dynClauses"), RoleWizardBuilder.this.pageRef).required(true).build(panelId);
                }
            }), (IModel)Model.of((Serializable)Integer.valueOf(StringUtils.isBlank((CharSequence)modelObject.getDynMembershipCond()) ? -1 : 0))).setOutputMarkupId(true)});
        }
    }
}

