/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.SchedTaskDirectoryPanel;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class ProvisioningTaskDirectoryPanel<T extends ProvisioningTaskTO>
extends SchedTaskDirectoryPanel<T> {
    private static final long serialVersionUID = 4984337552918213290L;
    private final String resource;

    protected ProvisioningTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, TaskType taskType, T newTaskTO, String resource, PageReference pageRef) {
        super("first", baseModal, multiLevelPanelRef, taskType, newTaskTO, pageRef, false);
        this.resource = resource;
        ((ProvisioningTaskTO)this.schedTaskTO).setResource(resource);
        this.enableUtilityButton();
        super.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.of(10L, ChronoUnit.SECONDS)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                ProvisioningTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{ProvisioningTaskDirectoryPanel.this.container});
            }
        }});
    }

    @Override
    protected void initResultTable() {
    }

    @Override
    protected List<IColumn<T, String>> getFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.addAll(this.getHeadingFieldColumns());
        if (this.schedTaskTO instanceof PullTaskTO) {
            columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("destinationRealm", (Component)this), (Object)"destinationRealm", "destinationRealm"));
        } else if (this.schedTaskTO instanceof PushTaskTO) {
            columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("sourceRealm", (Component)this), (Object)"sourceRealm", "sourceRealm"));
        }
        columns.addAll(this.getTrailingFieldColumns());
        return columns;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JobActionPanel.JobActionPayload) {
            this.container.modelChanged();
            ((JobActionPanel.JobActionPayload)JobActionPanel.JobActionPayload.class.cast(event.getPayload())).getTarget().add(new Component[]{this.container});
        } else {
            super.onEvent(event);
        }
    }

    protected class ProvisioningTasksProvider<T extends ProvisioningTaskTO>
    extends SchedTaskDirectoryPanel.SchedTasksProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;

        public ProvisioningTasksProvider(TaskType taskType, int paginatorRows) {
            super(taskType, paginatorRows);
        }

        @Override
        public long size() {
            return TaskRestClient.count(ProvisioningTaskDirectoryPanel.this.resource, this.taskType);
        }

        @Override
        public Iterator<T> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return TaskRestClient.list(ProvisioningTaskDirectoryPanel.this.resource, this.taskType, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }
    }
}

