/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.request.ResourceAR;
import org.apache.syncope.common.lib.request.ResourceDR;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public abstract class AbstractAnyRestClient<TO extends AnyTO>
extends BaseRestClient {
    private static final long serialVersionUID = 1962529678091410544L;

    protected abstract Class<? extends AnyService<TO>> getAnyServiceClass();

    public abstract int count(String var1, String var2, String var3);

    public abstract List<TO> search(String var1, String var2, int var3, int var4, SortParam<String> var5, String var6);

    public TO read(String key) {
        return (TO)AbstractAnyRestClient.getService(this.getAnyServiceClass()).read(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<TO> delete(String etag, String key) {
        ProvisioningResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            result = (ProvisioningResult)AbstractAnyRestClient.getService(etag, this.getAnyServiceClass()).delete(key).readEntity(new GenericType<ProvisioningResult<TO>>(){});
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    private static List<BatchResponseItem> parseBatchResponse(Response response) throws IOException {
        return BatchPayloadParser.parse((InputStream)((InputStream)response.getEntity()), (MediaType)response.getMediaType(), (BatchItem)new BatchResponseItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> associate(ResourceAssociationAction action, String etag, String key, List<StatusBean> statuses) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            Client client = WebClient.client(service);
            List accept = (List)client.getHeaders().get((Object)"Accept");
            if (!accept.contains("multipart/mixed")) {
                client.accept(new String[]{"multipart/mixed"});
            }
            StatusR statusR = StatusUtils.statusR(statuses).build();
            ResourceAR resourceAR = new ResourceAR.Builder().key(key).action(action).onSyncope(statusR.isOnSyncope()).resources((Collection)statusR.getResources()).build();
            try {
                List<BatchResponseItem> items = AbstractAnyRestClient.parseBatchResponse(service.associate(resourceAR));
                for (int i = 0; i < items.size(); ++i) {
                    result.put((String)resourceAR.getResources().get(i), AbstractAnyRestClient.getStatus(items.get(i).getStatus()));
                }
            }
            catch (IOException e) {
                LOG.error("While processing Batch response", (Throwable)e);
            }
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> deassociate(ResourceDeassociationAction action, String etag, String key, List<StatusBean> statuses) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            Client client = WebClient.client(service);
            List accept = (List)client.getHeaders().get((Object)"Accept");
            if (!accept.contains("multipart/mixed")) {
                client.accept(new String[]{"multipart/mixed"});
            }
            ResourceDR resourceDR = new ResourceDR.Builder().key(key).action(action).resources((Collection)StatusUtils.statusR(statuses).build().getResources()).build();
            try {
                List<BatchResponseItem> items = AbstractAnyRestClient.parseBatchResponse(service.deassociate(resourceDR));
                for (int i = 0; i < items.size(); ++i) {
                    result.put((String)resourceDR.getResources().get(i), AbstractAnyRestClient.getStatus(items.get(i).getStatus()));
                }
            }
            catch (IOException e) {
                LOG.error("While processing Batch response", (Throwable)e);
            }
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    public static Map<String, String> batch(BatchRequest batchRequest) {
        ArrayList batchRequestItems = new ArrayList(batchRequest.getItems());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List batchResponseItems = batchRequest.commit().getItems();
            for (int i = 0; i < batchResponseItems.size(); ++i) {
                String status = AbstractAnyRestClient.getStatus(((BatchResponseItem)batchResponseItems.get(i)).getStatus());
                if (((BatchRequestItem)batchRequestItems.get(i)).getRequestURI().endsWith("/status")) {
                    result.put(StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/status"), (String)"/"), status);
                    continue;
                }
                result.put(StringUtils.substringAfterLast((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/"), status);
            }
        }
        catch (IOException e) {
            LOG.error("While processing Batch response", (Throwable)e);
        }
        return result;
    }
}

