/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.tasks.ExecutionsDirectoryPanel;
import org.apache.syncope.client.console.wicket.ajax.form.AjaxDownloadBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class ReportExecutionDetails
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = -4110576026663173545L;

    public ReportExecutionDetails(ReportTO reportTO, PageReference pageRef) {
        MultilevelPanel mlp = new MultilevelPanel("executions");
        this.add(new Component[]{mlp});
        mlp.setFirstLevel((Panel)new ReportExecutionDirectoryPanel(mlp, reportTO.getKey(), new ReportRestClient(), pageRef));
    }

    private static class ReportExecutionDirectoryPanel
    extends ExecutionsDirectoryPanel {
        private static final long serialVersionUID = 5691719817252887541L;
        private final AjaxDownloadBehavior downloadBehavior = new AjaxDownloadBehavior();

        ReportExecutionDirectoryPanel(MultilevelPanel multiLevelPanelRef, String key, ExecutionRestClient executionRestClient, PageReference pageRef) {
            super(multiLevelPanelRef, key, executionRestClient, pageRef);
            this.add(new Behavior[]{this.downloadBehavior});
        }

        @Override
        protected void next(String title, MultilevelPanel.SecondLevel slevel, AjaxRequestTarget target) {
            this.multiLevelPanelRef.next(title, slevel, target);
        }

        @Override
        protected void addFurtherActions(ActionsPanel<ExecTO> panel, final IModel<ExecTO> model) {
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    downloadBehavior.setResponse(new ResponseHolder(ReportRestClient.exportExecutionResult(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.CSV)));
                    downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_CSV, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    downloadBehavior.setResponse(new ResponseHolder(ReportRestClient.exportExecutionResult(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.HTML)));
                    downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_HTML, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    downloadBehavior.setResponse(new ResponseHolder(ReportRestClient.exportExecutionResult(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.PDF)));
                    downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_PDF, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    downloadBehavior.setResponse(new ResponseHolder(ReportRestClient.exportExecutionResult(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.RTF)));
                    downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_RTF, "REPORT_READ");
            panel.add(new ActionLink<ExecTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target, ExecTO ignore) {
                    downloadBehavior.setResponse(new ResponseHolder(ReportRestClient.exportExecutionResult(((ExecTO)model.getObject()).getKey(), ReportExecExportFormat.XML)));
                    downloadBehavior.initiate(target);
                }
            }, ActionLink.ActionType.EXPORT_XML, "REPORT_READ");
        }
    }
}

